#ifndef FILEDATAREGEXP_H
#define FILEDATAREGEXP_H
#include "data.h"
#include "filedatainterpreter.h"
#include "coronadatainterpreter.h"
#include "memedatainterpreter.h"
#include "branchdatainterpreter.h"
#include "tokugidatainterpreter.h"

class FileDataRegExp : public QObject
{
public:
    static FileDataRegExp* getInstance();
    virtual bool Initialize();
    virtual bool Define(QString str, Data * data);

private:
    FileDataRegExp();
    static FileDataRegExp* _singlton;

    static Data* _active;
    static QList<QString> _list;
    static Data* _corona;
    static Data* _meme;
    static Data* _branch;
    static Data* _tokugi;

    static FileDataInterpreter* _interpreter;
    static CoronaDataInterpreter* _ci;
    static MemeDataInterpreter* _mi;
    static BranchDataInterpreter* _bi;
    static TokugiDataInterpreter* _ti;
};

#endif // FILEDATAREGEXP_H
