#include "filedatareader.h"
#include "filedatainterpreter.h"
#include "filedataregexp.h"
#include "coronadatainterpreter.h"
#include <QTextCodec>
#include <QDebug>
#include <QMessageBox>
#include <QFile>
#include <QDir>

FileDataReader::FileDataReader()
{
}

FileDataReader* FileDataReader::_singlton = NULL;
FileDataReader* FileDataReader::GetInstance()
{
    if(_singlton == NULL)
    {
         _singlton = new FileDataReader;
    }
    return _singlton;
}

bool FileDataReader::Read(QString filename, Data* data)
{
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf-8"));

    FileDataRegExp* _fire = FileDataRegExp::getInstance();
    _fire->Initialize();

    QFile file(filename);

    if(!file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QMessageBox::warning(NULL, tr("Warning"), tr("ファイル読み込みエラー"), QMessageBox::Ok, QMessageBox::NoButton);
        return false;
    }
    while (!file.atEnd()) //1行ずつ判別
    {
        QByteArray line = file.readLine();
        QString qline = line;
        qline.remove(QRegExp("\\n"));
      //  fdi->Check(line); //正規表現を用いた判別チェック
        if( !_fire->Define(qline, data) ) // FileDataRegExpが一括
        {
            return false;
        }
        //Chain of Responsibility で回す
        //CoronaDataInterpreter _cdi
        //_cdi->Interpret(str, data);

    }
    return true;
}
