<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="validate" access="public" output="false" returntype="void">
		<cfargument name="fizz" type="any" required="false" />
		<cfargument name="buzz" type="any" required="false" />

		<cfset var fizzbuzz=0 />

		<!---// Fizz̃`FbN //--->
		<cfif not IsDefined("ARGUMENTS.fizz")>
			<cfthrow type="InputValidate" errorcode="FIZZ_NOT_FOUND_1"
					message="Fizz͂Ă" />
		</cfif>
		<cfif ARGUMENTS.fizz is "">
			<cfthrow type="InputValidate" errorcode="FIZZ_NOT_FOUND_2"
					message="Fizz͂Ă" />
		</cfif>
		<cfif not IsNumeric(ARGUMENTS.fizz)>
			<cfthrow type="InputValidate" errorcode="FIZZ_NOT_NUMERIC"
					message="Fizz͐œ͂Ă" />
		</cfif>
		<cfif ARGUMENTS.fizz lte 1 or ARGUMENTS.fizz gt 10>
			<cfthrow type="InputValidate" errorcode="FIZZ_IS_RANGE_OVER"
					message="Fizz110܂łœ͂Ă" />
		</cfif>

		<!---// Buzz̃`FbN //--->
		<cfif not IsDefined("ARGUMENTS.buzz")>
			<cfthrow type="InputValidate" errorcode="BUZZ_NOT_FOUND_1"
					message="Buzz͂Ă" />
		</cfif>
		<cfif ARGUMENTS.buzz is "">
			<cfthrow type="InputValidate" errorcode="BUZZ_NOT_FOUND_2"
					message="Buzz͂Ă" />
		</cfif>
		<cfif not IsNumeric(ARGUMENTS.buzz)>
			<cfthrow type="InputValidate" errorcode="BUZZ_NOT_NUMERIC"
					message="Buzz͐œ͂Ă" />
		</cfif>
		<cfif ARGUMENTS.buzz lte 1 or ARGUMENTS.buzz gt 10>
			<cfthrow type="InputValidate" errorcode="BUZZ_IS_RANGE_OVER"
					message="Buzz110܂łœ͂Ă" />
		</cfif>

		<!---// `FbN //--->
		<cfif ARGUMENTS.fizz is ARGUMENTS.buzz>
			<cfthrow type="InputValidate" errorcode="FIZZ_IS_BUZZ"
					message="FizzBuzzȂ̂̓}YC" />
		</cfif>
	</cffunction>

</cfcomponent>
