<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [/appcore/SessionManager.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset mgr=getComponentManager().getComponent("appcore.SessionManager") />
			<cfset caseNo=0 />
			<fieldset>
				<legend>setValue</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset exp=StructNew() />
					<cfset in["DummySessionScope"]=exp />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset exp[in["name"]]=in["value"] />
					<cfset act=StructNew() />
					<cfset mgr.setValue(act,
							in["name"], in["value"]) />
					<cfset assert(caseNo, 'key=[#in["name"]#]<br />value=[#in["value"]#]',
							in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset exp=StructNew() />
					<cfset in["DummySessionScope"]=exp />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="" />
					<cfset exp[in["name"]]=in["value"] />
					<cfset act=StructNew() />
					<cfset mgr.setValue(act,
							in["name"], in["value"]) />
					<cfset assert(caseNo, "value=󕶎", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cftry>
						<cfset mgr.setValue(StructNew(),
								"", "test-value") />
						<cfcatch>
							<cfset assert(caseNo, "Illegal parameter.", "name=󕶎",
									"SESSIONMANAGER-ERROR-1", cfcatch.ErrorCode) />
						</cfcatch>
					</cftry>
				</table>
			</fieldset>
			<cfset caseNo=0 />
			<fieldset>
				<legend>getValue</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["DummySessionScope"]=StructNew() />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset in["defaultvalue"]="" />
					<cfset exp=StructNew() />
					<cfset exp[in["name"]]=in["value"] />
					<cfset mgr.setValue(in["DummySessionScope"],
							in["name"], in["value"]) />
					<cfset act=mgr.getValue(
							in["DummySessionScope"],
							in["name"],
							in["defaultvalue"]) />
					<cfset assert(caseNo, 'ftHgwB<br />key=[#in["name"]#]'
							& '<br />value=[#in["value"]#]'
							& '<br />defaultvalue=[#in["defaultvalue"]#]',
							in, in["value"], act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["DummySessionScope"]=StructNew() />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset in["defaultvalue"]="test-defaultvalue" />
					<cfset exp=StructNew() />
					<cfset exp[in["name"]]=in["value"] />
					<cfset mgr.setValue(in["DummySessionScope"],
							in["name"], in["value"]) />
					<cfset act=mgr.getValue(
							in["DummySessionScope"],
							in["name"],
							in["defaultvalue"]) />
					<cfset assert(caseNo, 'gpȂftHgݒB<br />key=[#in["name"]#]'
							& '<br />value=[#in["value"]#]'
							& '<br />defaultvalue=[#in["defaultvalue"]#]',
							in, in["value"], act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["DummySessionScope"]=StructNew() />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset in["defaultvalue"]="test-defaultvalue" />
					<cfset exp=StructNew() />
					<cfset exp[in["name"]]=in["value"] />
<!---
					<cfset mgr.setValue(in["DummySessionScope"],
							in["name"], in["value"]) />
--->
					<cfset act=mgr.getValue(
							in["DummySessionScope"],
							in["name"],
							in["defaultvalue"]) />
					<cfset assert(caseNo, '݂ȂnamewB<br />key=[#in["name"]#]'
							& '<br />value=[#in["value"]#]'
							& '<br />defaultvalue=[#in["defaultvalue"]#]',
							in, in["defaultvalue"], act) />
				</table>
			</fieldset>
			<cfset caseNo=0 />
			<fieldset>
				<legend>isExistValue</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="test-key" />
					<cfset str=StructNew() />
					<cfset mgr.setValue(str, in, "test-value") />
					<cfset act=mgr.isExistValue(str, in) />
					<cfset assert(caseNo, "݂L[wB", in,
							true, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="" />
					<cfset str=StructNew() />
					<cfset str[in]="test-value" />
					<cfset act=mgr.isExistValue(str, in) />
					<cfset assert(caseNo, "󕶎L[({Iɑ݂Ȃ̃L[)B", in,
							true, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="test-key2" />
					<cfset str=StructNew() />
					<cfset mgr.setValue(str, "test-key", "test-value") />
					<cfset act=mgr.isExistValue(str, in) />
					<cfset assert(caseNo, "݂ȂL[wB", in,
							false, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
