<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/application.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset logger=getComponentManager().getComponent("appcore.utils.Logger") />
			<cfset futil=getComponentManager().getComponent("appcore.utils.FileUtil") />
			<cfset app=getComponentManager().getComponent("appcore.Application") />
			<fieldset>
				<legend>onApplicationStart</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />
					<cfset assert(caseNo, "onApplicationStarttrueԂ", "invokê",
							true, app.onApplicationStart() ) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset APPLICATION=StructNew() />
					<cfset exp=StructNew() />
					<cfset exp.ApplicationName="cfneo" />
					<cfset exp.debugMode=true />
					<cfset exp.MockupMode=false />
					<cfset exp.ContentsRoot="/cfneo" />
					<cfset exp.TestingRoot="/cfneo/dev/test" />
					<cfset exp.TestDriverTemplatePath="/cfneo/appcore/lib/TestDriverTemplate.cfm" />
					<cfset exp.logfile=ExpandPath("\cfneo\appcore\app.log") />
					<cfset exp.logfile_charset="utf8" />
					<cfset exp.logger=CreateObject("component", "cfneo.appcore.utils.Logger") />
					<cfset assert(caseNo, "onApplicationStartAPPLICATION\̂邩",
							"none", exp, APPLICATION)/>
				</table>
			</fieldset>
			<fieldset>
				<legend>onApplicationEnd</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in=StructNew() />
					<cfset exp="nothing exception" />
					<cfset act=exp />
					<cftry>
						<cfset app.onApplicationEnd(in) />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
					</cftry>
					<cfset assert("1-1", "onApplicationEndsł邩", in, exp, act ) />

					<cfset in=StructNew() />
					<cfset exp=StructNew() />
					<cfset act=StructNew() />
					<cfset app.onApplicationEnd(act) />
					<cfset assert("1-2", "sAp[^ɕω",
							in, exp, act) />

				</table>
			</fieldset>
			<fieldset>
				<legend>onSessionStart</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset exp="nothing exception" />
					<cfset act=exp />
					<cftry>
						<cfset app.onSessionStart() />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
					</cftry>
					<cfset assert(caseNo, "onSessionStartsł邩", "",
							exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>onSessionEnd</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in=StructNew() />
					<cfset in.ses=StructNew() />
					<cfset in.app=StructNew() />
					<cfset act="nothing exception" />
					<cftry>
						<cfset app.onSessionStart(in.ses, in.app) />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
					</cftry>
					<cfset assert("1-1", "onSessionEndsł邩", "",
							"nothing exception", act) />

					<cfset exp=StructNew() />
					<cfset exp.ses=StructNew() />
					<cfset exp.app=StructNew() />
					<cfset act=in />
					<cfset assert("1-2", "sAp[^ɕωȂ", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>onRequestStart</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in="test.url" />
					<cfset exp=true />
					<cfset act=app.onRequestStart(in) />
					<cfset assert("1-1", "onRequestStart̎s", in, exp, act) />

					<cfset exp="test.url" />
					<cfset act=in />
					<cfset assert("1-2", "p[^ɕωȂ", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>onRequest</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/index.cfm">
					<cfset act="nothing exception" />
					<cftry>
						<cfset app.onRequest(in) />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
					</cftry>
					<cfset assert(caseNo, "onRequestsł邩", in,
							"nothing exception", act ) />
				</table>
			</fieldset>
			</fieldset>
			<fieldset>
				<legend>onRequestEnd</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in="test.url" />
					<cfset exp="nothing exception" />
					<cfset act=exp />
					<cftry>
						<cfset app.onRequestEnd(in) />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
					</cftry>
					<cfset assert("1-1", "onRequestEndsł邩", in, exp, act ) />

					<cfset exp="test.url" />
					<cfset act=in />
					<cfset assert("1-2", "p[^ɕωȂ", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>onError</legend>

				<cfset caseNo=0 />

				<cfset caseNo=IncrementValue(caseNo) />
				<cfset in=StructNew() />
				<cfset in.event="dummyEvent" />
				<cfset in.exception=StructNew() />
				<cfset tempDebugMode=APPLICATION.debugMode />
				<cfset APPLICATION.debugMode=true />
				<cfset exp="nothing exception" />
				<cfset act=exp />
				<cftry>
					<cfset app.onError(in.exception, in.event) />
					<cfcatch>
						<cfset act=cfcatch.Message />
					</cfcatch>
				</cftry>
				<cfset assert(caseNo, "s@debugMode=[#APPLICATION.debugMode#]", in, exp, act) />

				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.event="dummyEvent" />
					<cfset tempDebugMode=APPLICATION.debugMode />
					<cfset APPLICATION.debugMode=false />
					<cfset exp="nothing exception" />
					<cfset act=exp />
					<cftry>
						<cftry>
							<cfset VARIABLES.nothingArea />
							<cfcatch>
								<cfset in.exception=cfcatch />
							</cfcatch>
						</cftry>
						<cfset app.onError(in.exception, in.event) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "s@debugMode=[#APPLICATION.debugMode#]", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset tmpDebugMode=APPLICATION.debugMode />
					<cfset APPLICATION.debugMode=false />
					<cfhttp url="http://localhost/cfneo/dev/test/appcore/ErrorScript4ApplicationTest.cfm" 
							port="8500" 
							method="get"
							throwonerror="no" />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')#"
							 & " #TimeFormat(Now(), 'HH:MM:SS')# - " 
							 & "Error : onRequest => Type:Object " 
							 <!---
							 TODO t@N^O邱ƁI 
							 R[hȂƂȂȂ̂ŁAbIɐ擪݂̂r
							 & "Message:CxgnhOłB " 
							 & "Detail:Cxgnh\bh  Application.cfc ĂяoۂɁAO܂B\bh: onRequestB " 
							 --->
							 />
					<cfset act=futil.tailread(APPLICATION.logfile) />
					<!---	TODO t@N^O邱ƁII
							R[hƂȂȂ̂ŁA擪݂̂r@
					--->
					<cfset act=Mid(act,1,Len(exp)) />
					<cfset assert(caseNo, "onError𔭐ł邩", "ʃNGXgŃANZXAError𔭐Ă烍OmF",
							exp, act ) />
					<cfset APPLICATION.debugMode=tmpDebugMode />
				</table>
			</fieldset>
			<fieldset>
				<legend>debuglog</legend>
				OEt@C:[#APPLICATION.logfile#]
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th width="500px">expected</th>
						<th width="500px">actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset logfile=APPLICATION.logfile />
					<cfset APPLICATION.debugMode=true />
					<cfset in="aaa" />
					<cfset app.debuglog(in) />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert(caseNo, "debugOo͂邩<br />debuglog@debugMode:[#APPLICATION.debugMode#]",
							in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset logfile=APPLICATION.logfile />
					<cfset APPLICATION.debugMode=true />
					<cfset in="" />
					<cfset app.debuglog(in) />
					<cfset exp="[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #in#" />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert(caseNo, "debugOo͂邩<br />debuglog@debugMode:[#APPLICATION.debugMode#]<br />󕶎",
							in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset logfile=APPLICATION.logfile />
					<cfset APPLICATION.debugMode=false />
					<cfset in="bbb" />
					<cfset app.debuglog(in) />
					<cfset act=futil.tailRead(APPLICATION.logfile) />
					<cfset assert(caseNo, "debugOo͂Ȃ<br />debuglog@debugMode:[#APPLICATION.debugMode#]",
							in, exp, act) />

				</table>
			</fieldset>
			<fieldset>
				<legend>initializeApp</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset APPLICATION=StructNew() />
					<cfset exp=StructNew() />
					<cfset exp.ApplicationName="cfneo" />
					<cfset exp.debugMode=true />
					<cfset exp.MockupMode=false />
					<cfset exp.ContentsRoot="/cfneo" />
					<cfset exp.TestingRoot="/cfneo/dev/test" />
					<cfset exp.TestDriverTemplatePath="/cfneo/appcore/lib/TestDriverTemplate.cfm" />
					<cfset exp.logfile=ExpandPath("\cfneo\appcore\app.log") />
					<cfset exp.logfile_charset="utf8" />
					<cfset exp.logger=CreateObject("component", "cfneo.appcore.utils.Logger") />
					<cfset app.initializeApp() />
					<cfset assert(caseNo, "APPLICATION\̂K؂ɏ邩", "none", exp, APPLICATION) />
				</table>
			</fieldset>
			<fieldset>
				<legend>getComponentManager</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="appcore.ComponentManager" />
					<cfset exp=CreateObject("component", "cfneo.appcore.ComponentManager") />
					<cfset act=app.getComponentManager() />
					<cfset assert(caseNo, "getComponentł邩", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="poolingCheck" />
					<cfset exp=app.getComponentManager() />
					<cfset exp.poolingCheck=in />
					<cfset act=app.getComponentManager() />
					<cfset assert(caseNo, "REQUESTScopePoolĂ邱Ƃ̊mF", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>setValue</legend>
				<p>ڍׂȃeXg<a href="#APPLICATION.ContentsRoot#/dev/test/appcore/SessionManagerTest.cfm">SessionManager̃eXg</a>ɂĎ{</p>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset exp=StructNew() />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset exp[in["name"]]=in["value"] />
					<cfset app.setValue(
							in["name"], in["value"]) />
					<cfset act=StructNew() />
					<cfset act[in["name"]]=SESSION[in["name"]] />
					<cfset assert(caseNo, 'setValueSESSIONɒli[邩<br/>key=[#in["name"]#]<br />value=[#in["value"]#]',
							in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>getValue</legend>
				<p>ڍׂȃeXg<a href="#APPLICATION.ContentsRoot#/dev/test/appcore/SessionManagerTest.cfm">SessionManager̃eXg</a>ɂĎ{</p>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in["name"]="test-name" />
					<cfset in["value"]="test-value" />
					<cfset exp=StructNew() />
					<cfset exp=in["value"] />
					<cfset app.setValue(in["name"], in["value"]) />
					<cfset act=app.getValue(in["name"]) />
					<cfset assert(caseNo, 'getValueŒl擾ł邩<br/>key=[#in["name"]#]'
							& '<br />value=[#in["value"]#]',
							in, in["value"], act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>isExistValue</legend>
				<p>ڍׂȃeXg<a href="#APPLICATION.ContentsRoot#/dev/test/appcore/SessionManagerTest.cfm">SessionManager̃eXg</a>ɂĎ{</p>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="test-key" />
					<cfset app.setValue( in, "test-value") />
					<cfset act=app.isExistValue(in) />
					<cfset assert(caseNo, "isExistValueŃL[݂邩mFł邩", in,
							true, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
