<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
/**
 * menu class
 *
 * 登録されたマルチビューモジュールをメニュー化しリンクする
 * widget内での表示に適した縦方向メニュー
 *
 */

include_once('./cenote/core/db_class.php');

class mvmenu {
	public function __construct(){

	}
	public function display(){

		$module = $_SESSION['module'];

		$db = new db_class();

		$err = false;

		$m_title ="";
		foreach($module['name'] as $key => $value){
			if($value == "multiview"){
				$m_title = $module['menu'][$key];
				$sql = "SELECT * from cenote_mview order by mview_order";
				$mvmenu = $db->getData2($sql);
			}
		}

		if($m_title == ""){
			$m_title = "マルチビュー";
			$err = true;
		}
		$html = "<table class=\"cenote_mvmenu\"><tr class=\"cenote_mvmenu\"><th class=\"cenote_mvmenu\">$m_title</th></tr>";
		if($err == false){
			if(is_array($mvmenu)){
				foreach($mvmenu['mview_title'] as $key => $title){
					$id = $mvmenu['mview_id'][$key];
					$html .= "<tr class=\"cenote_mvmenu\"><td class=\"cenote_mvmenu\"><a href=\"index.php?mod=multiview&mvid=$id\">$title</a></td></tr>";
				}
			}
		}else{
			$html .= "<td class=\"cenote_mvmenu\">Module未登録</td>";
		}
		$html .= "</tr></table>";
		return $html;
	}
}
