<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/**
 * calender class
 *
 * 簡単なカレンダーを表示するウィジット
 *
 */

define('YEAR', 0);
define('MONTH', 1);
define('DAY', 2);


class cenote_calender {
	public function __construct(){

	}
	public function display(){
		$date = date('Y n d');
		$date = explode(' ', $date);

		$date[MONTH] = (int) $date[MONTH];
		$date[YEAR] = (int) $date[YEAR];
		$date[DAY] = (int) $date[DAY];

		$days = date('d', mktime(0, 0, 0, $date[MONTH]+1, 0, $date[YEAR]));
		$first_day = date('w', mktime(0, 0, 0, $date[MONTH], 1, $date[YEAR]));
		$last_day = date('w', mktime(0, 0, 0, $date[MONTH], $days, $date[YEAR]));

		$last_week_days = ($days + $first_day) % 7;

		if ($last_week_days == 0){
			$weeks = ($days + $first_day) / 7;
		}else{
			$weeks = ceil(($days + $first_day) / 7);
		}

		$weeks = (int) $weeks;
		$last_day = (int) $last_day;
		$first_day = (int) $first_day;

		$html = '<table class="cenote_widget">';
		$html .= '<tr class="cenote_widget"><th class="cenote_widget" colspan="7">カレンダー</th></tr>';
		$html .= '<tr class="cenote_widget"><td class="cenote_widget" colspan="7" style="text-align: center;">-'.$date[YEAR].'年'.$date[MONTH].'月-</td></tr>';
		$html .= '<tr class="cenote_widget">';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">日</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">月</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">火</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">水</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">木</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">金</td>';
		$html .= '<td class="cenote_widget" width="15%" style="text-align: center;">土</td></tr>';

		$i=$j=$day=0;

		while($i<$weeks){
			$j=0;
			$html .= '<tr class="cenote_widget">';
			while($j<7){
				$html .= '<td class="cenote_widget" style="text-align: center;">';

				if(($i==0 && $j<$first_day) || ($i==$weeks-1 && $j>$last_day)){
					$html .=  '　</td>';
				}else{
					$html .=  ++$day."</td>";
				}
				$j++;
			}
			$html .=  '</tr>'."\n";
			$i++;
		}
		$html .=  '</table>';
		return $html;
	}
}