<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/validate.php');
include_once('./cenote/core/db_class.php');
/* -------------------------------------------------------------------
 モジュールインスタンス
 -------------------------------------------------------------------- */
class multiview extends cenote_smarty {

	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	public $err_msg;
	/* 内部変数 */
	private $acl;

	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request 				= $req;
		$this->smarty->config_dir 	= "./modules/".$this->request['module'];
		$this->page					= $this->request['page'];
		$this->acl					= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/*------------------------------------------------------------
	 INIT 初期画面用項目セット初期化が必要な場合ここに記述
	 ------------------------------------------------------------ */
	public function init(){
	}
	/* ------------------------------------------------------------
		モジュールの利用権限確認
		------------------------------------------------------------ */
	public function acl(){
		return true;
	}

	/* ------------------------------------------------------------
		処理ごとの詳細な動作はこちらに記述
		--------------------------------------------------------- */
	public function action(){

		$ix = 0;
		$db = new db_class();

		$id = isset($this->request['mvid'])?$this->request['mvid']:"list";

		if($id != "list"){
			$sql = "SELECT * FROM cenote_mview WHERE mview_id = $id";

			$mview = $db->getData2($sql);

			$this->assign("mview_title",$mview['mview_title'][0]);
			$this->assign("mview_comment",$mview['mview_comment'][0]);
			$this->assign("mview_date",$mview['mview_create_date'][0]);

			$this->assign("view",0);
		}else{
			$sql = "SELECT * FROM cenote_mview ORDER BY mview_create_date";
			$mview = $db->getData2($sql);
			if(is_array($mview)){
				$this->assign("mview_title",$mview['mview_title']);
				$this->assign("mview_id",$mview['mview_id']);
				$this->assign("view",1);
			}
		}
	}
	/* ------------------------------------------------------------
		エラーメッセージ配列に追加する
		--------------------------------------------------------- */
	public function err_msg_add($str){
		$cnt = count($this->err_msg);
		$this->err_msg[$cnt] = $str;
	}
}
