<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/**
 * モジュールのコントロールファイルを取得するクラス
 */

include_once("./cenote/core/db_class.php");

class get_widget_xml_config{
	
	public $errMsg;

	public function get_widget(){

		$update_msg = "";
		$widget = array();
		$dir = './widget/';
		$ix = 0;
		$errMsg = "";
		
		// ウィジット定義更新
		if( $handle = @opendir($dir) ){
			while( ($file = readdir( $handle)) !== false ){
				if(is_dir( $file )) continue;
				if(!file_exists("$dir$file/controll.xml")) continue;
				$parser=xml_parser_create();
				$data=file_get_contents("$dir$file/controll.xml");
				xml_parse_into_struct($parser,$data,$vals,$index);
				xml_parser_free($parser);

				
				// ウィジットコントロールファイルの検査
				$errcnt = 0;
				// <position>
				if(isset($index['POSITION'][0])){
					if(!isset($vals[$index['POSITION'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(position)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(position)エラー";
					$errcnt++;
				}
				// <position>
				if(isset($index['WIDGET_ORDER'][0])){
					if(!isset($vals[$index['WIDGET_ORDER'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(widget_order)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(widget_order)エラー";
					$errcnt++;
				}
				// <name>
				if(isset($index['NAME'][0])){
					if(!isset($vals[$index['NAME'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(name)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(name)エラー";
					$errcnt++;
				}
				// <version>
				if(isset($index['VERSION'][0])){
					if(!isset($vals[$index['VERSION'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(version)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(version)エラー";
					$errcnt++;
				}
				// <auther>
				if(isset($index['AUTHER'][0])){
					if(!isset($vals[$index['AUTHER'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(auther)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(auther)エラー";
					$errcnt++;
				}
				// <url>
				if(isset($index['URL'][0])){
					if(!isset($vals[$index['URL'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(url)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(url)エラー";
					$errcnt++;
				}
				// <comment>
				if(isset($index['COMMENT'][0])){
					if(!isset($vals[$index['COMMENT'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(comment)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."ウィジットのcontroll.xml(comment)エラー";
					$errcnt++;
				}
				
				if($errcnt == 0){
					$widget['position'][$ix]		= $vals[$index['POSITION'][0]]['value'];
					$widget['widget_order'][$ix]	= $vals[$index['WIDGET_ORDER'][0]]['value'];
					$widget['name'][$ix]			= $vals[$index['NAME'][0]]['value'];
					$widget['version'][$ix]			= $vals[$index['VERSION'][0]]['value'];
					$widget['auther'][$ix]			= $vals[$index['AUTHER'][0]]['value'];
					$widget['url'][$ix]				= $vals[$index['URL'][0]]['value'];
					$widget['comment'][$ix]			= $vals[$index['COMMENT'][0]]['value'];
					$ix++;
				}
			}
			closedir( $handle );
		}
		return $widget;
	}
}