<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/**
 * モジュールのコントロールファイルを取得するクラス
 */
class get_module_xml_config{

	public $errMsg;

	public function get_module(){

		$module = array();
		$dir = './modules/';
		$ix = 0;
		$errcnt = 0;


		if( $handle = @opendir($dir) ){
			while( ($file = readdir( $handle)) !== false ){
				if(is_dir( $file )) continue;

				if(!file_exists("$dir$file/controll.xml")) continue;

				$parser=xml_parser_create();
				$data=file_get_contents("$dir$file/controll.xml");
				xml_parse_into_struct($parser,$data,$vals,$index);
				xml_parser_free($parser);

				// モジュールコントロールファイルの検査
				$errcnt = 0;
				// <name>
				if(isset($index['NAME'][0])){
					if(!isset($vals[$index['NAME'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(name)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(name)エラー";
					$errcnt++;
				}
				// <api_name>
				if(isset($index['API_NAME'][0])){
					if(!isset($vals[$index['API_NAME'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(api_name)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(api_name)エラー";
					$errcnt++;
				}
				// <menu>
				if(isset($index['MENU'][0])){
					if(!isset($vals[$index['MENU'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(menu)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(menu)エラー";
					$errcnt++;
				}
				// <auther>
				if(isset($index['AUTHER'][0])){
					if(!isset($vals[$index['AUTHER'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(auther)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(auther)エラー";
					$errcnt++;
				}
				// <version>
				if(isset($index['VERSION'][0])){
					if(!isset($vals[$index['VERSION'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(version)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(version)エラー";
					$errcnt++;
				}
				// <url>
				if(isset($index['URL'][0])){
					if(!isset($vals[$index['URL'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(url)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(url)エラー";
					$errcnt++;
				}
				// <edit>
				if(isset($index['EDIT'][0])){
					if(!isset($vals[$index['EDIT'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(edit)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(edit)エラー";
					$errcnt++;
				}
				// <maintenance>
				if(isset($index['MAINTENANCE'][0])){
					if(!isset($vals[$index['MAINTENANCE'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(maintenance)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(maintenance)エラー";
					$errcnt++;
				}
				// <comment>
				if(isset($index['COMMENT'][0])){
					if(!isset($vals[$index['COMMENT'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(comment)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(comment)エラー";
					$errcnt++;
				}
				// <module_order>
				if(isset($index['MODULE_ORDER'][0])){
					if(!isset($vals[$index['MODULE_ORDER'][0]]['value'])){
						$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(module_order)NULLエラー";
						$errcnt++;
					}
				}else{
					$this->errMsg[$errcnt] = $file."モジュールのcontroll.xml(module_order)エラー";
					$errcnt++;
				}

				if($errcnt == 0){
					$module['name'][$ix]			= $vals[$index['NAME'][0]]['value'];
					$module['api_name'][$ix]		= $vals[$index['API_NAME'][0]]['value'];
					$module['menu'][$ix]			= $vals[$index['MENU'][0]]['value'];
					$module['auther'][$ix]			= $vals[$index['AUTHER'][0]]['value'];
					$module['version'][$ix]			= $vals[$index['VERSION'][0]]['value'];
					$module['url'][$ix]				= $vals[$index['URL'][0]]['value'];
					$module['edit'][$ix]			= $vals[$index['EDIT'][0]]['value'];
					$module['maintenance'][$ix]		= $vals[$index['MAINTENANCE'][0]]['value'];
					$module['comment'][$ix]			= $vals[$index['COMMENT'][0]]['value'];
					$module['module_order'][$ix]	= $vals[$index['MODULE_ORDER'][0]]['value'];

					foreach($index['PAGE_TPL'] as $key => $val){
						$module['page_tpl'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['PAGE_NAME'] as $key => $val){
						$module['page_name'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['PAGE_ORDER'] as $key => $val){
						$module['page_order'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['TABLE'] as $key => $val){
						$module['table'][$ix][$key]  		 = $vals[$val]['value'];
					}
					$ix++;
				}
			}
			closedir( $handle );
		}
		return $module;
	}
}