<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
/**
 * core Class
 *
 * CMSの動作を制御するメインクラス
 * この中で画面からの情報受け取りから
 * 表示画面の選定、画面送信までを受け持つ
 **/

include_once("./cenote/core/injection_class.php");
include_once("./cenote/core/edit_button_class.php");
include_once("./cenote/core/encode_change_class.php");
include_once("./cenote/core/get_module_config.php");
include_once("./cenote/core/get_widget_config.php");


class core {

	// モジュール名保存変数
	private $mod;
	// 表示画面ナンバー保存変数
	private $page;
	// リクエスト保存用配列変数
	private $req;

	//エラーメッセージ用
	private $dialog_messages;

	// 一時保存用
	private $module;
	private $mod_id;
	private $mod_class;

	/* -----  コンストラクタ  ----- */
	public function __construct(){
		$this->dialog_messages = array();
	}

	/**
	 * セッション管理メゾットです。
	 *
	 * セッション名の設定とブラウザキャッシュの無効を行う。
	 */
	public function session_start(){
		session_name(_SESSION_NAME);
		session_cache_limiter('private, must-revalidate');	 // ブラウザーキャッシュ無効
		session_start();
		//echo session_id()."---".session_name();
	}

	/**
	 * モージュールコンフィグ読み込みメゾットです。
	 *
	 * moduleディレクトリ配下のモジュールコントロールファイルを読み込み
	 * セッション情報に保存する。
	 */
	public function module_config_load(){

		if(isset($_SESSION['module'])){
			$this->module = $_SESSION['module'];
		} else {
			$get_module = new get_module_config();
			$this->module = $_SESSION['module'] = $get_module->get_module();
		}
	}

	/**
	 * ユーザー情報初期化メゾットです。
	 *
	 * ユーザー情報がセッションに保持されていればスルーします。
	 * セッションに保存されていなければ仮のユーザー「ゲスト」として
	 * セッションに登録します。
	 */
	public function get_user_info(){

		if(!isset($_SESSION['acl']['account'])){
			$_SESSION['acl']['account']	= "guest";
			$_SESSION['acl']['email']	= "";
			$_SESSION['acl']['group']	= "GUEST";
			$_SESSION['acl']['name']	= "ゲスト";
			$_SESSION['acl']['valid']	= true;	 // 有効
		}

	}

	/**
	 * リクエスト取得メゾットです。
	 *
	 * 画面遷移や次ページ処理などを受け取り指示にしたがってコントロールします。
	 */
	public function get_page_request(){

		// API NAME
		$this->mod   = isset($_REQUEST['mod'])  ? (string)$_REQUEST['mod']  : (string)"index" ;
		// API 制御No
		$this->page  = isset($_REQUEST['page']) ? (string)$_REQUEST['page'] : (string)"0" ;

		//存在しないモジュールとページが指定された場合
		//requestを初期化する
		$result = false;
		for($ix=0; $ix < count($this->module['name']); $ix++){
			if($this->module['name'][$ix] == $this->mod){
				if(isset($this->module['page_order'][$ix][$this->page])){
					$result = true;
				}
			}
		}
		if(!$result){
			$this->mod = (string)"index";
			$this->page  = (string)"0";
		}
	}
	/**
	 * ーザー情報リクエスト取得メゾットです。
	 *
	 * ログイン情報も受け取りそのユーザーをセッションに保存します。
	 */
	public function get_user_request(){

		$db = new db_class();

		// Login処理からユーザーアカウント所得
		$account = isset($_REQUEST['cenote_account'])  ? $_REQUEST['cenote_account']  : "" ;
		// Login処理からユーザーパスワード所得
		$passwd = isset($_REQUEST['cenote_passwd'])  ? $_REQUEST['cenote_passwd']  : "" ;

		if($account && $passwd){
			$user_info = new login_class();
			if($user_info->login_check($account, $passwd)){
				$_SESSION['acl']['account']	= $user_info->get_user_account();
				$_SESSION['acl']['email']	= $user_info->get_user_email_address();
				$_SESSION['acl']['group']	= $user_info->get_user_group();
				$_SESSION['acl']['name']	= $user_info->get_user_name();
				$_SESSION['acl']['valid']	= $user_info->get_user_valid();
				// 権限情報の取得
				$group = $_SESSION['acl']['group'];
				$sql = "SELECT * FROM cenote_group WHERE cenote_group_name = '$group'";
				$result = $db->getData2($sql);
				foreach($result['cenote_group_module'] as $key => $value){
					$_SESSION['group'][$value] = $result['cenote_group_available'][$key];
				}
			}else{
				$msg[0] = "ユーザーが見つからないか、パスワードが間違っています。";
				$this->EditErrorMsg($msg);
			}
		}
		if(isset($_POST['Submit'])){
			if($_POST['Submit'] == "LOGOUT"){

				$logout = new logout_class();
				$logout->logout();

				$this->page = "0";
			}
		}
	}

	/**
	 * リクエスト内容の編集
	 *
	 * リクエストの内容をモジュールに渡します
	 * 不要なリクエストやユーザーに渡す必要のないものは除去します
	 * モジュールは基本的に$this->reqで渡した内容を参照します
	 */
	public function make_request_arr(){

		$chg = new encode_change_class();

		$this->req = "";
		$this->req['module'] = $this->mod;
		$this->req['page']   = $this->page;
		$this->req['user']   = $_SESSION['acl'];

		$inj = new injection_class();

		foreach($_REQUEST as $key => $value){
			switch($key){
				// 　REQUESTの中から不要なものやユーザーに見せたくないものを取り除く
				case "debug_port":
				case "start_debug":
				case "debug_start_session":
				case "debug_no_cache":
				case "debug_host":
				case "debug_session_id":
				case "send_sess_end":
				case "passwd":
					break;
				default:
					$this->req[$key] = $chg->encode_change($value);
			}
		}
	}

	/**
	 * アクセスコントロールメゾットです。
	 *
	 * セッションに保存されたユーザーが、画面から指示されたモジュールを実行する権限が
	 * あるかを確認し、なければINDEXモジュールに差し替えます。
	 * ただし、ADMINモジュールのページ先頭ページのみ表示する。
	 */
	public function access_controll(){
		if( $this->mod =="AdminTool" && $this->page =="0"){
		} else {
			if(!$this->acl_check($this->mod, $this->page)){
				$this->mod  = "index";
				$this->page = "0";
			}
		}
	}

	/**
	 * メインモジュールコントロールメゾットです。
	 *
	 * 画面の中心となるモジュールの制御を行うメゾットです
	 * 指定されたモジュールがあるかを確認し、そのモジュールのインスタンスを作成します。
	 * もし、モジュールがなければindexモジュールをインスタンスしINDEXモジュールを表示します。
	 * モジュールがあった場合はモジュール内のメゾットを順次実行していきます。
	 */
	public function main_module(){
		try {
			if (in_array($this->mod,$this->module['name'])){
				// 画面のIDと一致するmoduleを探しモジュールクラスを呼び出す
				//コントロール配列から番号を探す
				$this->mod_id	= array_search($this->mod,$this->module['name']);
				//見つかったモジュールクラスをインスタンス化
				if(class_exists($this->module['name'][$this->mod_id])){
					$this->mod_class = new $this->module['name'][$this->mod_id]($this->req);
				}else{
					$e_msg = 'モジュール['.$this->module['name'][$this->mod_id].']中に('.$this->module['name'][$this->mod_id].')クラスが見つかりません。';
					throw new Exception($e_msg);
				}

			} else {
				//画面のIDと一致するmoduleが見つからかなったらINDEXページを表示
				$this->mod = "index";
				$this->mod_id	= array_search($this->mod,$this->module['name']);
				//コントロールからクラスをインスタンス化
				$this->mod_class = new $this->module['name'][$this->mod_id]($this->req);

			}

			// モジュールクラス内のファンクションを実行
			if(method_exists($this->mod_class,'init')){
				$this->mod_class->init();
				if(method_exists($this->mod_class,'acl')){
					if($this->mod_class->acl()){
						if(method_exists($this->mod_class,'action')){
							$this->mod_class->action();
							if($this->mod_class->dialog_msg){
								$this->EditErrorMsg($this->mod_class->dialog_msg);
							}
						} else {
							$e_msg = 'モジュール['.$this->module['name'][$this->mod_id].']中に(action)メゾッドが見つかりません。';
							throw new Exception($e_msg);
						}
					} else {
						echo "モジュールは利用できません";
						exit;
					}
				} else {
					$e_msg = 'モジュール['.$this->module['name'][$this->mod_id].']中に(acl)クラスが見つかりません。';
					throw new Exception($e_msg);
				}
			} else {
				$e_msg = 'モジュール['.$this->module['name'][$this->mod_id].']中に(init)クラスが見つかりません。';
				throw new Exception($e_msg);
			}

		}
		catch (Exception $e) {
			// Error表示
			$msg[0] = "エラー:".$e->getMessage();
			$this->EditErrorMsg($msg);
			// TOPページを強制表示
			$this->mod = "index";
			$this->mod_id	= array_search($this->mod,$this->module['name']);
			//コントロールからクラスをインスタンス化
			$this->mod_class = new $this->module['name'][$this->mod_id]($this->req);
			$this->mod_class->init();
			if($this->mod_class->acl()){
				$this->mod_class->action();
				if($this->mod_class->dialog_msg){
					$this->EditErrorMsg($this->mod_class->dialog_msg);
				}
			}
		}
	}

	/**
	 * ウィジットロード
	 *
	 * ウィジット情報を取得しセッションに保存するメゾットです。
	 */

	public function get_use_widget(){
		$wid = new get_widget_config();
		$_SESSION['widget'] = $wid->get_widget();
	}
	/**
	 * HTML編集ボタン表示コントロールメゾットです。
	 */
	public function edit_button(){
		$_SESSION['edit_button'] = "";
		if($this->module['editor'][$this->mod_id] != "none"){
			$button = new edit_button_class();
			$edit = $button->edit_button($_SESSION['acl']['group'],$this->mod,$this->page);
			if($edit){
				$edit = $this->module['editor'][$this->mod_id];
			}
			$this->mod_class->assign("edit_button", $edit);
			$_SESSION['edit_button'] = $edit;
		}
	}
	/**
	 * メンテナンスボタン表示コントロールメゾットです。
	 */
	public function mnt_edit_button(){
		$_SESSION['mnt_button'] = "";
		if($this->module['maintenance'][$this->mod_id] != "none"){
			$button = new edit_button_class();

			$mnt = urlencode("./modules/".$this->mod."/".$this->module['maintenance'][$this->mod_id]);
			$emod = $this->module['maintenance'][$this->mod_id];
			$edit = $button->mnt_edit_button($_SESSION['acl']['group'],$this->mod,$this->page, $mnt, $emod);
			$this->mod_class->assign("mnt_button", $edit);
			$_SESSION['mnt_button'] = $edit;
		}
	}
	/**
	 * ヘッダーウィジットコントロールメゾットです。
	 */
	public function header_widget(){

		$widget = new widget("head",$this->mod);
		$this->mod_class->assign("h_widget", $widget->html);
	}

	/**
	 * ナビゲーションウィジットコントロールメゾットです。
	 */
	public function navi_widget(){

		$widget = new widget("navi",$this->mod);
		$this->mod_class->assign("n_widget", $widget->html);
	}

	/**
	 * 左ウィジットコントロールメゾットです。
	 */
	public function left_widget(){

		$widget = new widget("left",$this->mod);
		$this->mod_class->assign("l_widget", $widget->html);
	}

	/**
	 * センターウィジットコントロールメゾットです。
	 */
	public function center_widget(){

		$widget = new widget("center",$this->mod);
		$this->mod_class->assign("c_widget", $widget->html);
	}

	/**
	 * 右ウィジットコントロールメゾットです。
	 */
	public function right_widget(){
		// 右ウィジット
		$widget = new widget("right",$this->mod);
		$this->mod_class->assign("r_widget", $widget->html);
	}

	/**
	 * フッターウィジットコントロールメゾットです。
	 */
	public function footer_widget(){
		// 右ウィジット
		$widget = new widget("foot",$this->mod);
		$this->mod_class->assign("f_widget", $widget->html);
	}

	/**
	 * クライアントに画面を送信するメゾットです。
	 *
	 * 各モジュールのスタイルシートを参照し送信する画面に差し込みます。
	 * また、各モジュールのテンプレートも送信します
	 */
	public function display(){

		$this->page = $this->mod_class->page;

		switch(_CHAR_TYPE){
			case "SHIFT-JIS":
				$css_theme = "styleSJIS.css";
				$css_module = "moduleSJIS.css";
				break;
			case "EUC-JP":
				$css_theme = "styleEUCJP.css";
				$css_module = "moduleEUCJP.css";
				break;
			case "UTF-8":
				$css_theme = "styleUTF8.css";
				$css_module = "moduleUTF8.css";
				break;
		}

		// モジュール用スタイルシート（module.css）参照
		$module_css = "";
		if(file_exists("./modules/".$this->module['name'][$this->mod_id]."/".$css_module)){
			$module_css = "<link rel=\"stylesheet\" href=\"./modules/" .$this->module['name'][$this->mod_id]."/".$css_module."\"  type=\"text/css\">";
		}
		$this->mod_class->assign("module_css", $module_css);
		
		// AdminTool利用の権限確認
		if(!isset($this->module['page_tpl'][$this->mod_id][$this->page])){
			$this->page = "0";
			$msg[0] = "権限がありません。AdminToolの利用権を参照に変更する必要があります";
			$this->EditErrorMsg($msg);
		}
		$contents = "./modules/".$this->module['name'][$this->mod_id]."/".$this->module['page_tpl'][$this->mod_id][$this->page];
		
		// EDITORで利用するための設定をセッションに保存
		$_SESSION['screen'] 		= "./modules/".$this->module['name'][$this->mod_id]."/".$this->module['page_tpl'][$this->mod_id][$this->page];
		$_SESSION['screen_css'] 	= "./modules/".$this->module['name'][$this->mod_id]."/".$css_module;
		$_SESSION['screen_theme_css'] 	= "./themes/"._SITE_THEME."/".$css_theme;
		$_SESSION['screen_module']	= $this->mod;
		$_SESSION['screen_page']	= $this->page;

		$this->mod_class->assign("module", $contents);
		
		
		// Viewで利用する情報を送信　---------------------------------
		
		// サイト名称
		$this->mod_class->assign("site_name",_SITE_NAME);
		// サイトURL
		$this->mod_class->assign("site_url",_SITE_URL);
		// サイトテーマ
		$this->mod_class->assign("site_theme",_SITE_THEME);
		// 利用データベース
		$this->mod_class->assign("db_type",_DB_TYPE);
		// デバッグ情報
		$this->mod_class->assign("debug",_DBG);
		// サイト文字コード
		$this->mod_class->assign("site_encode",_CHAR_TYPE);
		// cenote Version
		$this->mod_class->assign("cenote_version",_CENOTE_VERSION);
		// 現在表示しているモジュール名
		$this->mod_class->assign("module_name", $this->module['menu'][$this->mod_id]);
		//現在表示しているモジュールのページ名
		$this->mod_class->assign("page_name", $this->module['page_name'][$this->mod_id][$this->page]);
		// モジュールパス指定
		$this->mod_class->assign("mod_path","./modules/".$this->module['name'][$this->mod_id]."/");

		
		
		//ダイアログメッセージの表示
		$this->mod_class->assign("err",$this->dialog_msg_edit());

		//HTMLのキャラクターセット
		$this->mod_class->assign("char_type",_CHAR_TYPE);

		// 初期画面のスタイルシート
		$this->mod_class->assign("cenote_css","./themes/"._SITE_THEME."/".$css_theme);
		$this->mod_class->display("./themes/"._SITE_THEME."/theme.tpl");


		// 画面送信

	}

	/**
	 * アドミンモジュールコントロールメゾットです。
	 *
	 * 画面の中心となるモジュールの制御を行うメゾットです
	 * 指定されたモジュールがあるかを確認し、そのモジュールのインスタンスを作成します。
	 * もし、モジュールがなければindexモジュールをインスタンスしINDEXモジュールを表示します。
	 * モジュールがあった場合はモジュール内のメゾットを順次実行していきます。
	 *
	 */

	public function admin_display(){

		$this->page = $this->mod_class->page;

		switch(_CHAR_TYPE){
			case "SHIFT-JIS":
				$css_module = "moduleSJIS.css";
				break;
			case "EUC-JP":
				$css_module = "moduleEUCJP.css";
				break;
			case "UTF-8":
				$css_module = "moduleUTF8.css";
				break;
		}
		// モジュール用スタイルシート自動参照 AdminToolhathemeも兼ねるのでNULL
		$this->mod_class->assign("module_css", "");

		// モジュールのテンプレートファイル自動参照
		$contents = $this->module['page_tpl'][$this->mod_id][$this->page];

		// ページタイトル表示
		$this->mod_class->assign("page_name", $this->module['page_name'][$this->mod_id][$this->page]);

		// 初期画面のスタイルシート
		$this->mod_class->assign("cenote_css","./modules/AdminTool/".$css_module);

		// モジュールパス指定
		$this->mod_class->assign("mod_path","./modules/".$this->module['name'][$this->mod_id]."/");

		// モジュールのテンプレートファイル自動参照
		$contents = "./modules/".$this->module['name'][$this->mod_id]."/".$this->module['page_tpl'][$this->mod_id][$this->page];

		// サイト名称
		$this->mod_class->assign("site_name",_SITE_NAME);
		// サイトURL
		$this->mod_class->assign("site_url",_SITE_URL);
		// サイトテーマ
		$this->mod_class->assign("site_theme",_SITE_THEME);
		// 利用データベース
		$this->mod_class->assign("db_type",_DB_TYPE);
		// デバッグ情報
		$this->mod_class->assign("debug",_DBG);
		// サイト文字コード
		$this->mod_class->assign("site_encode",_CHAR_TYPE);
		// cenote Version
		$this->mod_class->assign("cenote_version",_CENOTE_VERSION);
		
		
		//ダイアログメッセージの表示
		$this->mod_class->assign("err",$this->dialog_msg_edit());

		//HTMLのキャラクターセット
		$this->mod_class->assign("char_type",_CHAR_TYPE);

		// 画面送信
		$this->mod_class->display($contents);

	}

	public function getModuleName(){
		return $this->mod;
	}

	public function getModuleInfo(){
		return $this->module;
	}

	// -----------内部クラス----------------------------------------
	/**
	 * モジュールのアクセスコントロールを行うメゾットです。
	 *
	 * モジュールディレクトリ内に配置されたcontorollファイルを読み込み
	 * モジュールコントロールを保存し戻す
	 */
	private function acl_check($module, $page){

		$auth = $_SESSION['acl']['group'];
		$db = new db_class();
		$sql = "SELECT * FROM cenote_group WHERE cenote_group_name = '$auth' and cenote_group_module = '$module'";
		$result = $db->getData($sql);

		if(is_array($result)){
			if($result[0]['cenote_group_available'] > 0){
				return $result[0]['cenote_group_available'];
			} else {
				return false;
			}
		}else{
			return false;
		}
	}

	/**
	 * ダイアログメッセージの編集を行ううメゾットです。
	 *
	 * モジュールディレクトリ内に配置されたcontorollファイルを読み込み
	 * モジュールコントロールを保存し戻す
	 *
	 */
	private function dialog_msg_edit(){
		$edt_msg = "";
		if($this->dialog_messages){
			$edt_msg =  " onLoad=alert('";
			foreach($this->dialog_messages as $key => $value){
				$edt_msg .=  $value;
			}
			$edt_msg .=  "')";
		}
		return $edt_msg;

	}

	/**
	 * エラーメッセージの編集を行うメゾットです。
	 *
	 */
	private function EditErrorMsg($arr){
		foreach($arr as $key => $value){
			$this->dialog_messages[$key] = $value."\\n";
		}
	}
}