<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/core/db_class.php');
include_once('./cenote/core/date_class.php');
include_once('./cenote/core/injection_class.php');

class video_add{
	
	public $request;
	
	public function __construct($req){
		$this->request = $req;
	}
	
	public function maintenance(){
		
		// DBクラスインスタンス
		$db = new db_class();
		
		// 項目初期化
		$id = 0;
		$title = $tag = $comment = $date = "";
		
		
		if(isset($this->request['Submit'])){
			switch($this->request['Submit']){
				case "登録":
					$this->add();
					break;
				case "修整":
					$this->up();
					break;
				case "削除":
					$this->del();
					header("location:index.php?mod=AdminTool&page=7&emod=video_add&edit=.%2Fmodules%2Fvideo%2Fvideo_add");
					break;
			}
		}
		
		
		if(isset($this->request['edt'])){
			$id = $this->request['edt'];
			$sql = "SELECT * FROM cenote_video WHERE video_id = $id";
			$video = $db->getData2($sql);

			for($ix=0; $ix < count($video['video_title']); $ix++){
				$id = $video['video_id'][$ix];
				$title = $video['video_title'][$ix];
				$tag = $video['video_tag'][$ix];
				$comment = $video['video_comment'][$ix];
				$date = $video['video_date'][$ix];
			}
			
		}
		
		
		
		//  ビデオファイルが登録されているか確認
		$sql = "SELECT * FROM cenote_video ORDER BY video_date";
		$video_cnt = $db->getDataCnt($sql);
		
		
		//  画面表示
		$edit = '
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" colspan="2">ビデオの登録＆修整</th>
			  </tr>
			  <tr>
			    <td width="20%">タイトル</td>
			    <td width="80%"><input type="text" name="video_title" size="80" maxlength="150" value="'.$title.'"/>
					<input type="hidden" name="video_id" value="'.$id.'"/>
					<input type="hidden" name="video_date" value="'.$date.'"/>
				</td>
			  </tr>
			  <tr>
			    <td>ビデオタグ</td>
			    <td><textarea name="video_tag" cols="80" rows="8">'.$tag.'</textarea></td>
			  </tr>
			  <tr>
			    <td>コメント</td>
			    <td><textarea name="video_comment" cols="80" rows="5">'.$comment.'</textarea></td>
			  </tr>
			  <tr>
   				 <td colspan="2">';
		if(isset($this->request['edt'])){
			$edit .= '
					<input type="submit" name="Submit" value="修整" />　
					<input type="submit" name="Submit" value="削除" />
					<a href="index.php?mod=AdminTool&page=7&emod=video_add&edit=.%2Fmodules%2Fvideo%2Fvideo_add">戻る</a>';
		} else {
			$edit .= '<input type="submit" name="Submit" value="登録" />';
		}
		$edit .= '			
				</td>
			  </tr>
			</table>
			<br />
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" scope="col">登録日</th>
			    <th width="80%" scope="col">ビデオタイトル</th>
			  </tr>';
			//  登録さているビデオリスト作成
		if($video_cnt > 0){
			$video_list = $db->getData2($sql);
			for($ix=0; $ix < count($video_list['video_title']); $ix++){
				$edit .= '
				  <tr>
				    <td><a href="index.php?mod=AdminTool&page=7&emod=video_add&edit=.%2Fmodules%2Fvideo%2Fvideo_add&edt='.$video_list['video_id'][$ix].'">'.$video_list['video_date'][$ix].'</a></td>
				    <td>'.$video_list['video_title'][$ix].'</td>
				  </tr>';
			}
		}

		$edit .= '	</table>';

		return $edit;
	}
	
	// 追加ファンクション
	private function add(){
		if(trim($this->request['video_title']) == "" || trim($this->request['video_tag']) == ""){
			return false;
		}
		$date = new date_class();
		$inj = new injection_class();
		$db = new db_class();
		
		
		$sql = sprintf("INSERT INTO cenote_video (video_title,video_comment,video_date,video_tag) VALUES ('%s','%s','%s','%s')",
		$inj->injection($this->request['video_title']),
		$inj->injection($this->request['video_comment']),
		$date->get_date('datetime'),
		$inj->injection($this->request['video_tag'])
		);
		
		$db->putData($sql);
	}
	// 更新ファンクション
	private function up(){
		if(trim($this->request['video_title']) == "" || trim($this->request['video_tag']) == ""){
			return false;
		}
		$inj = new injection_class();
		$db = new db_class();
		
		
		$sql = sprintf("UPDATE cenote_video SET video_title = '%s',
												video_comment = '%s',
												video_date = '%s',
												video_tag = '%s'
						WHERE video_id = %d",
		$inj->injection($this->request['video_title']),
		$inj->injection($this->request['video_comment']),
		$inj->injection($this->request['video_date']),
		$inj->injection($this->request['video_tag']),
		$inj->injection($this->request['video_id'])
		);
		
		$db->putData($sql);
	}
	// 削除ファンクション
	private function del(){
		$inj = new injection_class();
		$db = new db_class();
		
		$sql = sprintf("DELETE FROM cenote_video WHERE video_id = %d",
		$inj->injection($this->request['video_id']));
		
		$db->putData($sql);
	}
}