<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/core/db_class.php');
include_once('./cenote/core/date_class.php');
include_once('./cenote/core/injection_class.php');

class news_add{

	public $request;

	public function __construct($req){
		$this->request = $req;
	}

	public function maintenance(){

		// DBクラスインスタンス
		$db = new db_class();

		// 項目初期化
		$id = 0;
		$title = $comment = $date = "";


		if(isset($this->request['Submit'])){
			switch($this->request['Submit']){
				case "登録":
					$this->add();
					break;
				case "修整":
					$this->up();
					break;
				case "削除":
					$this->del();
					header("location:index.php?mod=AdminTool&page=7&emod=news_add&edit=.%2Fmodules%2Fnews%2Fnews_add");
					break;
			}
		}


		if(isset($this->request['edt'])){
			$id = $this->request['edt'];
			$sql = "SELECT * FROM cenote_news WHERE news_id = $id";
			$news = $db->getData2($sql);

			for($ix=0; $ix < count($news['news_title']); $ix++){
				$id = $news['news_id'][$ix];
				$title = $news['news_title'][$ix];
				$comment = str_replace("<br />","\n",$news['news_comment'][$ix]);
				$date = $news['news_date'][$ix];
			}
				
		}



		//  ビデオファイルが登録されているか確認
		$sql = "SELECT * FROM cenote_news ORDER BY news_date DESC";
		$news_cnt = $db->getDataCnt($sql);


		//  画面表示
		$edit = '
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" colspan="2">ニュースの登録＆修整</th>
			  </tr>
			  <tr>
			    <td width="20%">タイトル</td>
			    <td width="80%"><input type="text" name="news_title" size="80" maxlength="150" value="'.$title.'"/>
					<input type="hidden" name="news_id" value="'.$id.'"/>
					<input type="hidden" name="news_date" value="'.$date.'"/>
				</td>
			  </tr>
			  <tr>
			    <td>コメント</td>
			    <td><textarea name="news_comment" cols="80" rows="10">'.$comment.'</textarea></td>
			  </tr>
			  <tr>
   				 <td colspan="2">';
		if(isset($this->request['edt'])){
			$edit .= '
					<input type="submit" name="Submit" value="修整" />　
					<input type="submit" name="Submit" value="削除" />
					<a href="index.php?mod=AdminTool&page=7&emod=news_add&edit=.%2Fmodules%2Fnews%2Fnews_add">戻る</a>';
		} else {
			$edit .= '<input type="submit" name="Submit" value="登録" />';
		}
		$edit .= '
				</td>
			  </tr>
			</table>
			<br />
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" scope="col">登録日</th>
			    <th width="80%" scope="col">ニュースタイトル</th>
			  </tr>';
		//  登録さているビデオリスト作成
		if($news_cnt > 0){
			$news_list = $db->getData2($sql);
			for($ix=0; $ix < count($news_list['news_title']); $ix++){
				$edit .= '
				  <tr>
				    <td><a href="index.php?mod=AdminTool&page=7&emod=news_add&edit=.%2Fmodules%2Fnews%2Fnews_add&edt='.$news_list['news_id'][$ix].'">'.$news_list['news_date'][$ix].'</a></td>
				    <td>'.$news_list['news_title'][$ix].'</td>
				  </tr>';
			}
		}

		$edit .= '	</table>';

		return $edit;
	}

	// 追加ファンクション
	private function add(){
		if(trim($this->request['news_title']) == ""){
			return false;
		}
		$date = new date_class();
		$inj = new injection_class();
		$db = new db_class();


		$sql = sprintf("INSERT INTO cenote_news (news_title,news_comment,news_date) VALUES ('%s','%s','%s')",
		$inj->injection($this->request['news_title']),
		$inj->injection(str_replace("\n","<br />",$this->request['news_comment'])),
		$date->get_date('datetime')
		);

		$db->putData($sql);
	}
	// 更新ファンクション
	private function up(){
		$inj = new injection_class();
		$db = new db_class();


		$sql = sprintf("UPDATE cenote_news SET news_title = '%s',
												news_comment = '%s',
												news_date = '%s'
						WHERE news_id = %d",
		$inj->injection($this->request['news_title']),
		$inj->injection(str_replace("\n","<br />",$this->request['news_comment'])),
		$inj->injection($this->request['news_date']),
		$inj->injection($this->request['news_id'])
		);

		$db->putData($sql);
	}
	// 削除ファンクション
	private function del(){
		$inj = new injection_class();
		$db = new db_class();

		$sql = sprintf("DELETE FROM cenote_news WHERE news_id = %d",
		$inj->injection($this->request['news_id']));

		$db->putData($sql);
	}
}