<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/validate.php');
include_once('./cenote/core/db_class.php');
/* -------------------------------------------------------------------
 モジュールインスタンス
 -------------------------------------------------------------------- */
class news extends cenote_smarty {

	public $request;
	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	public $err_msg;
	/* 内部変数 */
	private $acl;

	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request 				= $req;
		$this->smarty->config_dir 	= "./modules/".$this->request['module'];
		$this->page					= $this->request['page'];
		$this->acl					= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/*------------------------------------------------------------
	 INIT 初期画面用項目セット初期化が必要な場合ここに記述
	 ------------------------------------------------------------ */
	public function init(){
	}
	/* ------------------------------------------------------------
		モジュールの利用権限確認
		------------------------------------------------------------ */
	public function acl(){
		return true;
	}

	/* ------------------------------------------------------------
		処理ごとの詳細な動作はこちらに記述
		--------------------------------------------------------- */
	public function action(){

		$ix = 0;
		$db = new db_class();
		
		// 選ばれたニュースIDを保持
		$newsid = "";
		if(isset($this->request['newsid'])){
			$newsid = $this->request['newsid'];
		}


		$sql = "SELECT * FROM cenote_news ORDER BY news_date DESC";

		if($db->getDataCnt($sql) > 0){

			$news_list = $db->getData2($sql);

			for($ix=0; $ix < count($news_list['news_title']); $ix++){
				$news_id[$ix] 	= $news_list['news_id'][$ix];
				$news_title[$ix] 	= $news_list['news_title'][$ix];
				$news_comment[$ix] = $news_list['news_comment'][$ix];
				$news_date[$ix] = $news_list['news_date'][$ix];
			}
			$this->assign("news_id",$news_id);
			$this->assign("news_title",$news_title);
			$this->assign("news_comment",$news_comment);
			$this->assign("news_date",$news_date);

			$this->assign("newsid",$newsid);
		}
		$this->assign("view",$ix);
	}
	/* ------------------------------------------------------------
		エラーメッセージ配列に追加する
		--------------------------------------------------------- */
	public function err_msg_add($str){
		$cnt = count($this->err_msg);
		$this->err_msg[$cnt] = $str;
	}
}
