<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/db_class.php');
include_once('./cenote/core/validate.php');
include_once('./cenote/core/injection_class.php');
include_once('./cenote/core/date_class.php');

/* ----------------------------------------------------------------
	モジュールインスタンス
	---------------------------------------------------------------- */
class adduser extends cenote_smarty {

	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	public $request;
	public $err;
	public $err_msg;
	public $e_count;


	/* 内部変数 */
	private $acl;

	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request			= $req;
		$this->smarty->config_dir = "./modules/".$this->request['module'];
		$this->page				= $this->request['page'];
		$this->acl				= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/* ------------------------------------------------------------
	 INIT 初期画面用項目セット初期化が必要な場合ここに記述
	 ------------------------------------------------------------ */
	public function init(){
		$this->err_msg = array();
		$this->err = false;
		$this->e_count = 0;
	}

	/* ------------------------------------------------------------
	 モジュールの利用権限確認
	 ------------------------------------------------------------ */
	public function acl(){
		return true;
	}

	/* ------------------------------------------------------------
	 処理ごとの詳細な動作はこちらに記述
	 --------------------------------------------------------- */
	public function action(){

		// 利用変数の初期化
		$db = new db_class();
		$inj = new injection_class();
		$update_msg = "";
		$this->err = false;
		$validate = new validate();
		// 初期の表示

		// 登録ボタンが押された
		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "ユーザー登録"){

				// 項目の内容を検査
				$this->err = false;

				if(!$this->request['adduser_account']){
					$this->err = TRUE;
					$this->dialog_msg_add("アカウント未入力"); 
				} else {
					if($validate->v_str_len($this->request['adduser_account'],5,20)){
						if($validate->v_account($this->request['adduser_account'])){
							$account = $this->request['adduser_account'];
						}else{
							$this->err = TRUE;
							$this->dialog_msg_add("アカウントはアルファベットのみ利用できます「A～Z,a～z,0～9」");
						}
					}else{
						$this->err = TRUE;
						$this->dialog_msg_add("アカウントは5文字以上18文字以内です。");
					}
					
				}
				if(!$this->request['adduser_name']){
					$this->err = TRUE;
					$this->dialog_msg_add("名前未入力");
				} else {
					$name = $this->request['adduser_name'];
				}
				if(!$this->request['adduser_password']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワード未入力");
				} else {
					if($validate->v_str_len($this->request['adduser_password'],5,20)){
						$password = $this->request['adduser_password'];
					}else{
						$this->err = TRUE;
						$this->dialog_msg_add("パスワードは5文字以上20文字以下です。");
					}
				}
				if($this->request['adduser_password'] != $this->request['adduser_password2']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワード1とパスワード2が違います。");
				}
				if(!$this->request['adduser_email']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL未入力");
				} else {
					if($validate->v_mail($this->request['adduser_email'])){
						$email = $this->request['adduser_email'];
					} else {
						$this->err = true;
						$this->dialog_msg_add("E-MAILのアドレスが違っています。"); 
					}
				}
				if($this->request['adduser_email'] != $this->request['adduser_email2']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL1とE-MAIL2が違います。");
				}
				$address1 = $this->request['adduser_address1'];
				$address2 = $this->request['adduser_address2'];
				$address3 = $this->request['adduser_address3'];
				$zip = $this->request['adduser_zip'];
				$introduce 	= $this->request['adduser_introduce'];
				$password2 	= $this->request['adduser_password2'];
				$email2 	= $this->request['adduser_email2'];

				//　同一アカウントの存在を確認
				$acc = $inj->injection($this->request['adduser_account']);
				$sql = "SELECT cenote_account FROM cenote_user WHERE cenote_account = '$acc'";
				if($db->getDataCnt($sql) != 0){
					$this->err = TRUE;
					$this->dialog_msg_add("ユーザー".$acc."は登録されています。");
				}
				//エラーがあるか
				if($this->err){
					// エラーあり					
					$this->smarty->assign("adduser_account",	$this->request['adduser_account']);
					$this->smarty->assign("adduser_name",		$this->request['adduser_name']);
					$this->smarty->assign("adduser_password",	"");
					$this->smarty->assign("adduser_email",		$this->request['adduser_email']);
					$this->smarty->assign("adduser_password2",	"");
					$this->smarty->assign("adduser_email2",		$this->request['adduser_email2']);
					$this->smarty->assign("adduser_zip",		$this->request['adduser_zip']);
					$this->smarty->assign("adduser_address1",	$this->request['adduser_address1']);
					$this->smarty->assign("adduser_address2",	$this->request['adduser_address2']);
					$this->smarty->assign("adduser_address3",	$this->request['adduser_address3']);
					$this->smarty->assign("adduser_introduce",	$this->request['adduser_introduce']);
				} else {
					//エラーなし
					$date = new date_class();
					//PostgreSQL の場合
					//TODO: MD5
					if(_DB_TYPE == "pgsql"){
						$sql = sprintf("INSERT INTO cenote_user (
						cenote_account,
						cenote_group,
						cenote_name,
						cenote_password,
						cenote_email_address,
						cenote_zipcode,
						cenote_address1,
						cenote_address2,
						cenote_address3,
						cenote_introduce,
						cenote_avater,
						cenote_valid,
						cenote_create_date,
						cenote_update_date) values (
						'%s',
						'MEMBER',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'AVATER',
						'false',
						'%s',
						'%s')",
						$inj->injection($this->request['adduser_account']),
						$inj->injection($this->request['adduser_name']),
						md5($this->request['adduser_password']),
						$inj->injection($this->request['adduser_email']),
						$inj->injection($this->request['adduser_zip']),
						$inj->injection($this->request['adduser_address1']),
						$inj->injection($this->request['adduser_address2']),
						$inj->injection($this->request['adduser_address3']),
						$inj->injection($this->request['adduser_introduce']),
						$date->get_date('datetime'),
						$date->get_date('datetime')
						);
					}
					// MySQLの場合
					if(_DB_TYPE == "mysql"){
						$sql = sprintf("INSERT INTO cenote_user (
						cenote_account,
						cenote_group,
						cenote_name,
						cenote_password,
						cenote_email_address,
						cenote_zipcode,
						cenote_address1,
						cenote_address2,
						cenote_address3,
						cenote_introduce,
						cenote_avater,
						cenote_valid,
						cenote_create_date,
						cenote_update_date) values (
						'%s',
						'MEMBER',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'AVATER',
						0,
						'%s',
						'%s')",
						$inj->injection($this->request['adduser_account']),
						$inj->injection($this->request['adduser_name']),
						md5($this->request['adduser_password']),
						$inj->injection($this->request['adduser_email']),
						$inj->injection($this->request['adduser_zip']),
						$inj->injection($this->request['adduser_address1']),
						$inj->injection($this->request['adduser_address2']),
						$inj->injection($this->request['adduser_address3']),
						$inj->injection($this->request['adduser_introduce']),
						$date->get_date('datetime'),
						$date->get_date('datetime')
						);
					}
					// DB登録
					if($db->putData($sql)){
						$this->page = 1;
					}else{
						$this->err = TRUE;
						$this->dialog_msg_add("ユーザー登録できませんでした");
					}
				}
			}
		}
		return $this->err;
	}

	/* ------------------------------------------------------------
	 メッセージを編集する
	 --------------------------------------------------------- */
	public function err_msg_add($str){

		$this->err_msg[$this->e_count] = $str;
		$this->e_count++;
	}

}