<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//


/**
 * バリデートクラス
 */
class validate{

	public $message;

	/* -----  コンストラクタ  ----- */
	public function __construct(){
		$this->message = "";
	}

	/**
	 * 数値か確認する
	 *
	 * @param $get 文字列
	 * @return bool true:数値　false:数値以外
	 */
	public function v_num($get){
		if(is_numeric($get)){
			return true;
		} else {
			$this->message = "数値ではありません";
			return false;
		}
	}
	/**
	 * 文字かを確認する
	 *
	 * @param $get 文字列
	 * @return bool true:文字列　false:NULL
	 */
	public function v_str($get){
		if(!is_null($get)){
			return true;
		}else{
			$this->message = "値がありません";
			return false;
		}
	}

	/**
	 * 数値が範囲内に入っているかを確認する
	 *
	 * @param $get 調べる値
	 * @param $from 範囲内の最小値
	 * @param $to 範囲内の最大値
	 * @return bool true=範囲内　false=範囲外
	 */
	public function v_num_between($get, $from, $to){
		if(is_numeric($get)){
			if($from <= $get){
				if($to >= $get){
					return true;
				}else{
					$this->message = "値が大きすぎます";
					return false;
				}

			}else{
				$this->message = "値が小さすぎます";
				return false;
			}
		}else{
			$this->message = "数値ではありません";
			return false;
		}
		return true;
	}

	/**
	 * 文字列が指定した長さを満たすか確認する
	 *
	 * @param $get 調べる値
	 * @param $from 最小文字数
	 * @param $to 最大文字数
	 * @return bool true=範囲内　false=範囲外
	 */
	public function v_str_len($get, $from, $to){
		$value = strlen($get);
		if($value == false){
			$message = "文字がありません";
			return false;
		} else {
			if($value >= $from){
				if($value <= $to){
					return true;
				}else {
					$this->message = "文字数が多すぎます";
					return false;
				}
			}else{
				$this->message = "文字数が少なすぎます";
				return false;
			}
		}
	}

	/**
	 * メールアドレスとして正しい形式か
	 *
	 * @param $get String
	 * @return bool true=正しい　false=誤り
	 */
	public function v_mail($get){
		if(ereg("^[^@]+@[^.]+\..+", $get)){
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 郵便番号として正しい形式か
	 *
	 * @param $get String
	 * @return bool true=正しい false=誤り
	 */
	public function v_zip($get){
		// 郵便番号チェック
		// TODO:未作成
		return true;
	}
	/**
	 * ユーザーアカウント文字チェック
	 * 
	 * ユーザーアカウントとして利用できる文字か確認する
	 * 文字は[A-Z][a-z][0-9]までとする。
	 *
	 * @param $get String
	 * @return bool true=正しい false=誤り
	 */
	public function v_account($get){
		if (preg_match('/^[a-zA-Z0-9_\.\-]+$/',$get)) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

}