<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
/**
 * menu class
 *
 * 登録されたモジュールをメニュー化しリンクする
 * widget内での表示に適した縦方向メニュー
 *
 */

include_once('./cenote/core/get_module_xml_config.php');
include_once('./cenote/core/group_class.php');

class menu {
	public function __construct(){

	}
	public function display(){

		$module = $_SESSION['module'];
		
		$group = new group_class();
		
		$group_arr = $group->get_group_array($_SESSION['acl']['group']);
		
		$html = "<div id=\"cenote_menu\"><p id=\"cenote_menu\">メニュー</p>";
		
		if(!is_array($group_arr)){
			$html .= "<li id=\"cenote_menu\">";
			$html .= "権限が設定されていません。<br />管理者に連絡してください";
			$html .= "</li>";
		} else {
			foreach($module['menu'] as $key => $value){
				for($ix = 0; $ix < count($group_arr); $ix++){
					if($module['name'][$key] == $group_arr[$ix]['cenote_group_module'] && 
						  $group_arr[$ix]['cenote_group_available'] > 0){
						if($module['module_order'][$key] != 0){
							$html .= "<li id=\"cenote_menu\">";
							$html .= "<span class=\"white_color\"><a href=\"index.php?mod=".$module['name'][$key]."\">".$value."</a></span>";
							$html .= "</li>";
						}
					}   
				}
			}
		}
		$html .= "</div>";
		return $html;
	}
}
