<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/**
 * calender class
 *
 * 簡単なカレンダーを表示するウィジット
 *
 */

define('YEAR', 0);
define('MONTH', 1);
define('DAY', 2);


class cenote_calender {
	public function __construct(){

	}
	public function display(){
		$date = date('Y n d');
		$date = explode(' ', $date);

		$date[MONTH] = (int) $date[MONTH];
		$date[YEAR] = (int) $date[YEAR];
		$date[DAY] = (int) $date[DAY];

		$days = date('d', mktime(0, 0, 0, $date[MONTH]+1, 0, $date[YEAR]));
		$first_day = date('w', mktime(0, 0, 0, $date[MONTH], 1, $date[YEAR]));
		$last_day = date('w', mktime(0, 0, 0, $date[MONTH], $days, $date[YEAR]));

		$last_week_days = ($days + $first_day) % 7;

		if ($last_week_days == 0){
			$weeks = ($days + $first_day) / 7;
		}else{
			$weeks = ceil(($days + $first_day) / 7);
		}

		$weeks = (int) $weeks;
		$last_day = (int) $last_day;
		$first_day = (int) $first_day;

		$html =  '<div class="cenote_calender">';
		$html .= '<p class="cenote_calender_title">カレンダー</p>';
		$html .= '<p class="cenote_calender_date">-'.$date[YEAR].'年'.$date[MONTH].'月-</p>';
		$html .= '<div class="cenote_week">日</div>';
		$html .= '<div class="cenote_week">月</div>';
		$html .= '<div class="cenote_week">火</div>';
		$html .= '<div class="cenote_week">水</div>';
		$html .= '<div class="cenote_week">木</div>';
		$html .= '<div class="cenote_week">金</div>';
		$html .= '<div class="cenote_week">土</div><div class="clear_left"></div>';

		$i=$j=$day=0;

		while($i<$weeks){
			$j=0;
			while($j<7){
				$html .= '<div class="cenote_day">';

				if(($i==0 && $j<$first_day) || ($i==$weeks-1 && $j>$last_day)){
					$html .=  '　</div>';
				}else{
					$html .=  ++$day."</div>";
				}
				$j++;
			}
			$html .=  '<div class="clear_left"></div>';
			$i++;
		}
		$html .=  '</div>';
		return $html;
	}
}