<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/validate.php');
include_once('./cenote/core/db_class.php');
/* -------------------------------------------------------------------
	モジュールインスタンス
-------------------------------------------------------------------- */
class video extends cenote_smarty {
	
	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	public $err_msg;
	/* 内部変数 */
	private $acl;
	
	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request 				= $req;
		$this->smarty->config_dir 	= "./modules/".$this->request['module'];
		$this->page					= $this->request['page'];
		$this->acl					= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/*------------------------------------------------------------
	   INIT 初期画面用項目セット初期化が必要な場合ここに記述
	------------------------------------------------------------ */
	public function init(){
	}
	/* ------------------------------------------------------------
		モジュールの利用権限確認
	------------------------------------------------------------ */
	public function acl(){
		return true;
	}

	/* ------------------------------------------------------------
		処理ごとの詳細な動作はこちらに記述
	   --------------------------------------------------------- */
	public function action(){
		
		$ix = 0;
		$db = new db_class();
		
		$videoid = "";
		if(isset($this->request['videoid'])){
			$videoid = $this->request['videoid'];
		}
		
		$sql = "SELECT * FROM cenote_video ORDER BY video_date DESC";

		if($db->getDataCnt($sql) > 0){
		
			$video_list = $db->getData2($sql);
		
			for($ix=0; $ix < count($video_list['video_title']); $ix++){
				$video_id[$ix] 		= $video_list['video_id'][$ix];
				$video_title[$ix] 	= $video_list['video_title'][$ix];
				$video_tag[$ix] 	= $video_list['video_tag'][$ix];
				$video_comment[$ix] = $video_list['video_comment'][$ix];
				$video_date[$ix] = $video_list['video_date'][$ix];
			}
			$this->assign("video_id",$video_id);
			$this->assign("video_title",$video_title);
			$this->assign("video_tag",$video_tag);
			$this->assign("video_comment",str_replace("\r\n","<br />",$video_comment));
			$this->assign("video_date",$video_date);
			
			$this->assign("videoid",$videoid);
		}
		$this->assign("view",$ix);
	}
	/* ------------------------------------------------------------
		エラーメッセージ配列に追加する
	   --------------------------------------------------------- */
	public function err_msg_add($str){
		$cnt = count($this->err_msg);
		$this->err_msg[$cnt] = $str;
	}
}
