<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/db_class.php');
include_once('./cenote/core/validate.php');
include_once('./cenote/core/get_module_config.php');
include_once('./cenote/core/get_module_xml_config.php');
include_once('./cenote/core/get_widget_config.php');
include_once('./cenote/core/get_widget_xml_config.php');
include_once('./cenote/core/logout_class.php');
include_once('./cenote/core/get_group.php');
include_once('./cenote/core/injection_class.php');
include_once('./cenote/core/date_class.php');
include_once('./cenote/core/create_module_db.php');
include_once('./cenote/core/help_class.php');

/* ----------------------------------------------------------------
 モジュールインスタンス
 ---------------------------------------------------------------- */
class AdminTool extends cenote_smarty {

	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	public $request;

	public $err;

	/* 内部変数 */
	private $acl;

	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request			= $req;
		$this->smarty->config_dir = "./modules/".$this->request['module'];
		$this->page				= $this->request['page'];
		$this->acl				= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/* ------------------------------------------------------------
	 INIT 初期画面用項目セット初期化が必要な場合ここに記述
	 ------------------------------------------------------------ */
	public function init(){
		// ダイアログメッセージ初期化
		$this->msg_count	= 0;
		$this->dialog_msg	= array();
	}

	/* ------------------------------------------------------------
	 モジュールの利用権限確認
	 ------------------------------------------------------------ */
	public function acl(){
		return true;
	}

	/* ------------------------------------------------------------
	 処理ごとの詳細な動作はこちらに記述
	 --------------------------------------------------------- */
	public function action(){
			
		global $cenote_version;
		$db = new db_class();

		/* DEBUG 用
		 foreach($this->request as $key => $value){
		 if($key == "user"){
		 foreach($this->request['user'] as $ukey => $uvalue){
		 echo "USER:".$ukey."=".$uvalue."<br ?>";
		 }
		 } else {
		 echo $key."=".$value."<br ?>";

		 }
		 }
		 var_dump($this->request);
		 */
		//ページごとの処理

		$chk = false;

		if($this->acl['account'] == 'guest'){
			$this->page0();
		}else{
			$group = new get_group();
			$group_av = $group->get_group_available($this->acl['group'],$this->request['module']);

			switch($group_av){
				case "0":
					break;
				case "1":
				case "2":
					$this->assign("menu_type","2");
					switch ($this->request['page']){
						case 0:
							$this->page0();
							break;
						case 1:
							break;
						case 2:
							$this->page2();
							break;
						case 3:
							break;
						case 4:
							break;
						case 5:
							break;
						case 6:
							break;
						case 7:
							$this->page7();
							break;
						case 8:
							$this->page8();
							break;
						case 9:
							$this->page9();
							break;
						default:
							$this->page0();
							break;
					}
					break;
						case "3":
							$this->assign("menu_type","1");
							switch ($this->request['page']){
								case 0:
									$this->page0();
									break;
								case 1:
									$this->page1();
									break;
								case 2:
									$this->page2();
									break;
								case 3:
									$this->page3();
									break;
								case 4:
									$this->page4();
									break;
								case 5:
									$this->page5();
									break;
								case 6:
									$this->page6();
									break;
								case 7:
									$this->page7();
									break;
								case 8:
									$this->page8();
									break;
								case 9:
									$this->page9();
									break;
								default:
									$this->page0();
									break;
							}
							break;
			}
		}
		$this->assign("user_name",$_SESSION['acl']['name']);
		return $this->err;
	}


	/*------------------------------------------------------------
	 各画面の処理
	 ------------------------------------------------------------*/
	/**
	 * Admin画面Login
	 */
	public function page0(){
		global $cenote_version;
		$db = new db_class();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "了解"){
				if($this->request['user']['account'] == "guest"){
					header("Location: index.php?mod=AdminTool");
				}
			}
		}

		$chk = false;
		$this->assign("cenote_version",_CENOTE_VERSION);
		if($this->acl['account'] != "guest"){

			// ユーザーがゲストでない場合　権限を確認する
			foreach($_SESSION['group'] as $key => $value){
				if($value > 1){
					$chk = true;
				}
			}
			if($chk == false){
				header("Location: index.php");
			}
		}
		if($chk){
			$this->assign("login_flg",true);
		} else {
			$this->assign("login_flg",false);
		}
	}
	/**
	 * テーマ選択画面
	 */
	public function page1(){
		$update_msg = "";
		// テーマ変更画面
		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "テーマ変更"){

				$a = file("./configuration.php");

				for($ix= 0 ; $ix < count($a); $ix++ ){
					if(mb_strpos($a[$ix],"define('_SITE_THEME', ")){
						$a[$ix] = "	define('_SITE_THEME', '".$this->request['radiobutton']."');\n";
					}
				}
				if(is_writable('./configuration.php')){
					$fp = fopen('./configuration.php','w');
					foreach($a as $key=>$value){
						fwrite($fp, $value);
					}
					fclose($fp);
					$view_theme = $this->request['radiobutton'];
					//$update_msg = "テーマは更新されました"; 
					$this->dialog_msg_add("テーマは更新されました");
				} else {
					$update_msg .= "configuration.phpは保存できませんでした。書込権限を確認してください。 <br />"; 
					$this->err = TRUE;
					$this->dialog_msg_add("configuration.phpは保存できませんでした。");
				}
			}
		}


		$i = 0;
		$dir = './themes/';
		if( $handle = @opendir($dir) ){
			while(($file = readdir($handle)) !== false ){
				if(is_dir($dir."/".$file)){
					if($file == ".") continue;
					if($file == "..") continue;

					$parser=xml_parser_create();
					$data=file_get_contents("$dir$file/theme.xml");
					xml_parse_into_struct($parser,$data,$vals,$index);
					xml_parser_free($parser);
					if($vals[$index['CENOTEVERSION'][0]]['value'] == _THEME_VERSION){
						$theme['name'][$i]			= $vals[$index['NAME'][0]]['value'];
						$theme['auther'][$i]		= $vals[$index['AUTHER'][0]]['value'];
						$theme['version'][$i]		= $vals[$index['VERSION'][0]]['value'];
						$theme['url'][$i]			= $vals[$index['URL'][0]]['value'];
						$theme['comment'][$i] 		= $vals[$index['COMMENT'][0]]['value'];
						$theme['image'][$i] 		= $vals[$index['IMAGE'][0]]['value'];
						$i++;
					}
				}
			}
			//foreach($theme['name'] as $key2 => $value){
			for($key = 0; $key < count($theme['name']); $key++){
				$name[$key] 	= $theme['name'][$key];
				$auther[$key] 	= $theme['auther'][$key];
				$version[$key] 	= $theme['version'][$key];
				$url[$key] 		= $theme['url'][$key];
				$comment[$key] 	= $theme['comment'][$key];
				$image[$key] 	= $theme['image'][$key];
			}
		}
		$this->assign("update_msg",$update_msg);
		$this->assign("name",$name);
		$this->assign("auther",$auther);
		$this->assign("version",$version);
		$this->assign("url",$url);
		$this->assign("comment",$comment);
		$this->assign("image",$image);

		// HELP表示
		$title = "テーマ更新";
		$text = '用意されたテーマの中から好みのテーマを選択しサイトの外見を変更することができます。<br />
		好みのテーマの<span class="attention_text">「選択」</span>ボタンにチェックを付け<span
			class="attention_text">「テーマ変更」</span>ボタンを押してください。<br />
		テーマはHTMLの知識があれば自分で作ることもできます。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);


		if(isset($view_theme)){
			$this->assign("view",$view_theme);
		}else{
			$this->assign("view",_SITE_THEME);
		}
	}
	/**
	 * モジュール選択画面
	 */
	public function page2(){
		$update_msg = "";
		$module = array();
		$dir = './modules/';
		$ix = 0;
		$grp = new get_group();
		$db = new db_class();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "モジュール定義更新"){

				if($grp->get_group_available($this->acl['group'],$this->request['module']) != "3"){
					$this->err = TRUE;
					$this->dialog_msg_add("AdminToolモジュールの管理権限がありません");
				} else {

					// 有効モジュールの更新

					$this->err = false;
					// vald キーがTRUEだったら削除
					if(isset($this->request['vald'])){
						foreach($this->request['vald'] as $key => $value){
							$db->startTransaction();
							$sql = "DELETE FROM cenote_modules WHERE module_name = '$value'";
							if(!$db->putData($sql)){
								$this->err = TRUE;
								$this->dialog_msg_add($value."モジュールは削除できません");
							}
							$sql = "DELETE FROM cenote_modules_page WHERE module_name = '$value'";
							if(!$db->putData($sql)){
								$this->err = TRUE;
								$this->dialog_msg_add($value."モジュールは削除できません");
							}

							// 削除するテーブルの検出
							$mod = new get_module_xml_config();
							$module = $mod->get_module();

							foreach($module['name'] as $modkey => $modvalue ){
								if($value == $modvalue){
									$moddb = $module['table'][$modkey];
								}
							}
							foreach($moddb as $dekkey => $delvalue ){
								if($delvalue != "none"){
									$sql = "DROP TABLE $delvalue";
									if(!$db->putData($sql)){
										$this->err = TRUE;
										$this->dialog_msg_add($value."モジュールデータベースは削除できません");
									}
								}
							}

							if($this->err){
								$db->rollbackTransaction();
							} else {
								$db->commitTransaction();
							}
						}
					}
					// modleオーダーナンバーを登録
					$this->err = false;
					foreach($this->request['module_order'] as $key => $value){
						$db->startTransaction();
						$sql = "UPDATE cenote_modules SET module_order = $value WHERE module_name = '$key'";
						if(!$db->putData($sql)){
							$this->err = TRUE;
							$this->dialog_msg_add($value."モジュールの順番は変更できませんでした");
						}
						if($this->err){
							$db->rollbackTransaction();
						} else {
							$db->commitTransaction();
						}
					}
					// メニュー名の空白はエラー
					foreach($this->request['menu'] as $key => $value){
						if(trim($value) == ""){
							$this->err = TRUE;
							$this->dialog_msg_add($value.$key."のメニュー名が入力されていません。元に戻しました");
						}
					}
					// メニュー名の登録
					// modleオーダーナンバーを登録
					if($this->err == false){
						foreach($this->request['menu'] as $key => $value){
							$db->startTransaction();
							$inj = new injection_class();
							$val = $inj->injection($value);
							$sql = "UPDATE cenote_modules set module_menu = '$val' WHERE module_name = '$key'";
							if(!$db->putData($sql)){
								$this->err = TRUE;
								$this->dialog_msg_add($value."モジュールのメニュー名は変更できませんでした");
							}
							if($this->err){
								$db->rollbackTransaction();
							} else {
								$db->commitTransaction();
							}
						}
					}
				}
			}
			if($this->request['Submit'] == "モジュールを有効化"){
				if($grp->get_group_available($this->acl['group'],$this->request['module']) != "3"){
					$this->err = TRUE;
					$this->dialog_msg_add("AdminToolモジュールの管理権限がありません");
				} else {

					// 有効化チェックボックの値を取得
					if(isset($this->request['uvald'])){

						$getmodxml = new get_module_xml_config();
						$module_xml = $getmodxml->get_module();
						$inj = new injection_class();
						foreach($module_xml['name'] as $key => $value){
							foreach($this->request['uvald'] as $key2 => $value2){
								if($value == $value2){
									// moduleの登録
									$sql = sprintf("INSERT INTO cenote_modules (
												module_name,
												module_api_name,
												module_menu,
												module_auther,
												module_version,
												module_url,
												module_editor,
												module_maintenance,
												module_comment,
												module_order
												)values(
												'%s','%s','%s','%s','%s','%s','%s','%s','%s',%d
												)",
									$module_xml['name'][$key],
									$module_xml['api_name'][$key],
									$module_xml['menu'][$key],
									$module_xml['auther'][$key],
									$module_xml['version'][$key],
									$module_xml['url'][$key],
									$module_xml['edit'][$key],
									$module_xml['maintenance'][$key],
									$module_xml['comment'][$key],
									$module_xml['module_order'][$key]);
									$db->putData($sql);
									// module_pageの登録
									foreach($module_xml['page_tpl'][$key] as $key3 => $value3){
										$sql = sprintf("INSERT INTO cenote_modules_page (
													module_name,
													module_page_tpl,
													module_page_name,
													module_page_order
													)values(
													'%s','%s','%s',%d
													)",
										$module_xml['name'][$key],
										$module_xml['page_tpl'][$key][$key3],
										$inj->injection($module_xml['page_name'][$key][$key3]),
										$module_xml['page_order'][$key][$key3]
										);
										$db->putData($sql);
									}

									// モジュールで利用するDBがある場合にクリエイトする。
									if($module_xml['table'][$key][0] != "none"){
										if(_DB_TYPE == "pgsql"){
											if(file_exists($dir.$module_xml['name'][$key]."/postgres.sql")){
												$c_db = new create_module_db();
												if(!$c_db->exist_table($module_xml['table'][$key][0])){
													$c_db->create_table($dir.$module_xml['name'][$key]."/postgres.sql");
												}
											}
										}
										if(_DB_TYPE == "mysql"){
											if(file_exists($dir.$module_xml['name'][$key]."/mysql.sql")){
												$c_db = new create_module_db();
												if(!$c_db->exist_table($module_xml['table'][$key][0])){
													$c_db->create_table($dir.$module_xml['name'][$key]."/mysql.sql");
												}
											}
										}
									}
									// モジュールのCSSファイルをキャラクタ変換
									$dir = "./modules/";
									$ix = 0;


									if(!file_exists("$dir$value2/module.css")) continue;

									$fp = fopen("$dir$value2/module.css",'r');

									while ( !feof($fp) ) {
										$edit .=  fgets($fp, 9182);
									}
									fclose($fp);


									switch($_SESSION['site_encode']){
										case "EUC-JP":
											$edit = mb_convert_encoding($edit,'EUCJP','UTF-8');
											break;
										case "SHIFT-JIS":
											$edit = mb_convert_encoding($edit,'SJIS','UTF-8');
											break;
									}

									$fp = fopen("$dir$value2/module.css",'w');
									fwrite($fp,$edit);
									fclose($fp);
								}
							}
						}
					}
				}
			}
		}

		// DBからconfig読み込み
		$getmoddb = new get_module_config();
		$module = $this->module = $_SESSION['module'] = $getmoddb->get_module();

		// XMLからconfig読み込み
		$getmodxml = new get_module_xml_config();
		$module_xml = $getmodxml->get_module();

		$ix = 0;
		foreach($module_xml['name'] as $key => $value){
			$val = false;
			foreach($module['name'] as $key2 => $value2){
				if($value == $value2){
					$val = true;
				}
			}
			if($val != true){
				$mod_list['name'][$ix] 		= $module_xml['name'][$key];
				$mod_list['api_name'][$ix] 	= $module_xml['api_name'][$key];
				$mod_list['auther'][$ix] 	= $module_xml['auther'][$key];
				$mod_list['version'][$ix] 	= $module_xml['version'][$key];
				$mod_list['url'][$ix] 		= $module_xml['url'][$key];
				$mod_list['comment'][$ix] 	= $module_xml['comment'][$key];
				$ix++;
			}
		}

		$group = $grp->get_group_module($this->acl['group']);
		//編集可能なモジュール情報を渡す
		$this->assign("edit_group",$group);

		// 画面にデータを渡す1
		if(isset($module)){
			$this->assign("name",$module['name']);
			$this->assign("api_name",$module['api_name']);
			$this->assign("menu",$module['menu']);
			$this->assign("auther",$module['auther']);
			$this->assign("version",$module['version']);
			$this->assign("url",$module['url']);
			$this->assign("comment",$module['comment']);
			$this->assign("module_order",$module['module_order']);
			$this->assign("up_cnt",count($module['name']));
		}
		// 画面にデータを渡す2
		if(isset($mod_list)){
			$this->assign("uname",$mod_list['name']);
			$this->assign("uapi_name",$mod_list['api_name']);
			$this->assign("uauther",$mod_list['auther']);
			$this->assign("uversion",$mod_list['version']);
			$this->assign("uurl",$mod_list['url']);
			$this->assign("ucomment",$mod_list['comment']);
			$this->assign("av_cnt",count($mod_list['name']));
		}
		$this->assign("update_msg",$update_msg);

		// HELP表示
		$title = "モジュールの有効／無効、メニュー表示の名称やメニューの並び順を設定します。";
		$text = '各モジュールの有効／無効を設定します、メニューに表示されるタイトル、メニューの並び順を設定します。<br />
				未登録モジュールの<span class="attention_text">「有効」</span>チェックボックスにチェックを付け<span class="attention_text">モジュール有効化</span>ボタンを押すとそのモジュールが活性化します。<br />
				登録済みモジュールの<span class="attention_text">「削除」</span>チェックボックスにチェックを付け<span class="attention_text">モジュール定義更新</span>ボタンを押すとそのモジュールは無効化されます。<br />
				<span class="attention_text">「並び」</span>はメニューに表示される順番を表します。（1～99の数値を入力してください、値が小さい順に並びます）<br />
				<span class="attention_text">「メニュー名」</span>メニューに表示される名称を記入します。<br />
				各内容を修正した後「モジュール定義更新」ボタンを押して保存してください。<br />
				<span class="attention_text">「作者URL」</span>はそのモジュールを作成した作者のアドレスです。<br />
				注意！AdminToolモジュールの権限が「管理」になっていないとこの項目は更新できません。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);

		// セッション情報の更新
		//$get_module = new get_module_xml_config();
		//$this->module = $_SESSION['module'] = $get_module->get_module();
	}
	/**
	 * ウィジット選択画面
	 */
	public function page3(){
		$update_msg = "";
		$widget = array();
		$dir = './widget/';
		$ix = 0;
		$db = new db_class();

		// ウィジット定義更新
		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "ウィジット定義更新"){
				/* 登録されたWidgetの修正や削除
				 ----------------------------------------------*/
				foreach($this->request['position'] as $key => $value){
					if($value != "del"){
						$sql = sprintf("UPDATE cenote_widget SET
							widget_position = '%s',
							widget_order = %d
							WHERE 
							widget_name = '%s'",
						$this->request['position'][$key],
						$this->request['order'][$key],
						$key);
						$db->putData($sql);
							
						$sql = "DELETE FROM cenote_widget_module WHERE widget_name = '$key'";
						$db->putData($sql);
							
						if(isset($this->request[$key])){
							foreach($this->request[$key] as $key2 => $value2){

								$sql = "INSERT INTO cenote_widget_module (
									widget_name,
									widget_module
									) values (
									'$key',
									'$key2')";
								$db->putData($sql);
							}
						}
					} else {
						$sql = "DELETE FROM cenote_widget WHERE widget_name = '$key'";
						$db->putData($sql);
							
						$sql = "DELETE FROM cenote_widget_module WHERE widget_name = '$key'";
						$db->putData($sql);
					}
				}


				if(!$this->dialog_msg){
					$this->dialog_msg_add("ウィジットは更新されました");
				}
			}
			if($this->request['Submit'] == "ウィジット有効化"){
				/* 未登録のWidgetを有効化
				 ----------------------------------------------*/
				$getwidxml = new get_widget_xml_config();
				$widget_xml = $getwidxml->get_widget();

				foreach($widget_xml['name'] as $key => $value){
					foreach($this->request['uvald'] as $key2 => $value2){
						if($value == $value2){
							// moduleの登録
							$sql = sprintf("INSERT INTO cenote_widget (
												widget_name,
												widget_position,
												widget_order,
												widget_version,
												widget_auther,
												widget_url,
												widget_comment
												)values(
												'%s','%s',%d,'%s','%s','%s','%s'
												)",
							$widget_xml['name'][$key],
							$widget_xml['position'][$key],
							$widget_xml['widget_order'][$key],
							$widget_xml['version'][$key],
							$widget_xml['auther'][$key],
							$widget_xml['url'][$key],
							$widget_xml['comment'][$key]);
							$db->putData($sql);
							// module_pageの登録
							if(isset($widget_xml['use_module'][$key])){
								foreach($widget_xml['use_module'][$key] as $key3 => $value3){
									$sql = sprintf("INSERT INTO cenote_widget_module (
													widget_name,
													widget_module
													)values(
													'%s','%s'
													)",
									$module_xml['name'][$key],
									$module_xml['use_module'][$key][$key3]

									);
									$db->putData($sql);
								}
							}

							/* --------------------------------------------*/
							if(!$this->dialog_msg){
								$this->dialog_msg_add("ウィジットは更新されました");
							}
						}
					}
				}
			}
		}

		// DBからWidget情報を取り出す
		$wid = new get_widget_config();
		$widget = $wid->get_widget();

		$mod = new get_module_config();
		$module	= $mod->get_module();


		if($widget){
			foreach($widget['name'] as $key => $value){
				foreach($module['name'] as $key2 => $value2){
					$widget['use_module'][$key][$key2] = "";
					$widget['module_name'][$key][$key2] = $module['name'][$key2];
					$widget['menu_name'][$key][$key2] 	= $module['menu'][$key2];
				}
			}
			if(isset($widget['module'])){
				foreach($widget['module'] as $key => $value){
					foreach($value as $key2 => $value2){

						/* 一覧表示された利用可能モジュールのON/OFF表示
						 ---------------------------------------------- */
						$widget['use_module'][$key][$key2]  = $value2;
					}
				}
			}
		}



		// Widget_XMLから情報を取り出す
		$wid2 = new get_widget_xml_config();
		$widget_xml = $wid2->get_widget();

		// すでに登録されたWidgetは除外
		$ix = 0;
		foreach($widget_xml['name'] as $key => $value){
			$val = false;
			if(isset($widget['name'])){
				foreach($widget['name'] as $key2 => $value2){
					if($value == $value2){
						$val = true;
					}
				}
			}
			if($val != true){
				$widget2['name'][$ix] 		= $widget_xml['name'][$key];
				$widget2['version'][$ix] 	= $widget_xml['version'][$key];
				$widget2['auther'][$ix] 	= $widget_xml['auther'][$key];
				$widget2['url'][$ix] 		= $widget_xml['url'][$key];
				$widget2['comment'][$ix] 	= $widget_xml['comment'][$key];
				$ix++;
			}
		}


		if(isset($widget)){
			if(count($widget)>0){
				// 画面に送信
				$this->assign("position",$widget['position']);
				$this->assign("order",$widget['order']);
				$this->assign("name",$widget['name']);
				$this->assign("version",$widget['version']);
				$this->assign("auther",$widget['auther']);
				$this->assign("url",$widget['url']);
				$this->assign("comment",$widget['comment']);
				$this->assign("up_cnt",count($widget['name']));

				$this->assign("module_name",$widget['module_name']);
				$this->assign("menu_name",$widget['menu_name']);
				$this->assign("use_module",$widget['use_module']);
			}
		}
		if(isset($widget2)){
			if(count($widget2)>0){
				$this->assign("uname",$widget2['name']);
				$this->assign("uversion",$widget2['version']);
				$this->assign("uauther",$widget2['auther']);
				$this->assign("uurl",$widget2['url']);
				$this->assign("ucomment",$widget2['comment']);
			}
		}
		if(isset($widget2)){
			$this->assign("av_cnt",count($widget2['name']));
		}else{
			$this->assign("av_cnt",0);
		}
		$this->assign("update_msg",$update_msg);
		// HELP表示
		$title = "ウィジット有効／無効・表示位置と並び順を設定します。";
		$text = 'ウィジットを有効にするには未登録ウィジットの中から<span class="attention_text">「有効」</span>の欄のチェックボックスにチェックを付け「<span class="attention_text">「ウィジット有効化」</span>ボタンを押してください。<br />
				削除する場合は登録済みウィジットのリストボックスの中から<span class="attention_text">「削除」</span>を選んでください。また一時的に停止する場合はリストボックスから<span class="attention_text">「無効」</span>を選んでください<br />
			注意！表示位置はテーマファイルに依存しますが、以下のような配置を想定しています。<br />
			　(1)<span class="attention_text">ヘッダー</span>：タイトル部分<br />
			　(2)<span class="attention_text">ナビ</span>：ナビゲーションメニュー部分<br />
			　(3)<span class="attention_text">左</span>：メインコンテンツの左側、<span class="attention_text">中</span>：メインコンテンツのセンター部分、<span class="attention_text">右</span>：メインコンテンツの右側<br />
			　(4)<span class="attention_text">フッター</span>：ページのフッター部分<br />
			<span class="attention_text">「並び」</span>は有効の欄で設定した場所での並びとなります1～99の範囲で入力してください。<br />
			<span class="attention_text">「このウィジットを表示するモジュール」</span>は、チェックを付けたモジュールが表示されたときにそのウィジットを表示するようにします。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);
	}
	/**
	 * グループ設定画面
	 */
	public function page4(){
		/* DEBUG 用
		 foreach($this->request as $key => $value){
		 if($key == "user"){
		 foreach($this->request['user'] as $ukey => $uvalue){
		 echo "USER:".$ukey."=".$uvalue."<br ?>";
		 }
		 } else {
		 echo $key."=".$value."<br ?>";

		 }
		 }
		 var_dump($this->request);
		 */

		// グループ編集時に出力する画面を選択しアサインする
		// 機能によりファンクションを呼ぶ
		if(isset($this->request['f'])){
			switch($this->request['f']){
				case "e":
					$this->page4e();
					$this->assign("func",$this->request['f']);
					break;
				case "a":
					$this->page4a();
					$this->assign("func",$this->request['f']);
					break;
				case "d":
					$this->page4d();
					$this->assign("func",$this->request['f']);
					break;
			}
		} else {
			$this->page4e();
			$this->assign("func","e");
		}
	}
	/**
	 * グループ設定画面 DBのグループを編集する
	 */
	public function page4e(){

		$db = new db_class();
		$update_msg = "";
		$inj = new injection_class();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "グループ定義更新"){
				// 同名のグループがないか
				foreach($this->request['new'] as $key => $value){
					foreach($this->request['new'] as $key2 => $value2){
						if($value == $value2 && $key != $key2){
							$this->err = true;
							$this->dialog_msg_add("同名のグループがあります。\\n同名のグループは作成できません。");
						}
					}
				}
				foreach($this->request['new'] as $key => $value){
					if(!trim($value)){
						$this->err = true;
						$this->dialog_msg_add("旧".$key."の新グループ名が空白です");
					}
				}
				// グループ名が変更されたものがあるか
				if(!$this->err){
					foreach($this->request['new'] as $key => $value){
						if($key != $value){
							// group更新
							$sql = sprintf("UPDATE cenote_group set cenote_group_name = '%s' where cenote_group_name = '%s'",
							$inj->injection($value),
							$inj->injection($key)
							);
							$db->startTransaction();
							if(!$db->putData($sql)){
								$this->err = true;
								$this->dialog_msg_add("データベースの更新に失敗しました");
								$db->rollbackTransaction();
							}else{
								//$update_msg = "グループ情報は正常に更新されました。";
								$this->dialog_msg_add("グループ情報は正常に更新されました。");
								$get_module = new get_module_config();
								$this->module = $_SESSION['module'] = $get_module->get_module();

								//USER更新
								$sql = sprintf("UPDATE cenote_user set cenote_group = '%s' where cenote_group = '%s'",
								$inj->injection($value),
								$inj->injection($key)
								);
								if(!$db->putData($sql)){
									$this->err = true;
									$this->dialog_msg_add("データベースの更新に失敗しました");
									$db->rollbackTransaction();
								}else{
									//$update_msg = "グループ情報は正常に更新されました。";
									//$this->dialog_msg_add("グループ情報は正常に更新されました。");
									$get_module = new get_module_config();
									$this->module = $_SESSION['module'] = $get_module->get_module();
									$db->commitTransaction();
								}
							}
						}
					}
					//権限情報の更新
					$db2 = new db_class();
					$db2->startTransaction();
					foreach($this->request['em'] as $key => $value){


						// 更新されたグループ名だった場合$keyをフックし新しいグループ名に差し替える
						$newGroup = $key;
						foreach($this->request['new'] as $old => $new){
							if($key == $old){
								$newGroup = $inj->injection($new);
							}
						}


						foreach($this->request['em'][$key] as $key2 => $value2){
							$sql = "SELECT * from cenote_group where cenote_group_name = '$newGroup' and cenote_group_module = '$key2'";
							if($db2->getDataCnt($sql) == 0){
								// 権限追加
								$sql = "INSERT INTO cenote_group VALUES('$newGroup','$key2',$value2)";

							} else {
								// 権限更新
								$result = $db2->getData2($sql);
								if($result['cenote_group_name'][0] ==  $newGroup and
								$result['cenote_group_module'][0] == $key2 and
								$result['cenote_group_available'][0] == $value2){
									// すべて同じ場合はなにもしない
								} else {
									if($newGroup == "ADMIN" && $key2 == "AdminTool"){
										$this->err = true;
										$this->dialog_msg_add("グループADMINのAdminTool利用権限を変更するとサイトのメンテナンスができなくなります\\n変更されませんでした。");
									} else {
										$sql = "UPDATE cenote_group SET cenote_group_available = $value2 where cenote_group_name = '$newGroup' and cenote_group_module = '$key2'";
										if(!$db2->putData($sql)){
											$this->err = true;
											$this->dialog_msg_add("データベースの更新に失敗しました");
										} else {
											//$update_msg = "グループは更新されました";
											//$this->dialog_msg_add("グループは更新されました");
										}
									}
								}
							}
							if(!$db2->putData($sql)){
								$this->err = true;
								$this->dialog_msg_add("データベースの更新に失敗しました");
							}
						}
					}
					if ($this->err){
						$db2->rollbackTransaction();
					}else{
						$db2->commitTransaction();
						$this->dialog_msg_add("グループは更新されました");
					}
				}
			}
		}

		$sql = "SELECT cenote_group_name FROM cenote_group GROUP BY cenote_group_name ORDER BY cenote_group_name";
		$result = $db->getData2($sql);

		// DBからグループ利用モジュールを採取
		foreach($result['cenote_group_name'] as $key => $value ){
			$sql = "SELECT * FROM cenote_group WHERE cenote_group_name = '$value' ORDER BY cenote_group_module";
			$result2 = $db->getData2($sql);
			foreach($result2['cenote_group_module'] as $key2 => $value2){
				$gedit[$value][$value2] = $result2['cenote_group_available'][$key2];
			}

		}
		// ./module/から新規に追加されたモジュール情報を採取
		$mod = new get_module_config();
		$mod_arr = $mod->get_module();
		foreach($mod_arr['name'] as $key =>$value){
			$alive = false;
			foreach($gedit['GUEST'] as $key2 => $value2){
				if($value == $key2){ $alive = true; }
			}
			if(!$alive){
				foreach($gedit as $key3 => $value3){
					$gedit[$key3][$value] = "0";
				}
			}
		}

		//権限：0：利用不可　1:利用可　2:書き込み可　3：削除可
		foreach($gedit as $key => $value){
			$this->assign("gedit",$gedit);
		}

		$this->assign("gedit_name",$mod_arr['name']);
		$this->assign("gedit_menu",$mod_arr['menu']);
		$this->assign("update_msg",$update_msg);
		// HELP表示
		$title = "グループの編集や権限の変更を行います";
		$text = 'グループの中に<span class="attention_text">１つ</span>でも更新が含まれる場合はそのグループのAdminToolモジュールは参照にしてください。<br />
			<span class="attention_text">「不可」</span>は利用することができなくなります。<br />
			<span class="attention_text">「参照」</span>は表示のみ出来ますが変更や修正はできません。<br />
			<span class="attention_text">「更新」</span>はデザインを変更したり、そのモジュールの設定を変更したり出来ます。<br />
			<span class="attention_text">「管理」</span>はそのモジュール自体を有効にしたり名前を変更したりできます。<br />
			<span class="attention_text">「ADMIN」「MEMBER」「GUEST」</span>はシステムで固定されています。それ以外の登録したグループは自由に名称を変更することができます。<br />
			注意！<span class="attention_text">「管理」</span>はモジュール自体の動作を変更する権限も持っています。管理者のみに与えるようにしてください。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);

	}
	/**
	 * グループ設定画面 DBのグループを追加する
	 */
	public function page4a(){
		// メッセージ初期化		
		$update_msg = "";
		$db = new db_class();
		$inj = new injection_class();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "追加"){
				if(isset($this->request['grp'])){

					$group = trim($inj->injection($this->request['grp']));
					if($group){
						$sql = "SELECT * FROM cenote_group WHERE cenote_group_name = '$group'";
						if($db->getDataCnt($sql) > 0){
							$this->err = true;
							$this->dialog_msg_add("同名のグループが登録されています"); 
						} else {
							// GUESTユーザーと同じモジュールをコピーし、作られたロール名で登録する
							$sql = "SELECT cenote_group_module FROM cenote_group WHERE cenote_group_name = 'GUEST'";
							$result = $db->getData2($sql);
							foreach($result['cenote_group_module'] as $key => $value){
								$sql2 = "INSERT INTO cenote_group VALUES('$group','$value',0)";
								$db->putData($sql2);
								//$update_msg = "グループは追加されました。";
								$this->dialog_msg_add("グループは追加されました。");
							}
						}
					}
				}
			}
		}




		/*
		 $sql = "SELECT cenote_group_name FROM cenote_group GROUP BY cenote_group_name";
		 $result = $db->getData2($sql);
		 foreach($result['cenote_group_name'] as $key => $value){
		 $group_name[$key] = $value;
		 }
		 */
		$group_name = $this->get_group_list();
		$this->assign("group_name",$group_name);
		$this->assign("update_msg",$update_msg);

		// HELP表示
		$title = "新しいグループを作成します。";
		$text = '下段に表示されている「現在登録されているグループは」すでに作成されていますので<br />
			同名のグループを作ることはできません。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);



	}
	/**
	 * グループ設定画面 DBのグループを削除する
	 */
	public function page4d(){

		$update_msg = "";
		$db = new db_class();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "削除"){
				if(isset($this->request['del'])){
					foreach($this->request['del'] as $key => $value){

						if($key != "ADMIN" && $key != "MEMBER" && $key != "GUEST"){
							$sql = "SELECT cenote_group FROM cenote_user WHERE cenote_group = '$key'";
							if($db->getDataCnt($sql) > 0){
								$this->err = true;
								$this->dialog_msg_add($key."グループにはユーザーが存在します。\\n先にユーザーを削除するかグループを変更してください"); 
							} else {
								$sql = "DELETE FROM cenote_group WHERE cenote_group_name = '$key'";
								if(!$db->putData($sql)){
									$this->err = true;
									$this->dialog_msg_add("削除できませんでした"); 
								} else {
									//$update_msg = "グループは削除されました";
									$this->dialog_msg_add("グループは削除されました");
								}
							}
						}else{
							$this->err = true;
							$this->dialog_msg_add($key."グループはシステムで必要なグループです。削除できません。"); 
						}

					}
				}
			}
		}

		$sql = "SELECT cenote_group_name FROM cenote_group GROUP BY cenote_group_name";
		$result = $db->getData2($sql);
		foreach($result['cenote_group_name'] as $key => $value){
			$group_name[$key] = $value;
		}
		$this->assign("group_name",$group_name);
		$this->assign("update_msg",$update_msg);

		// HELP表示
		$title = "グループを削除します。";
		$text = '下段に表示されているのは現在登録されているグループです。不要なグループの前のチェックボックに<br />
			チェックを付けて削除ボタンを押してください。<br />
			ただし、削除しようとしたグループにユーザーが登録されている場合は削除できません、「ユーザーの追加と編集」で<br />
			ユーザーの所属しているグループを変更して削除してください。<br />
			注意！「<span class="attention_text">ADMIN</span>」「<span class="attention_text">GUEST</span>」「<span class="attention_text">MEMBER</span>」はシステムで利用するグループです。削除はできません。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);


	}
	/**
	 * ユーザー設定画面
	 */
	public function page5(){
		// ユーザー編集時に出力する画面を選択しアサインする
		// 機能によりファンクションを呼ぶ
		if(isset($this->request['f'])){
			switch($this->request['f']){
				case "e":
					$this->page5e();
					$this->assign("func",$this->request['f']);
					break;
				case "a":
					$this->page5a();
					$this->assign("func",$this->request['f']);
					break;
				case "u":
					$this->page5u();
					$this->assign("func",$this->request['f']);
					break;
			}
		} else {
			$this->page5e();
			$this->assign("func","e");
		}
	}
	/**
	 * ユーザー設定画面 DBのユーザーを編集する
	 */
	public function page5e(){
		// メッセージ初期化		
		$update_msg = "";
		$db = new db_class();
		$inj = new injection_class();

		// USER アカウントが指定された

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "検索"){

				// 検索条件作成
				$tmp = "";
				if(trim($this->request['s_account'])){
					$this->assign("s_account",$this->request['s_account']);
					$tmp .= "cenote_account = '".$inj->injection($this->request['s_account'])."'";
				}
				if(trim($this->request['s_name'])){
					$this->assign("s_name",$this->request['s_name']);
					if($tmp){
						$tmp .= " and ";
					}
					$tmp .= "cenote_name like '%".$inj->injection($this->request['s_name'])."%'";
				}
				if(trim($this->request['s_email'])){
					$this->assign("s_email",$this->request['s_email']);
					if($tmp){
						$tmp .= " and ";
					}
					$tmp .= "cenote_email_address like '%".$inj->injection($this->request['s_email'])."%'";
				}
				if(trim($this->request['s_group'])){
					$this->assign("s_group",$this->request['s_group']);
					if($tmp){
						$tmp .= " and ";
					}
					$tmp .= "cenote_group  = '".$this->request['s_group']."'";
				}
				if($tmp){
					$tmp = " WHERE ".$tmp;
				}

				$sql = "SELECT * FROM cenote_user ".$tmp. " ORDER BY cenote_account";

				if($db->getDataCnt($sql) > 0){

					$result = $db->getData2($sql);

					foreach($result['cenote_account'] as $key => $value){
						$user_list_account[$key] 	= $result['cenote_account'][$key];
						$user_list_name[$key] 		= $result['cenote_name'][$key];
						$user_list_group[$key]		= $result['cenote_group'][$key];
						$user_list_email[$key]		= $result['cenote_email_address'][$key];
					}


					$this->assign("user_list_account",$user_list_account);
					$this->assign("user_list_name",$user_list_name);
					$this->assign("user_list_group",$user_list_group);
					$this->assign("user_list_email",$user_list_email);
				} else {
					$this->err = TRUE;
					$this->dialog_msg_add("ユーザーが見つかりません");
				}
			}
		}
		// SELECTボックスの既定値
		$group_list = $this->get_group_list();
		$this->assign("group_list",$group_list);

		// HELP表示
		$title = "ユーザーの編集";
		$text = 'ユーザーを編集するには「アカウント」「名前」「EMail」「グループ」のいずれかを入れて<span
			class="attention_text">「検索ボタン」</span>を押します。<br />
		条件により該当するユーザーが下段に表示されます。<br />
		表示されたアカウントをクリックすると編集画面が表示されます、適宜修正してください。<br />
		また、条件を入れずに検索すると全件表示されます。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);

	}
	/**
	 * ユーザー設定画面 DBのユーザーを追加する
	 */
	public function page5a(){
		// メッセージ初期化		
		$update_msg = "";
		$db = new db_class();
		$inj = new injection_class();
		$validate = new validate();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "ユーザー登録"){
				//項目のチェック
				$this->err = false;

				if(!$this->request['account']){
					$this->err = TRUE;
					$this->dialog_msg_add("アカウント未入力");
				} else {

					if($validate->v_str_len($this->request['account'],5,18)){
						if($validate->v_account($this->request['account'])){
							$account = $this->request['account'];
						}else{
							$this->err = TRUE;
							$this->dialog_msg_add("アカウントはアルファベットのみ利用できます「A～Z,a～z,0～9」");
						}
					}else{
						$this->err = TRUE;
						$this->dialog_msg_add("アカウントは5文字以上18文字以内です。");
					}



					$account = $this->request['account'];
				}
				if(!$this->request['name']){
					$this->err = TRUE;
					$this->dialog_msg_add("名前未入力");
				} else {
					$name = $this->request['name'];
				}
				if(!$this->request['password']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワード未入力");
				} else {
					if($validate->v_str_len($this->request['password'],5,20)){
						$password = $this->request['password'];
					}else{
						$this->err = TRUE;
						$this->dialog_msg_add("パスワードは5文字以上20文字以下です。");
					}
				}
				if($this->request['password'] != $this->request['password2']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワード1とパスワード2が違います。");
				}
				if(!$this->request['email']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL未入力");
				} else {
					$valdate = new validate();
					if($valdate->v_mail($this->request['email'])){
						$email = $this->request['email'];
					} else {
						$this->err = true;
						$this->dialog_msg_add("E-MAILのアドレスが違っています。"); 
					}
				}
				if($this->request['email'] != $this->request['email2']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL1とE-MAIL2が違います。");
				}
				$group = $this->request['group'];
				$address1 = $this->request['address1'];
				$address2 = $this->request['address2'];
				$address3 = $this->request['address3'];
				$zip = $this->request['zip'];
				$introduce 	= $this->request['introduce'];
				$password2 	= $this->request['password2'];
				$email2 	= $this->request['email2'];

				//　同一アカウントの存在を確認
				$acc = $inj->injection($this->request['account']);
				$sql = "SELECT cenote_account FROM cenote_user WHERE cenote_account = '$acc'";
				if($db->getDataCnt($sql) != 0){
					$this->err = TRUE;
					$this->dialog_msg_add("ユーザー".$acc."は登録されています。");
				}

				if(!$this->err){
					$date = new date_class();
					//TODO: MD5
					if(_DB_TYPE == "pgsql"){
						$sql = sprintf("INSERT INTO cenote_user (
						cenote_account,
						cenote_group,
						cenote_name,
						cenote_password,
						cenote_email_address,
						cenote_zipcode,
						cenote_address1,
						cenote_address2,
						cenote_address3,
						cenote_introduce,
						cenote_avater,
						cenote_valid,
						cenote_create_date,
						cenote_update_date
						) values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','AVATER','false','%s','%s')",
						$inj->injection($this->request['account']),
						$inj->injection($this->request['group']),
						$inj->injection($this->request['name']),
						md5($this->request['password']),
						$inj->injection($this->request['email']),
						$inj->injection($this->request['zip']),
						$inj->injection($this->request['address1']),
						$inj->injection($this->request['address2']),
						$inj->injection($this->request['address3']),
						$inj->injection($this->request['introduce']),
						$date->get_date('datetime'),
						$date->get_date('datetime')
						);
					}
					//TODO: md5
					if(_DB_TYPE == "mysql"){
						$sql = sprintf("INSERT INTO cenote_user (
						cenote_account,
						cenote_group,
						cenote_name,
						cenote_password,
						cenote_email_address,
						cenote_zipcode,
						cenote_address1,
						cenote_address2,
						cenote_address3,
						cenote_introduce,
						cenote_avater,
						cenote_valid,
						cenote_create_date,
						cenote_update_date
						) values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','AVATER',0,'%s','%s')",
						$inj->injection($this->request['account']),
						$inj->injection($this->request['group']),
						$inj->injection($this->request['name']),
						md5($this->request['password']),
						$inj->injection($this->request['email']),
						$inj->injection($this->request['zip']),
						$inj->injection($this->request['address1']),
						$inj->injection($this->request['address2']),
						$inj->injection($this->request['address3']),
						$inj->injection($this->request['introduce']),
						$date->get_date('datetime'),
						$date->get_date('datetime')
						);
					}



					if(!$db->putData($sql)){
						$this->err = TRUE;
						$this->dialog_msg_add("ユーザー登録に失敗しました。");
					} else {
						$update_msg = "ユーザー".$this->request['account']."は追加されました。";
						$this->dialog_msg_add("ユーザー".$this->request['account']."は追加されました。");
					}
				}
			}
		}

		$account	= isset($account) ? $account : "";
		$name		= isset($name) ? $name : "";
		$group		= isset($group) ? $group : "";
		$password	= isset($password) ? $password : "";
		$email		= isset($email) ? $email : "";
		$password2	= isset($password2) ? $password2 : "";
		$email2		= isset($email2) ? $email2 : "";
		$zip		= isset($zip) ? $zip : "";
		$address1	= isset($address1) ? $address1 : "";
		$address2	= isset($address2) ? $address2 : "";
		$address3	= isset($address3) ? $address3 : "";
		$introduce	= isset($introduce) ? $introduce : "";
		$avater		= isset($avater) ? $avater : "";
		$valid		= isset($valid) ? $valid : "";

		if(isset($this->request['ua'])){
			$user = $this->request['ua'];
			$sql = "SELECT * FROM cenote_user WHERE cenote_account = '$user'";
			$result = $db->getData2($sql);

			$account 	= $result['cenote_account'][0];
			$name 		= $result['cenote_name'][0];
			$group 		= $result['cenote_group'][0];
			//$password	= $result['cenote_password'][0];
			$password = "";
			$email 		= $result['cenote_email_address'][0];
			$zip 		= $result['cenote_zipcode'][0];
			$address1 	= $result['cenote_address1'][0];
			$address2 	= $result['cenote_address2'][0];
			$address3 	= $result['cenote_address3'][0];
			$introduce 	= $result['cenote_introduce'][0];
			$avater 	= $result['cenote_avater'][0];
			$valid 		= $result['cenote_valid'][0];
		}

		$this->assign("account",$account);
		$this->assign("name",$name);
		$this->assign("group",$group);
		$this->assign("password","");
		$this->assign("email",$email);
		$this->assign("password2","");
		$this->assign("email2",$email2);
		$this->assign("zip",$zip);
		$this->assign("address1",$address1);
		$this->assign("address2",$address2);
		$this->assign("address3",$address3);
		$this->assign("introduce",$introduce);
		$this->assign("avater",$avater);
		$this->assign("valid",$valid);
		// 更新メッセージ
		$this->assign("update_msg",$update_msg);

		// SELECTボックスの既定値
		$group_list = $this->get_group_list();
		$this->assign("group_list",$group_list);

		// HELP表示
		$title = "ユーザーの追加";
		$text = '管理者がユーザーを追加する場合に利用します。<br />
			<span class="attention_text">「*」</span>印付きの項目は必ず入力してください。<br />
			最後に<span class="attention_text">「ユーザーの登録」</span>ボタンを押して登録します。<br />
			注意！同名のアカウントは登録できません。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);
	}
	/**
	 * ユーザー設定画面 DBのユーザーを更新する
	 */
	public function page5u(){
		// メッセージ初期化		
		$update_msg = "";
		$db = new db_class();
		$inj = new injection_class();
		$validate = new validate();

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "ユーザーの更新"){
				//項目のチェック
				$this->err = false;

				if(!$this->request['account']){
					$this->err = TRUE;
					$this->dialog_msg_add("アカウント未入力");
				} else {
					$account = $this->request['account'];
				}
				if(!$this->request['name']){
					$this->err = TRUE;
					$this->dialog_msg_add("名前未入力");
				} else {
					$name = $this->request['name'];
				}
				/*
				 if(!$this->request['password']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワードが空白です。");
					} else {
					$password = $this->request['password'];
					}
					if($this->request['password'] != $this->request['password2']){
					$this->err = TRUE;
					$this->dialog_msg_add("パスワードが違います。");
					}
					*/
				if(!$this->request['email']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL未入力");
				} else {
					$valdate = new validate();
					if($valdate->v_mail($this->request['email'])){
						$email = $this->request['email'];
					} else {
						$this->err = true;
						$this->dialog_msg_add("E-MAILのアドレスが違っています。"); 
					}
				}
				if($this->request['email'] != $this->request['email2']){
					$this->err = TRUE;
					$this->dialog_msg_add("E-MAIL1とE-MAIL2が違います。");
				}
				$group = $this->request['group'];
				$address1 = $this->request['address1'];
				$address2 = $this->request['address2'];
				$address3 = $this->request['address3'];
				$zip = $this->request['zip'];
				$introduce 	= $this->request['introduce'];
				$password2 	= $this->request['password2'];
				$email2 	= $this->request['email2'];
				if(isset($this->request['valid'])){
					if($this->request['account'] == "admin"){
						$this->err = TRUE;
						$this->dialog_msg_add("ユーザー「admin」は停止できません。");
						$valid = 0;
					} else {
						$valid = ($this->request['valid'] == "on")? 1 : 0;
					}
				} else {
					$valid = 0;
				}

				//　同一アカウントの存在を確認
				$acc = $inj->injection($this->request['account']);
				$sql = "SELECT cenote_account FROM cenote_user WHERE cenote_account = '$acc'";
				if($db->getDataCnt($sql) == 0){
					$this->err = TRUE;
					$this->dialog_msg_add("ユーザー".$acc."は登録されていません。");
				}

				if(!$this->err){
					$date = new date_class();

					if($this->request['password'] || $this->request['password2']){
						if($this->request['password'] == $this->request['password2']){
							if($validate->v_str_len($this->request['password'],5,20)){
								if(_DB_TYPE == "pgsql"){
									$sql = sprintf("UPDATE cenote_user SET
									cenote_account 			= '%s',
									cenote_group			= '%s',
									cenote_name				= '%s',
									cenote_password 		= '%s',
									cenote_email_address	= '%s',
									cenote_zipcode			= '%s',
									cenote_address1			= '%s',
									cenote_address2 		= '%s',
									cenote_address3 		= '%s',
									cenote_introduce 		= '%s',
									cenote_avater			= 'AVATER',
									cenote_valid			= '%s',
									cenote_update_date		= '%s'
									WHERE cenote_account 	= '%s'",
									$inj->injection($this->request['account']),
									$inj->injection($this->request['group']),
									$inj->injection($this->request['name']),
									md5($this->request['password']),
									$inj->injection($this->request['email']),
									$inj->injection($this->request['zip']),
									$inj->injection($this->request['address1']),
									$inj->injection($this->request['address2']),
									$inj->injection($this->request['address3']),
									$inj->injection($this->request['introduce']),
									($valid)?"true":"false" ,
									$date->get_date('datetime'),
									$inj->injection($this->request['account']));
								}
								if(_DB_TYPE == "mysql"){
									$sql = sprintf("UPDATE cenote_user SET
									cenote_account 			= '%s',
									cenote_group			= '%s',
									cenote_name				= '%s',
									cenote_password 		= '%s',
									cenote_email_address	= '%s',
									cenote_zipcode			= '%s',
									cenote_address1			= '%s',
									cenote_address2 		= '%s',
									cenote_address3 		= '%s',
									cenote_introduce 		= '%s',
									cenote_avater			= 'AVATER',
									cenote_valid			= '%s',
									cenote_update_date		= '%s'
									WHERE cenote_account 	= '%s'",
									$inj->injection($this->request['account']),
									$inj->injection($this->request['group']),
									$inj->injection($this->request['name']),
									md5($this->request['password']),
									$inj->injection($this->request['email']),
									$inj->injection($this->request['zip']),
									$inj->injection($this->request['address1']),
									$inj->injection($this->request['address2']),
									$inj->injection($this->request['address3']),
									$inj->injection($this->request['introduce']),
									($valid)?1:0 ,
									$date->get_date('datetime'),
									$inj->injection($this->request['account']));
								}

								if(!$db->putData($sql)){
									$this->err = TRUE;
									$this->dialog_msg_add("ユーザー登録異常");
								}else{
									//$update_msg = "ユーザー".$this->request['account']."は更新されました。";
									$this->dialog_msg_add("ユーザー".$this->request['account']."は更新されました。");
								}
							}else{
								$this->err = TRUE;
								$this->dialog_msg_add("パスワードは5文字以上20文字以下です。");
							}
						}else{
							$this->err = TRUE;
							$this->dialog_msg_add("パスワードが違います。");
						}
							
					}else{

						// アップデート

						if(_DB_TYPE == "pgsql"){
							$sql = sprintf("UPDATE cenote_user SET
							cenote_account 			= '%s',
							cenote_group			= '%s',
							cenote_name				= '%s',
							cenote_email_address	= '%s',
							cenote_zipcode			= '%s',
							cenote_address1			= '%s',
							cenote_address2 		= '%s',
							cenote_address3 		= '%s',
							cenote_introduce 		= '%s',
							cenote_avater			= 'AVATER',
							cenote_valid			= '%s',
							cenote_update_date		= '%s'
							WHERE cenote_account 	= '%s'",
							$inj->injection($this->request['account']),
							$inj->injection($this->request['group']),
							$inj->injection($this->request['name']),
							$inj->injection($this->request['email']),
							$inj->injection($this->request['zip']),
							$inj->injection($this->request['address1']),
							$inj->injection($this->request['address2']),
							$inj->injection($this->request['address3']),
							$inj->injection($this->request['introduce']),
							($valid)?"true":"false" ,
							$date->get_date('datetime'),
							$inj->injection($this->request['account']));
						}
						if(_DB_TYPE == "mysql"){
							$sql = sprintf("UPDATE cenote_user SET
							cenote_account 			= '%s',
							cenote_group			= '%s',
							cenote_name				= '%s',
							cenote_email_address	= '%s',
							cenote_zipcode			= '%s',
							cenote_address1			= '%s',
							cenote_address2 		= '%s',
							cenote_address3 		= '%s',
							cenote_introduce 		= '%s',
							cenote_avater			= 'AVATER',
							cenote_valid			= '%s',
							cenote_update_date		= '%s'
							WHERE cenote_account 	= '%s'",
							$inj->injection($this->request['account']),
							$inj->injection($this->request['group']),
							$inj->injection($this->request['name']),
							$inj->injection($this->request['email']),
							$inj->injection($this->request['zip']),
							$inj->injection($this->request['address1']),
							$inj->injection($this->request['address2']),
							$inj->injection($this->request['address3']),
							$inj->injection($this->request['introduce']),
							($valid)?1:0 ,
							$date->get_date('datetime'),
							$inj->injection($this->request['account']));
						}
						if(!$db->putData($sql)){
							$this->err = TRUE;
							$this->dialog_msg_add("ユーザー登録異常");
						}else{
							//$update_msg = "ユーザー".$this->request['account']."は更新されました。";
							$this->dialog_msg_add("ユーザー".$this->request['account']."は更新されました。");
						}
					}
				}
			}
		}

		//項目初期化
		$account	= isset($account) ? $account : "";
		$name		= isset($name) ? $name : "";
		$group		= isset($group) ? $group : "";
		$password	= isset($password) ? $password : "";
		$email		= isset($email) ? $email : "";
		$password2	= isset($password2) ? $password2 : "";
		$email2		= isset($email2) ? $email2 : "";
		$zip		= isset($zip) ? $zip : "";
		$address1	= isset($address1) ? $address1 : "";
		$address2	= isset($address2) ? $address2 : "";
		$address3	= isset($address3) ? $address3 : "";
		$introduce	= isset($introduce) ? $introduce : "";
		$avater		= isset($avater) ? $avater : "";
		$valid		= isset($valid) ? $valid : "";


		if(isset($this->request['ua'])){
			$user = $inj->injection($this->request['ua']);
			$sql = "SELECT * FROM cenote_user WHERE cenote_account = '$user'";
			$result = $db->getData2($sql);

			$account 	= $result['cenote_account'][0];
			$name 		= $result['cenote_name'][0];
			$group 		= $result['cenote_group'][0];
			//$password	= $result['cenote_password'][0];
			//$password2	= $result['cenote_password'][0];
			$password	= "";
			$password2	= "";
			$email 		= $result['cenote_email_address'][0];
			$zip 		= $result['cenote_zipcode'][0];
			$address1 	= $result['cenote_address1'][0];
			$address2 	= $result['cenote_address2'][0];
			$address3 	= $result['cenote_address3'][0];
			$introduce 	= $result['cenote_introduce'][0];
			$avater 	= $result['cenote_avater'][0];
			$valid 		= $result['cenote_valid'][0];
		}

		$this->assign("account",$account);
		$this->assign("name",$name);
		$this->assign("group",$group);
		//$this->assign("password",$password);
		//$this->assign("password2",$password2);
		$password	= "";
		$password2	= "";
		$this->assign("email",$email);
		$this->assign("email2",$email2);
		$this->assign("zip",$zip);
		$this->assign("address1",$address1);
		$this->assign("address2",$address2);
		$this->assign("address3",$address3);
		$this->assign("introduce",$introduce);
		$this->assign("avater",$avater);
		$this->assign("valid",$valid);
		// 更新メッセージ
		$this->assign("update_msg",$update_msg);

		// SELECTボックスの既定値
		$group_list = $this->get_group_list();
		$this->assign("group_list",$group_list);

		// HELP表示
		$title = "ユーザーの更新";
		$text = '管理者がユーザーの情報を修正する場合に利用します。<br />
			<span class="attention_text">「*」</span>印付きの項目は必ず入力してください。<br />
			<span class="attention_text">「ユーザーの無効化」</span>チェックボックスにチェックを付けると、そのユーザーはログインできなくなります。<br />
			チェックをはずすとユーザーを復活させることがきます。<br />
			　（チェックを付けてもユーザーは削除されませんがログインができなくなります。）<br />
			最後に<span class="attention_text">「ユーザーの更新」</span>ボタンを押して修正内容を登録します。<br />
			注意！アカウント修正できません。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);


	}
	/**
	 * サイト設定変更
	 */
	public function page6(){

		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "サイト設定更新"){

				$this->err = false;

				if(trim($this->request['site_name']) == ""){
					$this->err = TRUE;
					$this->dialog_msg_add("サイト名が入力されていません。(初期値をセットします)");
				}
				if(trim($this->request['site_url']) == ""){
					$this->err = TRUE;
					$this->dialog_msg_add("サイトのURLが入力されていません。(初期値をセットします)");
				}
				if(trim($this->request['site_session']) == ""){
					$this->err = TRUE;
					$this->dialog_msg_add("サイトセッション名が入力されていません。(初期値をセットします)");
				}

				if(!$this->err){
					$a = file("./configuration.php");
					for($ix= 0 ; $ix < count($a); $ix++ ){
						if(mb_strpos($a[$ix],"define('_SITE_NAME', ")){
							$a[$ix] = "	define('_SITE_NAME', '".str_replace("'", "\'",$this->request['site_name'])."');\n";
						}
						if(mb_strpos($a[$ix],"define('_SITE_URL', ")){
							$a[$ix] = "	define('_SITE_URL', '".str_replace("'", "\'",$this->request['site_url'])."');\n";
						}
						if(mb_strpos($a[$ix],"define('_SESSION_NAME', ")){
							$a[$ix] = "	define('_SESSION_NAME', '".str_replace("'", "\'",$this->request['site_session'])."');\n";
						}
						if(mb_strpos($a[$ix],"define('_CHAR_TYPE', ")){
							$a[$ix] = "	define('_CHAR_TYPE', '".str_replace("'", "\'",$this->request['site_encode'])."');\n";
						}
					}
					if(is_writable('./configuration.php')){
						$fp = fopen('./configuration.php','w');
						foreach($a as $key=>$value){
							fwrite($fp, $value);
						}
						fclose($fp);

						$logout = new logout_class();
						$logout->logout();
						header("Location: index.php");
					} else {
						$update_msg .= "configuration.phpは保存できませんでした。書込権限を確認してください。 <br />"; 
						$this->err = TRUE;
						$this->dialog_msg_add("configuration.phpは保存できませんでした。");
					}
				}
			}
		}
		if(isset($this->request['site_name'])){
			$this->assign("site_name",$this->request['site_name']);
		}else{
			$this->assign("site_name",_SITE_NAME);
		}
		if(isset($this->request['site_url'])){
			$this->assign("site_url",$this->request['site_url']);
		}else{
			$this->assign("site_url",_SITE_URL);
		}
		if(isset($this->request['site_session'])){
			$this->assign("site_session",$this->request['site_session']);
		}else{
			$this->assign("site_session",_SESSION_NAME);
		}
		if(isset($this->request['site_encode'])){
			$this->assign("site_encode",$this->request['site_encode']);
		}else{
			$this->assign("site_encode",_CHAR_TYPE);
		}
		// HELP表示
		$title = "サイト設定";
		$text = 'このサイトの基本的な設定を行います。
			<span class="attention_text">サイト名</span>はこのサイトのタイトルです。
			<span class="attention_text">サイトURL</span>はこのサイトが設置されたアドレスを<br />「http://www.●●●.co.jp/」の形式で入力してください。<br />
			<span class="attention_text">セッション名</span>はPHPが内部で利用する変数です。CENOTEを1つのサーバで複数運用する場合はセッション名が重複しないように注意してください。<br />
			注意！<span class="attention_text">「サイト設定更新」</span>ボタンを押すとサイトの基本情報を読み直すため自動的にログアウトします。<br />
			メッセージは表示されませんが更新されていますので再度ログインして更新内容をご確認ください。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);
	}
	/**
	 * ユーザーメンテナンス画面
	 */
	public function page7(){
		include_once($this->request['edit'].".php");
		$ment = new $this->request['emod']($this->request);
		$edit = $ment->maintenance();
		
		$this->assign("edit",$edit);
		// HELP表示
		$title = "モジュールメンテナンス画面";
		$text = 'ユーザー作成のモジュールメンテナンス画面です。<br />
			操作方法は各モジュールのマニュアルに従ってください';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);
		$this->assign("prior",'index.php?mod='.$_SESSION['screen_module'].'&page='.$_SESSION['screen_page']);
	}
	/**
	 * エディット画面FCKEDITOR
	 */
	public function page8(){
		$update_msg = "";
		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "保存"){
				if(is_writable($_SESSION['screen'])){
					$fp = fopen($_SESSION['screen'],'w');
					fwrite($fp,$this->request['FCKeditor1']);
					fclose($fp);
				}
			}
		}
		$this->assign("edit_page",$_SESSION['screen']);
		// ファイルが書き込み可能か

		if(!is_writable($_SESSION['screen'])){
			$update_msg .= $_SESSION['screen']."は書き込み不可になっています。書込権限を設定してください。 <br />"; 
			$this->err = TRUE;
			$this->dialog_msg_add($_SESSION['screen']."は書き込み不可になっています。書込権限を設定してください。");
		}

		//ファイル読み込み
		$edit = "";
		$fp = fopen($_SESSION['screen'],'r');
		while ( !feof($fp) ) {
			$edit .=  fgets($fp, 9182);
		}


		$edit = str_replace("'","''",$edit);
		$edit = str_replace("\r\n", "", $edit);
		$edit = str_replace("\n", "", $edit);
		$edit = str_replace("\r", "", $edit);


		fclose($fp);
		$this->assign("edit",$edit);
		if(file_exists($_SESSION['screen_css'])){
			$this->assign("content_css",$_SESSION['screen_css']);
		}else{
			$this->assign("content_css",$_SESSION['screen_theme_css']);
		}
		$this->assign("edit",$edit);
		$this->assign("update_msg",$update_msg);
		$this->assign("prior",'index.php?mod='.$_SESSION['screen_module'].'&page='.$_SESSION['screen_page']);

		// HELP表示
		$title = "モジュールデザインエディタ";
		$text = '●画面のデザインを変更することが出来ます。<br />
				●画面の配置や色などはスタイルシートで設定されている場合もあります<br />
				<span class="attention_text">スタイルシートデザインも併せて修整する必要があるかもしれません。</span><br />
				●編集が終了したら画面下の<span class="attention_text">保存</span>ボタンを押して登録してください。「<span
					class="attention_text">元の画面に戻る</span>」ボタンを押すと
				修整後のデザインをすぐに確認することが出来ます。<br />
				●<span class="attention_text">書き込み不可になっている場合は</span><br />
				Windowsの場合：目的のファイルの上で右クリックし>>プロパティ>>読取り専用のチェックをはずす。<br />
				UNUX系の場合：目的のファイルのあるディレクトリに移動しコマンドで「chmod 666 [ファイル名]」と入力<br />
				サーバにアップロードしたファイルの場合はFTPソフトを利用して書込み権限を変更してください。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);

	}
	/**
	 * エディット画面
	 */
	public function page9(){
		$update_msg = "";
		if(isset($this->request['Submit'])){
			if($this->request['Submit'] == "保存"){
				if(is_writable($_SESSION['screen'])){
					$fp = fopen($_SESSION['screen'],'w');
					fwrite($fp,$this->request['cp']);
					fclose($fp);
				}
			}
		}
		$this->assign("edit_page",$_SESSION['screen']);
		// ファイルが書き込み可能か

		if(!is_writable($_SESSION['screen'])){
			$update_msg .= $_SESSION['screen']."は書き込み不可になっています。書込権限を設定してください。 <br />"; 
			$this->err = TRUE;
			$this->dialog_msg_add($_SESSION['screen']."は書き込み不可になっています。書込権限を設定してください。");
		} else {
			//ファイル読み込み
			$edit = "";
			$fp = fopen($_SESSION['screen'],'r');
			while ( !feof($fp) ) {
				$edit .=  fgets($fp, 9182);
			}
		}

		/*
		 $edit = str_replace("'","''",$edit);
		 $edit = str_replace("\r\n", "", $edit);
		 $edit = str_replace("\n", "", $edit);
		 $edit = str_replace("\r", "", $edit);
		 */

		fclose($fp);
		$this->assign("edit",$edit);
		if(file_exists($_SESSION['screen_css'])){
			$this->assign("content_css",$_SESSION['screen_css']);
		}else{
			$this->assign("content_css",$_SESSION['screen_theme_css']);
		}
		$this->assign("edit",$edit);
		$this->assign("update_msg",$update_msg);
		$this->assign("prior",'index.php?mod='.$_SESSION['screen_module'].'&page='.$_SESSION['screen_page']);

		// HELP表示
		$title = "モジュールデザインエディタ";
		$text = '●画面のデザインを変更することが出来ます。<br />
				●画面の配置や色などはスタイルシートで設定されている場合もあります<br />
				<span class="attention_text">スタイルシートデザインも併せて修整する必要があるかもしれません。</span><br />
				●編集が終了したら画面下の<span class="attention_text">保存</span>ボタンを押して登録してください。「<span
					class="attention_text">元の画面に戻る</span>」ボタンを押すと
				修整後のデザインをすぐに確認することが出来ます。<br />
				●<span class="attention_text">書き込み不可になっている場合は</span><br />
				Windowsの場合：目的のファイルの上で右クリックし>>プロパティ>>読取り専用のチェックをはずす。<br />
				UNUX系の場合：目的のファイルのあるディレクトリに移動しコマンドで「chmod 666 [ファイル名]」と入力<br />
				サーバにアップロードしたファイルの場合はFTPソフトを利用して書込み権限を変更してください。';
		$help = new help_class();
		$help_html = $help->get_help_html($title, $text);
		$this->assign("help",$help_html);

	}
	/**
	 * グループ情報取得
	 */
	public function get_group_list(){
		$db = new db_class();
		$sql = "SELECT cenote_group_name FROM cenote_group GROUP BY cenote_group_name";
		$result = $db->getData2($sql);
		foreach($result['cenote_group_name'] as $key => $value){
			$group_name[$key] = $value;
		}
		return $group_name;
	}
}