<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
/**
 * widget Class
 *
 * CMSの動作の中でをウィジットを制御するメインクラス
 * ウィジット情報を受け取り配列に格納、並び替えを受け持つ
 */


class widget {

	public $html;

	public function __construct($location,$mod){
		// widgetで利用するモジュールを配列で受け取る
		$this->html = "";
		if(isset($_SESSION['widget']['name'])){
			foreach($_SESSION['widget']['name'] as $key => $value){
				if($_SESSION['widget']['position'][$key] == $location){
					foreach($_SESSION['widget']['module'][$key] as $kay2 => $value2){
						if($value2 == $mod){
							try{
								if(file_exists('./widget/'.$value.'/'.$value.'.php')){
									include_once('./widget/'.$value."/".$value.".php");
								}else{
									$e_msg = 'ウィジット['.$value.']が見つかりません。';
									throw new Exception($e_msg);
								}
								if(class_exists($value)){
									$disp_widget = new $value;
								} else {
									$e_msg = 'ウィジット['.$value.']中に('.$value.')クラスが見つかりません';
									throw new Exception($e_msg);
								}
								if(method_exists($disp_widget,'display')){
									$this->html .= $disp_widget->display();
								}else{
									$e_msg = 'ウィジット['.$value.']中に(display)メゾッドが見つかりません';
									throw new Exception($e_msg);
								}
							}
							catch (Exception $e) {
								$this->html .= "エラー:".$e_msg;

							}

						}
					}
				}
			}
		}
	}
}