<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/**
 * モジュールのコントロールファイルを取得するクラス
 */
class get_module_xml_config{

	public function get_module(){

		$module = array();
		$dir = './modules/';
		$ix = 0;

		if( $handle = @opendir($dir) ){
			while( ($file = readdir( $handle)) !== false ){
				if(is_dir( $file )) continue;

				if(!file_exists("$dir$file/controll.xml")) continue;

				$parser=xml_parser_create();
				$data=file_get_contents("$dir$file/controll.xml");
				xml_parse_into_struct($parser,$data,$vals,$index);
				xml_parser_free($parser);
				
				//if($vals[$index['VALD'][0]]['value'] == "1"){

					$module['name'][$ix]			= $vals[$index['NAME'][0]]['value'];
					$module['api_name'][$ix]		= $vals[$index['API_NAME'][0]]['value'];
					$module['menu'][$ix]			= $vals[$index['MENU'][0]]['value'];
					$module['auther'][$ix]			= $vals[$index['AUTHER'][0]]['value'];
					$module['version'][$ix]			= $vals[$index['VERSION'][0]]['value'];
					$module['url'][$ix]				= $vals[$index['URL'][0]]['value'];
					$module['edit'][$ix]			= $vals[$index['EDIT'][0]]['value'];
					$module['maintenance'][$ix]		= $vals[$index['MAINTENANCE'][0]]['value'];
					$module['comment'][$ix]			= $vals[$index['COMMENT'][0]]['value'];
					$module['module_order'][$ix]	= $vals[$index['MODULE_ORDER'][0]]['value'];

					foreach($index['PAGE_TPL'] as $key => $val){
						$module['page_tpl'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['PAGE_NAME'] as $key => $val){
						$module['page_name'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['PAGE_ORDER'] as $key => $val){
						$module['page_order'][$ix][$key]   = $vals[$val]['value'];
					}
					foreach($index['TABLE'] as $key => $val){
						$module['table'][$ix][$key]  		 = $vals[$val]['value'];
					}
					$ix++;
				//}
			}
			closedir( $handle );
		}
		return $module;
	}
}