<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/*
   現在の日付を取得する
   引数：get_date('date')	  	戻り値： string "2007/09/25"
		 get_date('time')	  	戻り値： string "12:12:12"
		 get_date('datetime')  	戻り値： string "2007/09/25 12:12:12"
		 get_date('yyyy')  		戻り値： string "2007"
		 get_date('mm')  		戻り値： string "09"
		 get_date('dd')  		戻り値： string "25"

*/

class date_class {

	function get_date($str){
		$nowtime = time();

		switch($str){
			case "date":
				return(strftime('%Y/%m/%d',$nowtime));
				break;
			case "time":
				return(strftime('%H:%M:%S',$nowtime));
				break;
			case "datetime":
				return(strftime('%Y/%m/%d %H:%M:%S',$nowtime));
				break;
			case "yyyy":
				return(strftime('%Y',$nowtime));
				break;
			case "mm":
				return(strftime('%m',$nowtime));
				break;
			case "dd":
				return(strftime('%d',$nowtime));
				break;
			case "w":
				return(strftime('%w',$nowtime));
				break;
			default:
				return(strftime('%Y/%m/%d',$nowtime));

		}
	}
}
