<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

/* -------------------------------------------------------------------
   ライブラリの定義
------------------------------------------------------------------- */
// Smartyライブラリの読み込み
//require_once("Smarty/Smarty.class.php");
require_once("./extensions/Smarty/Smarty.class.php");
/* -------------------------------------------------------------------
   基本クラス　定義
------------------------------------------------------------------- */

class cenote_smarty{

	public $smarty;

	public $dialog_msg;
	public $err;
	public $msg_count;
	

	/* -------------------------------------------
	   コンストラクタ
	------------------------------------------- */
	protected function __construct(){
		
		// Smarty インスタンス化
		$this->smarty 	= 	new Smarty();

		// デリミター設定、ここでは、「<{」と「}>」を定義
		//$this->smarty->left_delimiter		= 	'<{';
		//$this->smarty->right_delimiter 	= 	'}>';

		// 環境変数設定　ディレクトリを定義
		$this->smarty->template_dir 		=	"./";
		$this->smarty->config_dir			=   "./";
		$this->smarty->compile_dir 			=	"./cenote/compile";
		$this->smarty->cache_dir 			=	"./cenote/cache";
		
		// 開発中のみTrueとして下さい
		$this->smarty->compile_check		=   true;
		$this->smarty->force_compile		=	true;

		// キャッシュ設定　0:cache off 1:cache on Type1 2:cache on Type2
		$this->smarty->cache_lifetime		=	0;
		$this->smarty->caching 				= 	false;

		// デバッグ設定
		if(_DBG){
			$this->smarty->debug_tpl		= 	_DBG_TPL;
			$this->smarty->debugging		= 	True;
			$this->smarty->debugging_ctrl	= 	True;
		} else {
			$this->smarty->debugging		= 	false;
			$this->smarty->debugging_ctrl	= 	false;
		}

	}
	// Webページの文字コードをパラメータで判断するため、ここで文字コード変換
	public function assign($item, $param){

		if(_CHAR_TYPE != "UTF-8"){
			switch (_CHAR_TYPE){
				case "EUC-JP";
					$chg = "EUC-JP";
					break;
				case "SHIFT-JIS":
					$chg = "SJIS";
					break;
			}
			if(is_array($param)){

				$res = array_walk($param,'param_encode');
				
			} else {
				$param = mb_convert_encoding($param,$chg,'UTF-8');
			}
		}

		$this->smarty->assign($item, $param);
	}
	
	// Webページの文字コードをパラメータで判断するため、ここで文字コード変換
	public function display($page){
			if(_CHAR_TYPE != "UTF-8"){
			switch (_CHAR_TYPE){
				case "EUC-JP";
					$chg = "EUC-JP";
					break;
				case "SHIFT-JIS":
					$chg = "SJIS";
					break;
			}
			$page = mb_convert_encoding($page,$chg,'UTF-8');
		}
		$this->smarty->display($page);
	}
	
	
	
	protected function __destruct(){
	}
	/**
	 * エラーメッセージ編集
	 */
	public function dialog_msg_add($str){

		$this->dialog_msg[$this->msg_count] = $str;
		$this->msg_count++;
	}
}


function param_encode(&$value, $key){
	if(is_array($value)){
		$res = array_walk($value,'param_encode');
	}else{
		$value = mb_convert_encoding($value,_CHAR_TYPE,'UTF-8');

	}
}
	
