/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id$
 */
#include <stdio.h>
#include <limits.h>
#include <ccunit/CCUnitAssert.h>

/** test case: assert macro test */

/**
 * assert fail.
 */
void test_assert_fail ()
{
  CCUNIT_ASSERT (1 == 0);
}

/**
 * assert eq int fail.
 */
void test_assertInt_equal ()
{
  CCUNIT_ASSERT_EQ_INT (INT_MAX, INT_MIN);
}

/**
 * assert !eq int fail
 */
void test_assertInt_notEqual ()
{
  CCUNIT_ASSERT_NE_INT (INT_MAX, INT_MAX);
}

/**
 * assert int compare fail
 */
void test_assertInt_comp_fail ()
{
  CCUNIT_ASSERT_GT_INT (INT_MIN, INT_MAX);
}

/**
 * assert str compare fail
 */
void test_assertStr_comp_fail ()
{
  CCUNIT_ASSERT_EQ_STR ("string", "STRING");
}

/** end test case */

/** test case: assert setUp() */

void setUp_setUp ()
{
  CCUNIT_ASSERT_EQ_STR ("setUp", "");
}

void tearDown_setUp ()
{
  CCUNIT_ASSERT (false);
}

/** not reached */
void test_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** end test case */

/** test case: assert tearDown() */

void tearDown_tearDown ()
{
  CCUNIT_ASSERT_EQ_STR ("tearDown", "");
}

/** be failed */
void test_tearUp ()
{
  CCUNIT_ASSERT(false);
}

/** end test case */

/** test case: assert in setup_setUp () */
void setup_setUp_test_setup_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** not reached */
void setUp_test_setup_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** not reached */
void tearDown_test_setup_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** not reached */
void test_test_setup_setUp ()
{
  CCUNIT_ASSERT(false);
}

void setup_tearDown_test_setup_setUp ()
{
  CCUNIT_ASSERT(false);
}

/** end test case */
