/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestFunc.c,v 1.1 2010/08/20 07:33:15 tsutsumi Exp $
 */
/**@file
 * TestFunc module implementation.
 */

#include <ccunit/CCUnitTestFunc.h>

/**
 * @addtogroup CCUnitTestFunc
 * @{
 */

CCUnitTestFunc* ccunit_newTestFunc (const char* name,
				    const char* desc,
				    void (*runTest)())
{
  CCUnitTestFunc* f = calloc (1, sizeof (*f));
  if (!f)
    return NULL;
  f->name = safe_strdup (name);
  f->desc = !desc ? safe_strdup (name) : strdup (desc);
  f->runTest = runTest;
  return f;
}

void ccunit_deleteTestFunc (CCUnitTestFunc* f)
{
  if (!f)
    return;
  safe_free (f->name);
  safe_free (f->desc);
  free (f);
}

/** @} */
