/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, see <http://www.gnu.org/licenses/>
*/

/*
 * $Id: testComplexArith.c,v 1.1 2010/08/20 07:18:43 tsutsumi Exp $
 */

#include <ccunit/CCUnitAssert.h>

/** TEST SUITE: complex arith test suite */

/** TEST CASE: complex arith test */

#include "complex.h"

static complex_t* c6_3;
static complex_t* c3_2;

void setUp_test_complex_arith ()
{
  c6_3 = complex_new (6, 3);
  c3_2 = complex_new (3, 2);
}
 
void tearDown_test_complex_arith ()
{
  complex_delete (c6_3);
  complex_delete (c3_2);
}

/** test add */
void test_complex_add ()
{
  complex_t ans = { 9, 5 };
  complex_t result;
  CCUNIT_ASSERT (complex_equals (&ans, complex_add (&result, c6_3, c3_2)));
}

/** test sub */
void test_complex_sub ()
{
  complex_t ans = { 3, 1 };
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (&ans, complex_equals,
			  complex_sub (&result, c6_3, c3_2),
			  complex_to_string);
}

/** test mul */
void test_complex_mul ()
{
  complex_t* ans = complex_new (6*3 - 3*2, 6*2 + 3*3);
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (ans, complex_equals,
			  complex_mul (&result, c6_3, c3_2),
			  complex_to_string);
  complex_delete (ans);
}

/** test div */
void test_complex_div ()
{
  const double r2 = 3*3 + 2*2;
  complex_t* ans = complex_new ((6*3 + 3*2)/r2, (3*3 - 6*2)/r2);
  complex_t result;
  CCUNIT_ASSERT_TEST_OBJ (ans, complex_equals,
			  complex_div (&result, c6_3, c3_2),
			  complex_to_string);
  complex_delete (ans);
}

/** end test case */
