/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;

public class LogViewer
extends Applet {
    private Panel mainPanel = new Panel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private LogChartPanel logChartPanel = null;
    private Panel menuPanel = new Panel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Choice itemType = new Choice();
    private FlowLayout flowLayout = new FlowLayout();
    private CheckboxGroup chartType = new CheckboxGroup();
    private Checkbox barChart = new Checkbox();
    private Checkbox circleChart = new Checkbox();
    private Checkbox lineChart = new Checkbox();
    private Button launch = new Button();
    private ScrollPane scrollPane = new ScrollPane(0);
    private boolean isLaunch = false;
    private FlyingFrame flyingFrame = null;
    private Dimension mainPanelDim = null;

    public void init() {
        URL uRL;
        try {
            uRL = new URL(this.getCodeBase(), this.getParameter("data"));
        }
        catch (Exception exception) {
            uRL = null;
            exception.printStackTrace();
        }
        this.logChartPanel = new LogChartPanel(uRL, this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logChartPanel.setViewItem(0);
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.borderLayout2);
        this.menuPanel.setLayout(this.flowLayout);
        int n = 0;
        while (n < Log.params()) {
            this.itemType.addItem(Log.getName(n));
            ++n;
        }
        this.itemType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LogViewer.this.itemType_itemStateChanged(itemEvent);
            }
        });
        this.barChart.setCheckboxGroup(this.chartType);
        this.barChart.setLabel("\u68d2\u30b0\u30e9\u30d5");
        this.barChart.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LogViewer.this.barChart_itemStateChanged(itemEvent);
            }
        });
        this.circleChart.setCheckboxGroup(this.chartType);
        this.circleChart.setLabel("\u5186\u30b0\u30e9\u30d5");
        this.circleChart.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LogViewer.this.circleChart_itemStateChanged(itemEvent);
            }
        });
        this.lineChart.setCheckboxGroup(this.chartType);
        this.lineChart.setLabel("\u6298\u308c\u7dda\u30b0\u30e9\u30d5");
        this.lineChart.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LogViewer.this.lineChart_itemStateChanged(itemEvent);
            }
        });
        this.launch.setLabel("\u30a6\u30a3\u30f3\u30c9\u30a6\u5316");
        this.launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogViewer.this.launch_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.mainPanel, "Center");
        this.menuPanel.setBackground(new Color(204, 204, 255));
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.add(this.logChartPanel);
        this.mainPanel.add((Component)this.menuPanel, "South");
        this.menuPanel.add((Component)this.itemType, null);
        this.menuPanel.add((Component)this.barChart, null);
        this.menuPanel.add((Component)this.circleChart, null);
        this.menuPanel.add((Component)this.lineChart, null);
        this.menuPanel.add((Component)this.launch, null);
    }

    public void setChartType(int n) {
        if (n == 0) {
            this.chartType.setSelectedCheckbox(this.barChart);
        } else if (n == 1) {
            this.chartType.setSelectedCheckbox(this.circleChart);
        } else if (n == 2) {
            this.chartType.setSelectedCheckbox(this.lineChart);
        }
    }

    public void land() {
        this.launch.setLabel("\u30a6\u30a3\u30f3\u30c9\u30a6\u5316");
        this.isLaunch = false;
        this.flyingFrame.dispose();
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setSize(this.mainPanelDim);
        this.validate();
    }

    void itemType_itemStateChanged(ItemEvent itemEvent) {
        this.logChartPanel.setViewItem(this.itemType.getSelectedIndex());
    }

    void barChart_itemStateChanged(ItemEvent itemEvent) {
        this.logChartPanel.setChartType(0);
    }

    void circleChart_itemStateChanged(ItemEvent itemEvent) {
        this.logChartPanel.setChartType(1);
    }

    void lineChart_itemStateChanged(ItemEvent itemEvent) {
        this.logChartPanel.setChartType(2);
    }

    void launch_actionPerformed(ActionEvent actionEvent) {
        if (this.isLaunch) {
            this.land();
        } else {
            this.mainPanelDim = this.mainPanel.getSize();
            this.launch.setLabel("\u975e\u30a6\u30a3\u30f3\u30c9\u30a6\u5316");
            this.flyingFrame = new FlyingFrame(this.mainPanel, this);
            this.isLaunch = true;
        }
    }
}

