#------------------------------------------------------------------------------
# MYK_CAPTCHA
#       Perl Routines for gif image generation of numbers for keyword
#       Author: Wajett Systems
#       Copyright (c) 2010-2011, Wajett Systems
#
#       This is free software and may be modified and/or
#       redistributed under the same terms as Perl itself.
# $Id: myk_captcha.pl,v 1.10 2011/03/13 00:00:00 WATANABE.S Exp $
#------------------------------------------------------------------------------
package MYK_CAPTCHA;

#use strict;


# GIF image (hexadecimal)
my %gif_data = (
	'0' => "0A00100000042810C8492539F8907933DEC067611239996679A814BA9E6F1AC62F3BB734AE82DDE8691C0FA852890000",
	'1' => "0A00100000041E10C849E939558E9BC3C5D507665C0694E418AA163BA1AB79BA225CBB590400",
	'2' => "0A00100000042910C8492539F8907933DEC06761123999D580521748A94755C6B2986A724857D8507B9919709703440000",
	'3' => "0A00100000042810C8492539F8907933DEC06761162891D579A440C779DAEB9994CBA2048D8A2D0EC7A30C8D05880000",
	'4' => "0A00100000042710C8492B38C75E6C05CE5470181C351C4439712A70121B95C26DA9CE92FAED20FF692D4A50130100",
	'5' => "0A00100000042510C849C1B9F8CA9CF7A993065ADF781126874A0477AC555B82220193DE2AB32E2C9FA34A0400", 
	'6' => "0A00100000042910C8492539F8907933DEC0376112C98166151E6AE969E30BAF60E75266BABAB5D97920C06FD69A440000",
	'7' => "0A00100000042310C849C1B9F81099333FD42511DB245600A1A116C89E955A5630EDC6B5B9A2B9CEB21100",
	'8' => "0A00100000042910C8492539F8907933DEC067611239996679A860377ADAEB8122E086EB99A7B84A999D19475829460000",
	'9' => "0A00100000042810C8492539F8907933DEC067611239996679A860377A69E755E74A873601AAECFB7A3B99E656890000",
	);

#number length
my $num_length = 4;

# real size of the gif image
my $gif_w = 10;
my $gif_h = 16;



sub print_gif {
	my ($len, $key_num) = @_;

	our $num_length = $len;

	# generate
    print "Content-type: image/gif\n";
    print "\n";
    binmode(STDOUT);

	print &get_header($gif_w, $gif_h, $num_length);
	print &get_body($key_num, $gif_w, $num_length);
	print "\x3B";	#terminater

	exit;
}


sub get_header {
	my ($width, $height, $num_len) = @_;


	# format
    my $head = "GIF89a";                  
    
    # width
    $head .= pack( "C2", $width * $num_len % 256, ( $width * $num_len/ 256 ) % 256 );
    # height
	$head .= pack( "C2", $height % 256, ( $height / 256 ) % 256 );

    $head .= "\xB3";	# 
    $head .= "\x00";    #back ground index
    $head .= "\x00";    #aspect ratio

    #16 colors pallete
    
    #
    #srand(time);
    my $rand = int( rand(3) ) + 1;
    $head .= &make_pallete($rand);
 
    
#    $head .= "\x00\x66\x00";
#    $head .= "\x2C\x2C\x2C";	
#    $head .= "\x4B\x4B\x4B";
#    $head .= "\x69\x69\x69";
#    $head .= "\xA5\xA5\xA5";
#    $head .= "\xC0\xC0\xC0";
#    $head .= "\xE1\xE1\xE1";
#    $head .= "\xFF\xFF\xFF";
#    #
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";
#	$head .= "\x00\x00\x00";

	return $head;

}



sub get_body {
	my ($key_num, $step, $num_len) = @_;
	
	#
	my $ptn = "%0" . $num_len . "d";
	
    my $strNum = sprintf($ptn, $key_num);
    
    #
    my $top = 0;
    my $left = 0;
	#my $step = $gif_w;
	my $body = '';

    foreach ( split(//, $strNum) ) {
    	
    	##Graphic Control Extension
    	#Fixedicontains Transparent Color Flagj
        $body .= "\x21";   
        $body .= "\xF9";   
		$body .= "\x04"; 
		$body .= "\x00\x00\x00\x00"; 
		$body .= "\x00";
		

		##Comment Extension
		$body .= "\x2C";
		
        #Widthinowj
		$body .= pack( "C2", $left % 256, ( $left / 256 ) % 256 );

		#Height
		$body .= pack( "C2", 256, 256);

		#Image Data
		my $img =  $gif_data{$_};
		$body .= pack("H*", $img);

        #Shift the left position
        $left += $step;

    }
    
    return $body;

}


#
sub make_pallete {
	my ($rand) = @_;

	my $plt = '';

	if ( $rand == 1 ) {
		
		$plt .= "\xFF\xFF\xFF";
		$plt .= "\xD1\xD1\xD1";
		$plt .= "\xC0\xCC\xC0";
		$plt .= "\xA5\xA5\xA5";
		$plt .= "\x88\x88\x88";
		$plt .= "\x77\x77\x77";
		$plt .= "\x55\x55\x55";	
	    $plt .= "\x33\x33\x33";

	} elsif (  $rand == 2 ) {
		
	    $plt .= "\x88\x88\x88";
	    $plt .= "\x99\x99\x99";	
	    $plt .= "\x77\x77\x77";
	    $plt .= "\x69\x69\x69";
	    $plt .= "\x55\x55\x55";
	    $plt .= "\x44\x44\x44";
	    $plt .= "\x33\x33\x33";
	    $plt .= "\x22\x22\x22";
	    
	} else {

	    $plt .= "\x3C\x3C\x3C";
	    $plt .= "\x49\x49\x49";	
	    $plt .= "\x56\x56\x56";
	    $plt .= "\x69\x69\x69";
	    $plt .= "\xA5\xA5\xA5";
	    $plt .= "\xC0\xC0\xC0";
	    $plt .= "\xE1\xE1\xE1";
	    $plt .= "\xFF\xFF\xFF";		
		
	}	

	#	
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	$plt .= "\x00\x00\x00";
	
	return $plt;
	
}


1;
