/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.image;

import java.io.InputStream;
import javafx.scene.image.Image;

public class ImageUtil {
    public static Image getImage(String url) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(url);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(String url, boolean backgroundLoading) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(url, backgroundLoading);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(String url, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(url, requestedWidth, requestedHeight, preserveRatio, smooth);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(String url, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth, boolean backgroundLoading) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(url, requestedWidth, requestedHeight, preserveRatio, smooth, backgroundLoading);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static Image getImage(InputStream is) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(is);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(InputStream is, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth, boolean backgroundLoading) {
        boolean isContextClassLoaderReplaced = false;
        try {
            isContextClassLoaderReplaced = ImageUtil.setContextClassLoaderIfNeeded();
            Image image = new Image(is, requestedWidth, requestedHeight, preserveRatio, smooth);
            return image;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    private static boolean setContextClassLoaderIfNeeded() {
        ClassLoader systemClassLoader;
        if (Thread.currentThread().getContextClassLoader() == null && (systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
            Thread.currentThread().setContextClassLoader(systemClassLoader);
            return true;
        }
        return false;
    }
}

