/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control;

import java.awt.Toolkit;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.InputMethodRequests;
import javafx.stage.Screen;

public class HiDpiFixedInputMethodRequests
implements InputMethodRequests {
    private static Boolean isWindows = null;
    private static Double scale = null;
    private InputMethodRequests inputMethodRequests;

    public static void fix(TextInputControl control) {
        if (control == null) {
            return;
        }
        if (!HiDpiFixedInputMethodRequests.isWindows()) {
            return;
        }
        control.inputMethodRequestsProperty().addListener((observable, oldValue, newValue) -> {
            InputMethodRequests inputMethodRequest;
            if (newValue != null && (inputMethodRequest = control.getInputMethodRequests()) != null && !(inputMethodRequest instanceof HiDpiFixedInputMethodRequests)) {
                control.setInputMethodRequests((InputMethodRequests)new HiDpiFixedInputMethodRequests(inputMethodRequest));
            }
        });
    }

    private static boolean isWindows() {
        if (isWindows == null) {
            String osName = System.getProperty("os.name", "").toLowerCase();
            isWindows = osName.startsWith("windows");
        }
        return isWindows;
    }

    private static double getScale() {
        if (scale == null) {
            if (HiDpiFixedInputMethodRequests.isWindows()) {
                String uiScale = System.getProperty("glass.win.uiScale");
                if (uiScale != null) {
                    try {
                        if (uiScale.endsWith("%")) {
                            uiScale = uiScale.substring(0, uiScale.length() - 1);
                            scale = (double)Integer.parseInt(uiScale) / 100.0;
                        } else {
                            scale = Double.parseDouble(uiScale);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (scale == null) {
                    scale = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
                }
            }
            if (scale == null) {
                scale = 1.0;
            }
        }
        return scale;
    }

    public HiDpiFixedInputMethodRequests(InputMethodRequests inputMethodRequests) {
        this.inputMethodRequests = inputMethodRequests;
    }

    public Point2D getTextLocation(int offset) {
        Point2D textLocation = this.inputMethodRequests.getTextLocation(offset);
        double x = textLocation.getX();
        double y = textLocation.getY();
        Screen screen = null;
        ObservableList screens = Screen.getScreensForRectangle((double)x, (double)y, (double)1.0, (double)1.0);
        screen = screens.size() >= 1 ? (Screen)screens.get(0) : Screen.getPrimary();
        double diff = screen.getBounds().getMaxY() - y;
        if (diff <= 248.0) {
            y = diff < 233.0 ? (y -= 15.0) : (y -= 248.0 - diff);
        }
        textLocation = new Point2D(x, y);
        return textLocation.multiply(HiDpiFixedInputMethodRequests.getScale());
    }

    public int getLocationOffset(int x, int y) {
        return (int)((double)this.inputMethodRequests.getLocationOffset(x, y) * HiDpiFixedInputMethodRequests.getScale());
    }

    public void cancelLatestCommittedText() {
        this.inputMethodRequests.cancelLatestCommittedText();
    }

    public String getSelectedText() {
        return this.inputMethodRequests.getSelectedText();
    }
}

