/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.osdn.util.javafx.scene.control.Dialogs;

public class DialogEx<R>
extends Dialog<R> {
    public DialogEx(final Window owner) {
        if (owner instanceof Stage) {
            Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
            ObservableList icons = ((Stage)owner).getIcons();
            if (icons != null && icons.size() > 0) {
                stage.getIcons().add((Object)((Image)icons.get(0)));
            }
            stage.setTitle(((Stage)owner).getTitle());
        }
        if (owner != null) {
            this.getDialogPane().layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                    if (newValue != null && newValue.getWidth() > 0.0 && newValue.getHeight() > 0.0) {
                        double x = owner.getX() + owner.getWidth() / 2.0;
                        double y = owner.getY() + owner.getHeight() / 2.0;
                        DialogEx.this.setX(x - newValue.getWidth() / 2.0);
                        DialogEx.this.setY(y - newValue.getHeight() / 2.0);
                        DialogEx.this.getDialogPane().layoutBoundsProperty().removeListener((ChangeListener)this);
                    }
                }
            });
        }
        this.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    DialogPane dialogPane = DialogEx.this.getDialogPane();
                    for (ButtonType buttonType : dialogPane.getButtonTypes()) {
                        String text = Dialogs.buttonTexts.get(buttonType);
                        if (text == null) continue;
                        Button button = (Button)dialogPane.lookupButton(buttonType);
                        button.setText(text);
                    }
                }
                DialogEx.this.showingProperty().removeListener((ChangeListener)this);
            }
        });
        this.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    Rectangle2D workarea = Screen.getPrimary().getVisualBounds();
                    double x = DialogEx.this.getX();
                    double y = DialogEx.this.getY();
                    if (owner != null) {
                        x = owner.getX() + owner.getWidth() / 2.0 - DialogEx.this.getWidth() / 2.0;
                        y = owner.getY() + owner.getHeight() / 2.0 - DialogEx.this.getHeight() / 2.0;
                    }
                    double w = DialogEx.this.getWidth();
                    double h = DialogEx.this.getHeight();
                    if (x + w > workarea.getMaxX()) {
                        x = workarea.getMaxX() - w;
                    }
                    if (x < workarea.getMinX()) {
                        x = workarea.getMinX();
                    }
                    if (x + w > workarea.getMaxX()) {
                        w = workarea.getMaxX() - x;
                    }
                    if (y + h > workarea.getMaxY()) {
                        y = workarea.getMaxY() - h;
                    }
                    if (y < workarea.getMinY()) {
                        y = workarea.getMinY();
                    }
                    if (y + h > workarea.getMaxY()) {
                        h = workarea.getMaxY() - y;
                    }
                    if (x != DialogEx.this.getX()) {
                        DialogEx.this.setX(x);
                    }
                    if (y != DialogEx.this.getY()) {
                        DialogEx.this.setY(y);
                    }
                    if (w != DialogEx.this.getWidth()) {
                        DialogEx.this.setWidth(w);
                    }
                    if (h != DialogEx.this.getHeight()) {
                        DialogEx.this.setHeight(h);
                    }
                }
            }
        });
    }

    public void sizeToScene() {
        DialogPane dialogPane = this.getDialogPane();
        if (dialogPane == null) {
            return;
        }
        Scene scene = dialogPane.getScene();
        if (scene == null) {
            return;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return;
        }
        window.sizeToScene();
    }
}

