/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.concurrent;

import java.util.concurrent.Callable;
import javafx.concurrent.Task;
import net.osdn.util.javafx.Unchecked;

public class AsyncTask<V>
extends Task<V> {
    private Callable<V> callable;
    private Cancel cancel;
    private Success<V> success;
    private Fail fail;
    private Finish finish;

    public static AsyncTask<Void> create(final Unchecked.Runnable runnable) {
        return new AsyncTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static <V> AsyncTask<V> create(Callable<V> callable) {
        return new AsyncTask<V>(callable);
    }

    public AsyncTask(Callable<V> callable) {
        this.callable = callable;
    }

    public AsyncTask<V> onSucceeded(Success<V> callback) {
        this.success = callback;
        return this;
    }

    public AsyncTask<V> onCancelled(Cancel callback) {
        this.cancel = callback;
        return this;
    }

    public AsyncTask<V> onFailed(Fail callback) {
        this.fail = callback;
        return this;
    }

    public AsyncTask<V> onFinished(Finish callback) {
        this.finish = callback;
        return this;
    }

    protected V call() throws Exception {
        return this.callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void succeeded() {
        Throwable exception = null;
        try {
            if (this.success != null) {
                this.success.onSucceeded(this.getValue());
            }
        }
        catch (Throwable e) {
            exception = e;
        }
        finally {
            block17: {
                if (this.finish != null) {
                    try {
                        this.finish.onFinished(State.SUCCEEDED);
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                Thread thread = Thread.currentThread();
                Thread.UncaughtExceptionHandler ueh = thread.getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(thread, exception);
                } else {
                    AsyncTask.rethrow(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelled() {
        Throwable exception = null;
        try {
            if (this.cancel != null) {
                this.cancel.onCancelled();
            }
        }
        catch (Throwable e) {
            exception = e;
        }
        finally {
            block17: {
                if (this.finish != null) {
                    try {
                        this.finish.onFinished(State.CANCELLED);
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                Thread thread = Thread.currentThread();
                Thread.UncaughtExceptionHandler ueh = thread.getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(thread, exception);
                } else {
                    AsyncTask.rethrow(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed() {
        Throwable exception = null;
        try {
            if (this.fail != null) {
                this.fail.onFailed(this.getException());
            } else {
                exception = this.getException();
            }
        }
        catch (Throwable e) {
            exception = e;
        }
        finally {
            block18: {
                if (this.finish != null) {
                    try {
                        this.finish.onFinished(State.FAILED);
                    }
                    catch (Throwable e) {
                        if (exception != null) break block18;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                Thread thread = Thread.currentThread();
                Thread.UncaughtExceptionHandler ueh = thread.getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(thread, exception);
                } else {
                    AsyncTask.rethrow(exception);
                }
            }
        }
    }

    private static <T extends Throwable> void rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    @FunctionalInterface
    public static interface Finish {
        public void onFinished(State var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Fail {
        public void onFailed(Throwable var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Cancel {
        public void onCancelled() throws Exception;
    }

    @FunctionalInterface
    public static interface Success<V> {
        public void onSucceeded(V var1) throws Exception;
    }

    public static enum State {
        CANCELLED,
        SUCCEEDED,
        FAILED;

    }
}

