/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class RelativeFilenameUtils {
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char OTHER_SEPARATOR = SYSTEM_SEPARATOR == '\\' ? (char)47 : (char)92;

    public static String normalizeNoEndSeparator(String filename) {
        return RelativeFilenameUtils.doNormalize(filename, SYSTEM_SEPARATOR, false);
    }

    private static String doNormalize(String filename, char separator, boolean keepSeparator) {
        int i;
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = FilenameUtils.getPrefixLength((String)filename);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != otherSeparator) continue;
            array[i2] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            array[size++] = separator;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != separator) continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (!RelativeFilenameUtils.isEndOfClimbUp(array, i, separator) || i != prefix + 2 && array[i - 3] != separator || i == prefix + 2) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            if (RelativeFilenameUtils.isEndOfClimbUp(array, i - 3, separator)) continue;
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    private static boolean isEndOfClimbUp(char[] array, int position, char separator) {
        return array[position] == separator && array[position - 1] == '.' && array[position - 2] == '.';
    }
}

