/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.core;

import com.codewaves.codehighlight.core.Keyword;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Mode {
    boolean self;
    boolean compiled;
    HashMap<String, Keyword> compiledKeywords;
    Pattern beginRe;
    Pattern endRe;
    Pattern lexemesRe;
    Pattern illegalRe;
    String subLanguage;
    String[] subLanguages;
    Mode starts;
    Mode[] contains;
    Mode[] variants;
    Keyword[] beginKeywords;
    Keyword[] keywords;
    String className;
    String begin;
    String end;
    String lexemes;
    Pattern terminators;
    String illegal;
    String terminatorEnd;
    int relevance = -1;
    boolean skip;
    boolean returnBegin;
    boolean excludeBegin;
    boolean returnEnd;
    boolean excludeEnd;
    boolean endsWithParent;
    boolean endsParent;
    public static final Mode SELF = new Mode().self();
    public static final String IDENT_RE = "[a-zA-Z]\\w*";
    public static final String UNDERSCORE_IDENT_RE = "[a-zA-Z_]\\w*";
    public static final String NUMBER_RE = "\\b\\d+(\\.\\d+)?";
    public static final String C_NUMBER_RE = "(-?)(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)";
    public static final String BINARY_NUMBER_RE = "\\b(0b[01]+)";
    public static final String RE_STARTERS_RE = "!|!=|!==|%|%=|&|&&|&=|\\*|\\*=|\\+|\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\?|\\[|\\{|\\(|\\^|\\^=|\\||\\|=|\\|\\||~";
    public static final Mode BACKSLASH_ESCAPE = new Mode().begin("\\\\[\\s\\S]").relevance(0);
    public static final Mode APOS_STRING_MODE = new Mode().className("string").begin("'").end("'").illegal("\\n").contains(new Mode[]{BACKSLASH_ESCAPE});
    public static final Mode QUOTE_STRING_MODE = new Mode().className("string").begin("\"").end("\"").illegal("\\n").contains(new Mode[]{BACKSLASH_ESCAPE});
    public static final Mode PHRASAL_WORDS_MODE = new Mode().begin("\\b(a|an|the|are|I'm|isn't|don't|doesn't|won't|but|just|should|pretty|simply|enough|gonna|going|wtf|so|such|will|you|your|they|like|more)\\b");
    public static final Mode C_LINE_COMMENT_MODE = Mode.COMMENT("//", "$", null);
    public static final Mode C_BLOCK_COMMENT_MODE = Mode.COMMENT("/\\*", "\\*/", null);
    public static final Mode HASH_COMMENT_MODE = Mode.COMMENT("#", "$", null);
    public static final Mode NUMBER_MODE = new Mode().className("number").begin("\\b\\d+(\\.\\d+)?").relevance(0);
    public static final Mode C_NUMBER_MODE = new Mode().className("number").begin("(-?)(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)").relevance(0);
    public static final Mode BINARY_NUMBER_MODE = new Mode().className("number").begin("\\b(0b[01]+)").relevance(0);
    public static final Mode TITLE_MODE = new Mode().className("title").begin("[a-zA-Z]\\w*").relevance(0);
    public static final Mode UNDERSCORE_TITLE_MODE = new Mode().className("title").begin("[a-zA-Z_]\\w*").relevance(0);
    public static final Mode METHOD_GUARD = new Mode().begin("\\.\\s*[a-zA-Z_]\\w*").relevance(0);
    public static final Mode CSS_NUMBER_MODE = new Mode().className("number").begin("\\b\\d+(\\.\\d+)?(%|em|ex|ch|rem|vw|vh|vmin|vmax|cm|mm|in|pt|pc|px|deg|grad|rad|turn|s|ms|Hz|kHz|dpi|dpcm|dppx)?").relevance(0);
    public static final Mode REGEXP_MODE = new Mode().className("regexp").begin("\\/").end("\\/[gimuy]*").illegal("\\n").contains(new Mode[]{BACKSLASH_ESCAPE, new Mode().begin("\\[").end("\\]").relevance(0).contains(new Mode[]{BACKSLASH_ESCAPE})});

    public static Mode COMMENT(String string, String string2, Mode mode) {
        Mode mode2 = new Mode().className("comment").begin(string).end(string2).contains(new Mode[0]);
        if (mode != null) {
            mode2 = Mode.inherit(mode2, mode);
        }
        mode2.contains = Mode.mergeModes(mode2.contains, new Mode[]{PHRASAL_WORDS_MODE, new Mode().className("doctag").begin("(?:TODO|FIXME|NOTE|BUG|XXX):").relevance(0)});
        return mode2;
    }

    public static Mode[] mergeModes(Mode[] modeArray, Mode[] modeArray2) {
        Mode[] modeArray3 = new Mode[modeArray.length + modeArray2.length];
        System.arraycopy(modeArray, 0, modeArray3, 0, modeArray.length);
        System.arraycopy(modeArray2, 0, modeArray3, modeArray.length, modeArray2.length);
        return modeArray3;
    }

    public Mode(Mode mode) {
        this.compiled = mode.compiled;
        this.compiledKeywords = mode.compiledKeywords;
        this.subLanguage = mode.subLanguage;
        this.subLanguages = mode.subLanguages;
        this.starts = mode.starts;
        this.contains = mode.contains;
        this.variants = mode.variants;
        this.beginKeywords = mode.beginKeywords;
        this.keywords = mode.keywords;
        this.className = mode.className;
        this.begin = mode.begin;
        this.end = mode.end;
        this.lexemes = mode.lexemes;
        this.terminators = mode.terminators;
        this.illegal = mode.illegal;
        this.terminatorEnd = mode.terminatorEnd;
        this.relevance = mode.relevance;
        this.skip = mode.skip;
        this.returnBegin = mode.returnBegin;
        this.excludeBegin = mode.excludeBegin;
        this.returnEnd = mode.returnEnd;
        this.excludeEnd = mode.excludeEnd;
        this.endsWithParent = mode.endsWithParent;
        this.endsParent = mode.endsParent;
    }

    public static Mode inherit(Mode mode, Mode mode2) {
        Mode mode3 = new Mode(mode);
        if (mode2 != null) {
            if (mode2.starts != null) {
                mode3.starts = mode2.starts;
            }
            if (mode2.contains != null) {
                mode3.contains = mode2.contains;
            }
            if (mode2.variants != null) {
                mode3.variants = mode2.variants;
            }
            if (mode2.className != null) {
                mode3.className = mode2.className;
            }
            if (mode2.keywords != null) {
                mode3.keywords = mode2.keywords;
            }
            if (mode2.beginKeywords != null) {
                mode3.beginKeywords = mode2.beginKeywords;
            }
            if (mode2.begin != null) {
                mode3.begin = mode2.begin;
            }
            if (mode2.end != null) {
                mode3.end = mode2.end;
            }
            if (mode2.illegal != null) {
                mode3.illegal = mode2.illegal;
            }
            if (mode2.relevance != -1) {
                mode3.relevance = mode2.relevance;
            }
            if (mode2.returnBegin) {
                mode3.returnBegin = true;
            }
            if (mode2.excludeBegin) {
                mode3.excludeBegin = true;
            }
            if (mode2.returnEnd) {
                mode3.returnEnd = true;
            }
            if (mode2.excludeEnd) {
                mode3.excludeEnd = true;
            }
            if (mode2.endsWithParent) {
                mode3.endsWithParent = true;
            }
            if (mode2.endsParent) {
                mode3.endsParent = true;
            }
        }
        return mode3;
    }

    public Mode() {
    }

    public Mode[] getContains() {
        return this.contains;
    }

    public Mode subLanguages(String[] stringArray) {
        this.subLanguages = stringArray;
        return this;
    }

    public Mode subLanguage(String string) {
        this.subLanguage = string;
        return this;
    }

    public Mode self() {
        this.self = true;
        return this;
    }

    public Mode className(String string) {
        this.className = string;
        return this;
    }

    public Mode starts(Mode mode) {
        this.starts = mode;
        return this;
    }

    public Mode contains(Mode[] modeArray) {
        this.contains = modeArray;
        return this;
    }

    public Mode variants(Mode[] modeArray) {
        this.variants = modeArray;
        return this;
    }

    public Mode beginKeywords(Keyword[] keywordArray) {
        this.beginKeywords = keywordArray;
        return this;
    }

    public Mode keywords(Keyword[] keywordArray) {
        this.keywords = keywordArray;
        return this;
    }

    public Mode begin(String string) {
        this.begin = string;
        return this;
    }

    public Mode end(String string) {
        this.end = string;
        return this;
    }

    public Mode illegal(String string) {
        this.illegal = string;
        return this;
    }

    public Mode lexemes(String string) {
        this.lexemes = string;
        return this;
    }

    public Mode relevance(int n) {
        this.relevance = n;
        return this;
    }

    public Mode skip() {
        this.skip = true;
        return this;
    }

    public Mode returnBegin() {
        this.returnBegin = true;
        return this;
    }

    public Mode excludeBegin() {
        this.excludeBegin = true;
        return this;
    }

    public Mode returnEnd() {
        this.returnEnd = true;
        return this;
    }

    public Mode excludeEnd() {
        this.excludeEnd = true;
        return this;
    }

    public Mode endsWithParent() {
        this.endsWithParent = true;
        return this;
    }

    public Mode endsParent() {
        this.endsParent = true;
        return this;
    }
}

