# バージョン 0.9 への移行

このページでは、従来のテンプレートを 0.9 用に書き換えるための方法を解説します。

## 四分アキの改善

日本語組版に対応しているのがCatalpaの特徴の1つですが、0.8.9 以前のバージョンには Chrome で四分アキが少し大きくなってしまう問題がありました。従来の Catalpa では四分アキを実現するために `font-size:50%` を使用していました。たとえば、本文フォントサイズが 16px のときにフォントサイズ 8px でスペースを入れることで四分アキを作っていました。ですが、Chrome には最小フォントサイズ制限があり、いくら小さいフォントサイズを指定しても 10px で描画されてしまうという仕様があります。この仕様のため、Chrome では四分アキがやや広く表示されてしまっていました。

Chrome でも正確な四分アキ量を実現するために Catalpa フォントを作成しました。このフォントは半角スペースのグリフ1つしか持っていないのでとても小さいです。以下のように CSS にインラインで埋め込むことを想定しています。

```css Catalpa フォント {.copy .scroll}
@font-face { 
	font-family: "catalpa"; /* 二分アキ・四分アキを正確に実現するためのカスタムフォントです。*/
	src: url("data:application/font-woff;base64,d09GMgABAAAAAAJwAA4AAAAABfQAAAIbAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP0ZGVE0cGhwGYACCQggEEQgKWHYLCgABNgIkAxAEIAWEAQcqGxAFAB6FcZsTTmVyqvCdLvV4+H7u89yb95KUecGzLBBYIGEqV8ii3BqDao1oNaH+sq6d2MP9vGUCPVx0WPOvXLQNfESb6WADTjVPIPfF/r+bfIvwA/hdc2kgC3BswkgDKyxKqJfQEQUkgVAQ7tpnnsII9/CgJNuEgO/nRgA/ur2Ll/+DAKy0kR2JQKCkeK5S5+sLYrc8tPngQUYh1WUAAgAuPRjzeBtDXTu0lup1QABgjAUNGuxkAfvYBHayGwNFERgbhvB7ZvgjgGgJQCQSABA0klsdqxEQwyBBAT0SPVYDCqZYgVJWLKx53Ql4Vh7juD7Gcf2Li+8Xp4A3YXrfrytGc2/a+nXf2yaN5nybJlyzt10b/5SEzBYEz/6392ao9bdf0VtnX+IY5L26Bb0EQb0OlhLkPRYAQEmOAYmEQNFLkAiBQzIAVnspAGMGLCB0HrKA1HkkQGPSX4CiizUCVCtimgW0ujjLJsoyHAIbwmp3UbIFaJzwgWK1AarNseUtWqtjr6GDo5czhUR2RWI4caQgp6AghczMrWwt9e31kZWXA3j3mXDxn7Acm81X22V/36crrwNwF+OKoTtiwPu5PUcGuEIgudExzvCUWRU44cB0LctwJhGQgowc0kBj6vXdgpq0qjS4g9uYPF85SwLNZXLUoLmFVRRq6WqadiYfulGeXSg8Kckz+DhSLZvN5ND/fALDPBEEAICyFwIA") format("woff2");
}
```

テンプレートの `${r"<@markdown>"}` ディレクティブに `use_catalpa_font=true` を指定することでアキ量の指定に Catalpa フォントが使われるようになります。

```html 例 {.scroll}
${r'<@markdown use_catalpa_font=true>${content!}</@}markdown>'}
```

バージョン 0.9 同梱のサンプルでは <tt>markdown.css</tt> で `@font-face` を指定しています。参考にしてください。


## 青空文庫ルビ記法

青空文庫のルビ記法に対応しました。

  * ルビの付く文字列のあとに《》でくくって入力します。
  * ルビの付く文字列が漢字のみで構成されている場合は範囲を自動認識します。
  * ルビの付く文字列がはじまる前に｜を入れることで範囲を明確に指定できます。

テンプレートの `${r"<@markdown>"}` ディレクティブに `use_ruby=true` を指定することで青空文庫のルビ記法が処理されるようになります。

```html 例 {.scroll}
${r'<@markdown use_ruby=true>${content!}</@}markdown>'}
```

以下のCSSと組み合わせるのがおすすめです。（このCSSはバージョン0.9のサンプルに含まれている <tt>markdown.css</tt>に定義されています。）

```css ルビ表示調整用 CSS {.copy .scroll}
.markdown ruby[data-rt] {
	position: relative;
}
.markdown ruby[data-rt]::before {
	content: attr(data-rt);
	position: absolute;
	top: -0.75em;
	left: -2em;
	right: -2em;
	font-size: 0.5em;
	text-align: center;
	line-height: 1;
	color: #666;
}
.markdown ruby[data-rt] rt {
	display: none;
}
```

## CSS 埋め込み

バージョン 0.9 同梱のサンプルでは HTML に CSS を埋め込むようにしました。
これにより、ページ表示時の通信回数が減り高速化されます。

<#noparse>
```html 従来のCSS指定
<!DOCTYPE html>
<html lang="ja">
<head>
	<link rel="stylesheet" href="${baseurl}css/main.css">
</head>
```
</#noparse>

<#noparse>
```html HTMLにCSSを埋め込む指定
<!DOCTYPE html>
<html lang="ja">
<head>
	<style>
		<#include "css/main.css">
	</style>
</head>
```
</#noparse>

`${r"<#include>"}` ディレクティブは FreeMarker テンプレートエンジンの構文です。
このように記述することで、Catalpa が HTML を出力するときに CSS ファイルの内容が `<style>` タグ内に展開されます。

従来のテンプレートを使用している場合も、上記のように CSS の指定方法を書き換えることで対応できます。

なお、この FreeMarker テンプレートエンジンの構文を使って CSS を埋め込む方法は、Catalpa バージョン 0.8.9 以前でも使用できます。
