---
hide: header
---

#--head--

<link rel="preload" as="image" href="img/catalpa-main-visual.webp">

#--header--
<div style="
	display: flex;
	justify-content: center;
	align-items: center;
	text-align: center;
	height: 300px">
	<img src="img/catalpa-main-visual.webp" style="
		position: absolute;
		top: 0;
		left: 0;
		z-index: -1;
		height: 300px;
		width: 100%;
		object-fit: cover;">
	<img src="img/catalpa-logo.svg" style="
		width: 400px;
		height: 224px;
		filter: drop-shadow(0px 0px 2px black) drop-shadow(2px 4px 6px rgba(0,0,0,0.5))">
</div>

<div class="content" style="
	margin-block-start:-3.5em;
	height:3.5em;
	display:flex">
	<form class="search" method="GET" action="${baseurl}search.html?"
		onsubmit="if(document.getElementById('search-keyword').value.length == 0) { return false; }">
		<input id="search-keyword" type="search" name="keyword" placeholder="検索">
	</form>
</div>

<div style="background-color:#f2f2f2;border-bottom: 1px solid #ccc">
<div class="content px-0">

<#include "_nav.md">

</div>
</div>

#--content--

[WordPress]: https://ja.wordpress.org/
[Jekyll]: https://jekyllrb.com/
[Gatsby]: https://www.gatsbyjs.org/
[Hexo]: https://hexo.io/
[flexmark]: https://github.com/vsch/flexmark-java
[LESS]: http://lesscss.org/
[Apache FreeMarker]: https://freemarker.apache.org/
[日本語組版処理]: text-layout.html

<!--
{.info .ml-auto}
: このWebサイトはCatalpaで作られています &#x1f60e;
-->

<!---->
{.info .deg-3 .mx-auto .mt-5 .mb-3 .pr-2} 2022-09-16 &ensp; バージョン 0.9
: * 青空文庫のルビ記法に対応しました。
  * 同梱の samples を大幅に刷新しました。
  * その他、いくつかの機能追加とバグを修正しています。

｜Catalpa《カタルパ》は日本語サイトの構築に適した静的サイトジェネレーターです。
[日本語組版処理]の機能が組み込まれており、和文・欧文混在の文章を綺麗にレイアウトすることができます。
このサイトもCatalpaで作られています。

## コンテンツ管理システム

以前は、コンテンツ管理システム（CMS）でWebサイトを作成するのが一般的でした。

世界で最も人気のあるWebサイト構築用のCMSといえば間違いなく[WordPress][]です。
CMSは基本的にWebサーバー上で動作させるプログラムであり、動的にWebページを生成します。
プログラムの実行環境だけでなくMySQLなどのデータベースも必要となるため、
CMSの運用には比較的高性能なサーバーが必要になります。

## 静的サイトジェネレーターとは

静的サイトジェネレーターは（Webサーバー上ではなく）ローカル環境でWebサイトを生成ツールです。
出力したサイトコンテンツ一式（HTML、CSS、JavaScript、…）をWebサーバーにコピーするだけでサイト構築が完了する手軽さがあります。

CMSとは異なりWebサーバー上でプログラムを実行する必要がないので、Webページの表示が速い、
プロバイダーの無料ホームページスペースでも簡単にWebサイトを公開できる、といった特徴があります。

世界中で多くの静的サイトジェネレーターが開発されており、
[Jekyll][]、[Gatsby][]、[Hexo][] といったソフトウェアが人気を博しています。

## Catalpaの特徴

すばらしい静的サイトジェネレーターが多数あるにも関わらず、
なぜ、Catalpaという新たな静的サイトジェネレーターを開発する必要があったのでしょうか？

それは、既存の静的サイトジェネレーターほぼすべてが外国製であり、
[日本語組版処理]に弱点があることが分かったからです。
きちんと[日本語組版処理]ができる静的サイトジェネレーターを作りたいという思いからCatalpaの開発に着手しました。

また、既存の静的サイトジェネレーターはコマンドラインで操作するものや、
プログラミング言語の開発環境・パッケージシステムを使って環境を構築するものが多く、
プログラミング経験のない人にとっては導入が難しいものでした。

そこで、CatalpaではZIPファイルを展開するだけで使い始められる、
GUIで操作できる、といった静的サイトジェネレーター導入の敷居を下げることにもこだわりました。

  * [x] 難しいインストール作業や設定はありません。
  * [x] GUIで操作できるのでコマンドを覚える必要がありません。
  * [x] Markdownでページを記述できます。
  * [x] 日本語組版処理を施したHTMLを出力します。
  * [x] テンプレートエンジンで分岐処理などを書くこともできます。
  * [x] LESSファイルをプリプロセッサーで処理してCSSを出力します。
  * [x] HTML、CSS、JS、PNGなどその他のファイルはそのまま出力されます。
  * [x] SFTP、SMB、Netlify プロトコルに対応したアップロード機能があります。

![](img/catalpa.webp){width=640 height=448}

HTMLやCSSを書かなくてもMarkdownだけでWebページを作成できる、これがCatalpaの基本的なコンセプトです。
といっても、HTMLやCSSの使用が制限されているわけではないので、
上級者はHTMLやCSSを直接書いてWebページのレイアウトや装飾を細かく調整することもできます。

理論的にはどのようなWebページもCatalpaで作成することができます。
「HTML手書きなら実現できるのにCatalpaの制約のせいでできない」ということはありません。

## ダウンロード

アプリケーションの実行には64ビットWindowsが必要です。

{.center}
[![](img/download.svg){width=256 height=256}
	*Catalpa 0.9&emsp;<br>ダウンロード&emsp;*](
	https://osdn.net/projects/catalpa/downloads/77777/catalpa-0.9.zip/
	){.button .image .hover .mt-1 .mx-1 style="height:72px" target="_blank" }
[![](img/IntelliJ_IDEA_icon.svg){width=128 height=128}
	*&ensp;このソフトウェアは<br>&ensp;JetBrains IntelliJ IDEA<br>&ensp;で開発されています*{.tiny}](
	https://www.jetbrains.com/?from=exewrap
	){.button .image .hover .mt-1 .mx-1 style="height:72px;background-color:black" target="_blank"}

## インストール

ダウンロードしたZIPファイルを適当なフォルダーに展開します。
ここでは<tt>C:\catalpa</tt>に展開したものとして説明していきます。

![](img/usage-001.webp){width=642 height=272 .shadow}

## 起動

<tt>catalpa.exe</tt>をダブルクリックするとアプリケーションが起動します。

![](img/usage-002.webp){width=430 height=194 .shadow}

{.center .my-3}
[使ってみよう](usage.html){.button .round .hover .next .primary}
