---
title: Catalpa 変更履歴
---

#--css--
.markdown dl.note dt {
	background-color: var(--primary-color);
}
.markdown dd > ul {
	margin-block-start: 1.5em;
	margin-block-end: 0.5em;
}

#--content--

変更履歴
========

<!---->
{.note .block .mb-3 .pr-2} Version 0.9 (2022-09-16)
: * Chromeでの最小フォントサイズ制限によって四分アキがやや広くなってしまう問題への対策としてCatalpaカスタムフォントを使用する方法を用意しました。
  * blogのページャー（前の記事・次の記事）でサムネイル画像のURL（thumbnail）を参照できるようにしました。
  * blog記事から関連記事（related）を参照できるようにしました。関連記事はカテゴリーの一致する数 > 日付の近い順で関連が強いと判定します。
  * 青空文庫のルビ記法に対応しました。
  * 半角スペースのみで構成される行を垂直スペース用の div として出力するようにしました。
  * 未知のタグ（たとえば&lt;hoge&gt;）を使用すると &lt;&lt;&lt;&lt;&lt;&lt;&lt; のように &lt; が連続で出力されてしまうバグを修正しました。
  * 定義リストの定義名を省略した場合、DL要素に "has-term" クラス属性が追加されるようになりました。
  * 同梱の samples を大幅に刷新しました。

  [「バージョン 0.9 への移行」](migration/v090.html)も参考にしてください。 

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.9 (2022-07-24)
: * Netlify アップロードが`SSLHandshakeException`で失敗する問題を修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.8 (2021-10-28)
: * ブログ形式の記事に`draft: skip`を指定してもカテゴリーページに表示されてしまうバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.7 (2021-09-30)
: * 0.8.6 で追加したブログ形式の固定ページ機能追加にともなって発生していたバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.6 (2021-09-20)
: * ブログ形式のサイトをルートURL以外に配置した場合、検索結果ページ（<tt>search.html</tt>）が正しく表示されないバグを修正しました。
  * ブログ形式で記事以外のMarkdownファイル（<tt>.md</tt>）も処理対象になるようになりました。これにより、ブログ形式のサイトにも固定ページを持たせることができるようになりました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.5 (2021-05-30)
: * コードブロック内に<code>&lt;/script&gt;</code>を記述すると<tt>search.html</tt>の表示が崩れてしまうバグを修正しました。
    <br><br>
    この修正により、キーワード<tt>&lt;</tt>と<tt>&gt;</tt>の検索が機能しなくなります。
    <tt>&lt;</tt>と<tt>&gt;</tt>を検索できるようにするために<tt>search.ftl</tt>の 138行目付近を以下の通り変更してください。
    （0.8.5 以降のサンプルコードに含まれている<tt>search.ftl</tt>は修正済みです。
    以前の<tt>search.ftl</tt>をお使いの方は修正をお願いします。）
    ```js
    keyword = keyword.replace("%20", " ").trim();
    ```
    ↓
    ```js
    keyword = keyword.replace("<", "&lt;").replace(">", "&gt;");
    keyword = keyword.replace("%20", " ").trim();
    ```

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.4 (2021-03-07)
: * ブログ形式の場合に記事中の<code>&lt;!--more--&gt;</code>の有無で「続きを読む」を表示するかどうかを制御できるようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.3 (2021-02-23)
: * <code>&lt;@markdown&gt;</code>ディレクティブ内でテンプレート変数の展開を適用するようにしました。
    トップページやカテゴリーページにブログ記事の冒頭が組み込まれる際に`${r"${baseurl}"}`や`${r"${siteurl}"}`が展開されるようになります。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.2 (2020-10-23)
: * 自動的に定義される変数`${r"${url}"}`・`${r"${path}"}`・`${r"${contentLastModified}"}`を追加しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8.1 (2020-07-15)
: * Netlifyのリダイレクト定義ファイル<tt>_redirects</tt>が存在する場合、出力フォルダーにコピーされるようになりました。
    Catalpaでは、先頭文字がアンダーバーで始まるファイルは除外ファイルとして扱われますが、<tt>_redirects</tt>は例外的に除外ファイルとして扱いません。
  * Markdown早見表のリンクを<tt>catalpa.osdn.jp</tt>から<tt>catalpa.oss.onl</tt>へ変更しました。
  * flexmark のバージョンを 0.62.2 に上げました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.8 (2020-01-31)
: * Netlifyへのアップロードに対応しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.6 (2019-10-19)
: * blogタイプでカテゴリーページの<tt>baseurl</tt>が設定されないバグを修正しました。
  * <tt>flexmark-ext-highlight</tt>のバージョンを0.2.5に更新しました。
    これにより、タイトルの指定されていないコードブロックにタイトル行が表示されてしまうバグが解消しています。
  * CSS微調整。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.5 (2019-10-08)
: * <tt>flexmark-ext-highligh</tt>ライブラリのバージョンを0.2.4に変更しました。
    これにより「クリップボードにコピー」ボタンが表示されないバグが解消しています。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.4 (2019-10-07)
: * テキストをクリップボードにコピーしたときにゼロ幅スペース（&amp;#8203;）が含まれてしまう問題を修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.3 (2019-09-28)
: * Markdownエンジンflexmarkのバージョンを0.40.24から0.50.40に変更しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.2 (2019-09-13)
: * 行頭の四分アキが除去されないバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.1 (2019-08-18)
: * ソースコード表示で行番号を表示できるようになりました。
  * 更新処理中にファイル変更を検出した場合、更新完了後に再処理するようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.7.0 (2019-07-21)
: * blogタイプのフォルダーを開いたときに記事作成ウィザードが起動するようになりました。
  * Visual Studio Code（VSCode）をインストールしている場合、メニューバーにVSCode起動アイコンが表示されるようになりました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.6.2 (2019-07-16)
: * 「名前を付けて保存」操作で固まってしまうことがあるバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.6.1 (2019-07-09)
: * <tt>config.yml</tt>の<tt>upload</tt>定義を<tt>catalpa/mydata/config.yml</tt>に分離できるようにしました。
  * exewrapのバージョンを1.4.0に変更しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.6.0 (2019-07-04)
: * blog、doc にも検索機能を追加しました。
  * SNSボタン（はてブ、Facebookシェア、Twitter）を追加しました。
  * 検索インデックスで<tt>title</tt>のHTMLタグを除去するようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.5.2 (2019-07-02)
: * <tt>codehighlight-1.0.2+.jar</tt>を修正版に入れ替えました。
    このバージョンは未知の言語を指定した場合にHTMLエスケープがされないバグが修正されています。

<!---->
{.note .block .mb-3 .pr-2} Version 0.5.2 (2019-06-29)
: * アップロード処理の進捗を表示するようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.5.1 (2019-06-27)
: * 更新状況が分かるように画面下部にプログレスバーを表示するようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.5.0 (2019-06-25)
: * ファイル出力時のgzip圧縮、brotli圧縮機能を追加しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.4.3 (2019-06-23)
: * blogタイプの`draft`に`skip`を指定できるようにしました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.4.2 (2019-06-11)
: * blogタイプで<tt>sitemap.xml</tt>にサイトルートが含まれるようにしました。
  * <tt>sitemap.xml</tt>のアイテムを日付の新しい順に並べるようにしました。
  * <tt>category</tt>に<tt>noindex</tt>を追加しました。
  * <tt>index.html</tt>に<tt>canonical</tt>を追加しました。2ページ目以降には<tt>noindex</tt>を追加しました。
  * blogタイプで記事ごとにタイトルが出るように修正しました。
  * blogタイプで<tt>description</tt>が出力されるように修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.4.1 (2019-05-20)
: * blog下書きモードのときに「アップロード」ボタンが無効になるようにしました。
  * blog下書きモードのときに「ブラウザーで開く」ボタンを押したときの初期ページを最新ドラフトにしました。
  * blogタイプでアップロード時に`NullPointerException`が発生するバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.4.0 (2019-05-15)
: * blogの下書きモードに「総記事数」と「文字数」を表示するようにしました。
  * `FileWatchService`のExecutorスレッドがDaemonになっておらずプロセスが残留してしまうバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.3.9 (2019-05-14)
: * blogに下書きモードを追加しました。YAML Front Matterに`draft:`行を追加すると下書きモードになります。

<!---->
{.note .block .mb-3 .pr-2} Version 0.3.7 (2019-05-06)
: * blog形式で水平線`---`を使用するとYAML Front Matterとして認識されてしまうバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.3.6 (2019-04-23)
: * 日本語組版で`pre`ブロックの間に無駄な余白ができてしまうバグを修正しました。
  * 全角記号と英数字の間の半角スペースが除去されてしまうバグを修正しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.3.5 (2019-04-11)
: * 日本語組版で半角記号、全角記号はベタ組みするように修正しました。
  * <tt>samples</tt>でタイトルバーにアイコンを配置できるようにテンプレートを変更しました。

<!---->
{.note .block .mb-3 .pr-2} Version 0.2 (2019-03-20)
: * 最初のリリースです。

{.center .my-3}
[トップページに戻る](/){.button .round .hover .previous .primary}
