
# 一般サイトで使用できる変数 #

<tt>config.yml</tt>や任意のMarkdownファイル（<tt>.md</tt>）の先頭にはYAMLでデータ変数を定義することができます。

## config.ymlファイルに定義できる変数 ##

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>siteurl</tt>
| サイトのURLを指定します。サイトURLは<tt>http://</tt>または<tt>https://</tt>から始まります。
  末尾には<tt>/</tt>を含みません。末尾に<tt>/</tt>を含めた場合は自動的に取り除かれます。
  タイトルのリンクURLや<tt>sitemap.xml</tt>、OGPプロパティ（<tt>og:url</tt>）で使用されます。
|
| <tt>title</tt>
| タイトルを指定します。タイトルバーに表示されます。
  指定された値は`<title>`タグとOGPプロパティ（<tt>og:site\_name</tt>と<tt>og:title</tt>）にも設定されます。
  必要に応じて各ページのMarkdownファイルで上書き定義しましょう。
|
| <tt>description</tt>
| サイトの説明を指定します。
  指定された値は`<meta name="description" content="...">`と
  OGPプロパティ（<tt>og:description</tt>）に設定されます。
  各ページのMarkdownファイルで上書き定義しましょう。
|
| <tt>copyright</tt>
| サイトの著者年を指定します。著者年はページのフッターに表示されます。
|
| <tt>author</tt>
| サイトの著者名を指定します。著者名はページのフッターに表示されます。
  指定を省略すると著者名の代わりにメールアドレスが表示されます。
|
| <tt>mailto</tt>
| 著者のメールアドレスを指定します。
  ページフッターに表示される著者名またはメールアドレスの<tt>mailto</tt>リンクになります。
|
| <tt>image</tt>
| イメージファイルを`siteurl`からの相対パスで指定します。
  指定された値はOGPプロパティ（<tt>og:image</tt>）に設定されます。
  指定を省略すると<tt>og:image</tt>は出力されません。
|

## Markdownファイルに定義できる変数 ##

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>template</tt>
| Markdownファイルに適用するテンプレート名を指定します。
  指定を省略した場合、<tt>default.ftl</tt>がテンプレートとして適用されます。
  テンプレート名の指定では拡張子<tt>.ftl</tt>を省略することもできます。
  テンプレートはルートフォルダーの<tt>templates</tt>フォルダーから検索されます。
|

MarkdownファイルのYAML front matterでは
<tt>config.yml</tt>で定義されている変数を上書きしたり、ユーザー独自の変数を定義することができます。
`title`や`description`などページごとに変えたほうが良いものはなるべくMarkdownファイルで指定するようにしましょう。


## 自動的に定義される変数 ##

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>baseurl</tt>
| ベースURLが相対パスで格納されます。
  ルートフォルダーに配置したMarkdownファイルで`${r"${baseurl}"}`を参照した場合、値は空文字になります。
  ルートフォルダーの<tt>sub</tt>フォルダーに配置したMarkdownファイルで`${r"${baseurl}"}`を参照した場合、値は<tt>../</tt>になります。
  たとえば、`${r"${baseurl}"}img`はどの階層に配置されたMarkdownファイルから参照してもルートフォルダーの<tt>img</tt>を指し示します。
|
| <tt>path</tt>
| ページの（ルートフォルダーを基準とした）相対パスが格納されます。
  この値はURLエンコードされていません。Freemarkerの組み込み機能`?url_path`を使うことでURLエンコードされた文字列を参照できます。
  先頭に<tt>/</tt>（スラッシュ）は含まれません。
  `${r"${siteurl}"}`と連結することでページのURLを表わすことができます。
  `${r"${siteurl!}/${path!?url_path}"}`
|
| <tt>url</tt>
| ページのURLが格納されます。
  `${r"${siteurl!}/${path!?url_path}"}` と同等の値が格納されています。この値はURLエンコードされています。
|
| <tt>dateModified</tt>
| ページの最終更新日が格納されます。
  入力ソースとなったMarkdownファイル、テンプレートファイル、CSSファイルの中で最も新しい日付が最終更新日となります。
  テンプレートファイルやCSSファイルを書き換えると、それを参照している複数のページの最終更新日付が更新されることに注意してください。
  ページに表示する最終更新日を明確にコントロールしたい場合は`${r"${dateModified}"}`を参照せずに
  ユーザー定義の変数を参照するようにテンプレートを書き換えてください。
|
| <tt>contentLastModified</tt>
| ページコンテンツの最終更新日が格納されます。
  入力ソースとなったMarkdownファイルの日付が格納されます。
  テンプレートファイルやCSSファイルを書き換えてもこの日付は影響を受けません。
|
| <tt>\_PREVIEW</tt>
| Catalpaのローカルサーバー機能でプレビューしていることを示すフラグです。
  プレビュー時は`true`になります。
  「名前を付けて保存」するときは`false`になります。
|
{.center .my-3}
[戻る](features.html){.button .round .hover .previous .primary}
