
# ブログサイトで使用できる変数 #

<tt>config.yml</tt>や任意のMarkdownファイル（<tt>.md</tt>）の先頭にはYAMLでデータ変数を定義することができます。

## config.ymlファイルに定義できる変数 ##

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>type</tt>
| ブログサイトを作成する場合は`blog`を指定してください。
|
| <tt>paginate</tt>
| 1つのリストページ（トップページを含む）に表示する記事の数を指定します。
|
| <tt>siteurl</tt>
| サイトのURLを指定します。サイトURLは<tt>http://</tt>または<tt>https://</tt>から始まります。
  末尾には<tt>/</tt>を含みません。末尾に<tt>/</tt>を含めた場合は自動的に取り除かれます。
  タイトルのリンクURLや<tt>sitemap.xml</tt>、OGPプロパティ（<tt>og:url</tt>）で使用されます。
|
| <tt>title</tt>
| サイトのタイトルを指定します。タイトルバーに表示されます。
  指定された値は`<title>`タグとOGPプロパティ（<tt>og:site\_name</tt>と<tt>og:title</tt>）にも設定されます。
  必要に応じて各ページのMarkdownファイルで上書き定義しましょう。
|
| <tt>description</tt>
| サイトの説明を指定します。
  指定された値は`<meta name="description" content="...">`と
  OGPプロパティ（<tt>og:description</tt>）に設定されます。
  各ページのMarkdownファイルで上書き定義しましょう。
|
| <tt>copyright</tt>
| サイトの著者年を指定します。著者年はページのフッターに表示されます。
|
| <tt>author</tt>
| サイトの著者名を指定します。著者名はページのフッターに表示されます。
  指定を省略すると著者名の代わりにメールアドレスが表示されます。
|
| <tt>mailto</tt>
| 著者のメールアドレスを指定します。
  ページフッターに表示される著者名またはメールアドレスの<tt>mailto</tt>リンクになります。
|
| <tt>image</tt>
| イメージファイルを`siteurl`からの相対パスで指定します。
  指定された値はOGPプロパティ（<tt>og:image</tt>）に設定されます。
  指定を省略すると<tt>og:image</tt>は出力されません。
|

## Markdownファイルに定義できる変数 ##

ブログサイトでは1つのMarkdownファイルが1つの記事に対応します。

  * 記事には<tt>post.ftl</tt>テンプレートファイルが適用されます。
    `template`変数で適用するテンプレートを指定することはできません。
  * 記事は年月日で分類したフォルダー（<tt>yyyy\\mm\\dd\\</tt>）に配置することを推奨しています。

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>date</tt>
| 記事の日付を<tt>yyyy-mm-dd</tt>の形式で指定します。
|
| <tt>title</tt>
| 記事のタイトルを指定します。
|
| <tt>description</tt>
| 記事の説明を指定します。
|
| <tt>categories</tt>
| 記事のカテゴリーを指定します。複数のカテゴリーを指定する場合は全体を`[`で`]`で囲み、各カテゴリーを`,`で区切ります。
  カテゴリーに日本語を使う場合は末尾に`(...)`で英数字のみの表記を繋げてください。これはカテゴリーページのURLとして使用されます。
  たとえば`プログラミング(programming)`と記述するとカテゴリー名が「プログラミング」、カテゴリーページのURLが「programming」になります。
  すべての記事でカテゴリーURLを明示する必要はありません。1つの記事で`プログラミング(programming)`というカテゴリー指定がされていれば、
  他の記事では`プログラミング`というカテゴリー指定だけでも構いません。自動的にカテゴリーURLは「programming」になります。
  新しいカテゴリーを初めて使うときは`(...)`でカテゴリーURLを定義する、と覚えておくと良いと思います。
  カテゴリー名が半角英数字のみの場合も`(...)`を省略できます。たとえば、カテゴリー名が「Java」の場合に`Java(java)`と書く必要はありません。
  `Java`と書くだけで自動的にカテゴリーURLは`java`になります。（自動的に小文字への変換がおこなわれます。）
|
| <tt>thumbnail</tt>
| 記事のサムネイル画像を記事ファイル（<tt>.md</tt>）からの相対パスで指定します。
  指定を省略した場合、<tt>thumbnail.(png\|webp\|jpg\|gif)</tt>が検索され見つかればそれを使用します。
  見つからなければさらに、<tt>image.(png\|webp\|jpg\|gif)</tt>を検索し見つかればそれを使用します。
  それでも見つからなければ、記事中で最初に出現する画像を使用します。
| 
| <tt>image</tt>
| OGPプロパティ（<tt>og:image</tt>）に設定される画像を記事ファイル（<tt>.md</tt>）からの相対パスで指定します。
  指定を省略した場合、<tt>image.(png\|webp\|jpg\|gif)</tt>が検索され見つかればそれを使用します。
  見つからなければ、記事中で最初に出現する画像を使用します。
  ここに指定した画像は、はてなブックマーク、Twitter、Facebook等のSNSから参照されるときに使われます。
|
| <tt>draft</tt>
| 変数`draft`を定義すると、この記事が作成中であることを示します。
  変数名`draft`が定義されていればよいので値は指定しなくても構いません。
  作成中の記事がある場合、Catalpaは作成中の記事のみを処理するようになります。これは処理時間を短縮するのに効果的です。
  変数`draft`の値を`skip`にすると、その記事はスキップされCatalpaの処理対象となりません。
  作成中の記事を保留してブログサイト全体を出力したい場合に`skip`が役に立ちます。
|

## 自動的に定義される変数 ##

| 変数　　　　　 | 説明 |
|----------------|------|
| <tt>baseurl</tt>
| ベースURLが相対パスで格納されます。
  ルートフォルダーに配置したMarkdownファイルで`${r"${baseurl}"}`を参照した場合、値は空文字になります。
  ルートフォルダーの<tt>sub</tt>フォルダーに配置したMarkdownファイルで`${r"${baseurl}"}`を参照した場合、値は<tt>../</tt>になります。
  たとえば、`${r"${baseurl}"}img`はどの階層に配置されたMarkdownファイルから参照してもルートフォルダーの<tt>img</tt>を指し示します。
|
| <tt>path</tt>
| ページの（ルートフォルダーを基準とした）相対パスが格納されます。
  この値はURLエンコードされていません。Freemarkerの組み込み機能`?url_path`を使うことでURLエンコードされた文字列を参照できます。
  先頭に<tt>/</tt>（スラッシュ）は含まれません。
  `${r"${siteurl}"}`と連結することでページのURLを表わすことができます。
  `${r"${siteurl!}/${path!?url_path}"}`
|
| <tt>url</tt>
| ページのURLが格納されます。
  `${r"${siteurl!}/${path!?url_path}"}` と同等の値が格納されています。この値はURLエンコードされています。
|
| <tt>dateModified</tt>
| ページの最終更新日が格納されます。
  入力ソースとなったMarkdownファイル、テンプレートファイル、CSSファイルの中で最も新しい日付が最終更新日となります。
  テンプレートファイルやCSSファイルを書き換えると、それを参照している複数のページの最終更新日付が更新されることに注意してください。
  ページに表示する最終更新日を明確にコントロールしたい場合は`${r"${dateModified}"}`を参照せずに
  ユーザー定義の変数を参照するようにテンプレートを書き換えてください。
|
| <tt>contentLastModified</tt>
| ページコンテンツの最終更新日が格納されます。
  入力ソースとなったMarkdownファイルの日付が格納されます。
  テンプレートファイルやCSSファイルを書き換えてもこの日付は影響を受けません。
|
| <tt>\_PREVIEW</tt>
| Catalpaのローカルサーバー機能でプレビューしていることを示すフラグです。
  プレビュー時は`true`になります。
  「名前を付けて保存」するときは`false`になります。
|
{.center .my-3}
[戻る](features.html){.button .round .hover .previous .primary}
