
[Win32-OpenSSH]: https://github.com/PowerShell/Win32-OpenSSH/releases
[OSDN]: https://ja.osdn.net/

SFTP
====

サーバーがSFTPに対応している場合、サイトのアップロード作業をCatalpaで自動化することができます。

 - [x] 公開鍵認証
 - [x] パスワード認証

のどちらにも対応しています。

## 公開鍵認証 ##

公開鍵認証にはSSHキーペアが必要です。
[Win32-OpenSSH]{target="_blank"}を導入するとキーペアを作成できるようになります。
キーペアの作成手順、サーバーへの公開鍵登録についてはここでは触れません。
あらかじめ、準備しておいてください。

公開鍵認証には以下の接続情報が必要になります。

  * サーバーのホスト名
  * サーバーのSSHポート番号（通常は22）
  * サーバーのディレクトリパス
  * ユーザー名
  * 秘密鍵ファイル
  * 秘密鍵のパスフレーズ（設定している場合）

このCatalpaのサイトをホスティングしている[OSDN]{target="_blank"}もSFTP公開鍵認証に対応しています。
たとえば、OSDNにSFTPでサイトをアップロードする場合の設定例は以下のようになります。
（ディレクトリパス・ユーザー名・秘密鍵ファイル・秘密鍵のパスフレーズは仮です。）

|----------------------|--------------------------------------------|
| ホスト名             | **<tt>shell.osdn.jp</tt>**                 |
| ポート番号           | **<tt>22</tt>**                            |
| ディレクトリパス     | <tt>/home/groups/c/ca/catalpa/htdocs/</tt> |
| ユーザー名           | myusername                                 |
| 秘密鍵ファイル       | <tt>id\_rsa</tt>                           |
| 秘密鍵のパスフレーズ | mySecretPhrase                             |

これらの情報をサイトプロジェクトフォルダーの<tt>config.yml</tt>に以下のように設定します。

```yml config.yml {.copy .scroll}
---
upload:
  type: sftp
  host: shell.osdn.jp
  port: 22
  path: /home/groups/c/ca/catalpa/htdocs/
  username: myusername
  privateKey: id_rsa
  passphrase: mySecretPhrase
---
```

* `type`に、固定値**sftp**を指定します。

* `port`指定は省略することもできます。省略した場合、ポート番号 22 が使用されます。

* `privateKey`には秘密鍵ファイルのフルパスまたは相対パスを指定します。
相対パスを指定した場合、<tt>config.yml</tt>のあるフォルダーを基準パスとして相対パスが解決されます。


## パスワード認証 ##

CatalpaのSFTPアップロード機能はパスワード認証にも対応しています。
サーバー側もパスワード認証が有効になっている必要があります。
通常、公開鍵認証を使用しているセキュアなサーバーではパスワード認証が無効化されていることが多いです。
対象のサーバーがパスワード認証をサポートしているかご確認ください。

パスワード認証を使用する場合は<tt>config.yml</tt>に以下のように設定します。
（設定値はOSDNの例です。実際のサーバー環境に合わせて適切に設定してください。）

公開鍵認証では`privateKey`、`passphrase`を設定しますが、
パスワード認証では`password`を設定します。設定値の違いはこれだけです。
`host`や`port`など他の設定値は公開鍵認証の場合と同じです。

```yml config.yml {.copy .scroll}
---
upload:
  type: sftp
  host: shell.osdn.jp
  port: 22
  path: /home/groups/c/ca/catalpa/htdocs/
  username: myusername
  password: mySecretPassword
---
```

* `type`に、固定値**sftp**を指定します。

* `port`指定は省略することもできます。省略した場合、ポート番号 22 が使用されます。

* `password`にはユーザーのパスワードを指定します。


## SFTP対応サーバーへサイトをアップロードする ##

Catalpaに同梱されているサンプル<tt>samples\site1</tt>にSFTPアップロード設定を追記してみます。

アップロード設定されているフォルダーを開くと右下の["アップロード"]ボタンが押下可能になっています。

![](img/upload-sftp-001.webp){width=430 height=194 .shadow}

["アップロード"]ボタンをクリックするとサイトのアップロードが始まります。

![](img/upload-sftp-002.webp){width=430 height=194 .shadow}

"アップロードが完了しました" というメッセージが表示されれば成功です。

![](img/upload-sftp-003.webp){width=430 height=194 .shadow}

SFTPを使用してサイトをアップロードする設定の説明は以上です。

{.center .my-3}
[戻る](features.html){.button .round .hover .previous .primary}
