
Netlify
=======

[Netlify]: https://www.netlify.com/
[Netlifyの管理ページ]: https://app.netlify.com/
[GitHub]: https://github.com/

[Netlify]{target="_blank"}は静的サイトのホスティングサービスです。
Starter、Pro、Businessの3つのプランがあり、Starterは無料で使うことができます。
他のホスティングサービスに比べて無料で使える枠が大きいのが特徴です。

Netlifyの無料プランはクレジットカードの登録が必要ないというのも嬉しいです。
他のホスティングサービスでは無料枠の利用でもクレジットカードの登録が必要で、
無料枠を超過すると自動的に料金が請求されるものもあります。怖いですよね。

Netlifyはメールアドレスの登録だけで無料プランを利用できるので、
不慮の課金を心配しなくても大丈夫です。

{.center .my-2}
[![](img/upload-netlify-001.webp){width=544 height=412 .shadow}][Netlify]{target=_blank}


Netlifyのアカウントを作成する
-----------------------------

[GitHub]{target="_blank"}等のGitホスティングサービスとの連携機能が特徴として挙げられることが多いのですが、
NetlifyはGitと連携させずに使うこともできます。
ここではGitと連携させずに、メールアドレスでNetlifyアカウントを作成して
静的サイトを公開する手順を解説します。

<https://www.netlify.com>{target="_blank"} にアクセスして
[Get started for free](https://app.netlify.com/signup){target="_blank"}をクリックします。

{.center .my-2}
[![](img/upload-netlify-002.webp){width=544 height=448 .shadow}][Netlify]{target=_blank}

[Email](https://app.netlify.com/signup/email){target="_blank"}をクリックします。

{.center .my-2}
[![](img/upload-netlify-003.webp){width=544 height=544 .shadow}](https://app.netlify.com/signup){target=_blank}

メールアドレス、設定するパスワードを入力して**Sign up**をクリックします。
簡単に推測できてしまうようなパスワードだと`Password is too easy to guess`というメッセージが表示されサインアップが完了しません。
パスワードには12文字以上の長さが必要なようです。

![](img/upload-netlify-004.webp){width=544 height=512 .shadow}

メールを確認するように促されます。

![](img/upload-netlify-005.webp){width=544 height=496 .shadow}

登録したメールアドレスのメールの受信トレイを確認しましょう。
**Welcome to Netlify. Let's verify your emal** というメールが届いているはずです。
メール本文の**Verify email**をクリックすれば登録完了です。

![](img/upload-netlify-006.webp){width=600 height=480 .shadow}

自動的にNetlifyのサイトが開き、**QUICKSTART GUIDE**が表示されます。
（もし表示されなかったら、<https://www.netlify.com/>{target="_blank"}にアクセスして右上の
[Log in](https://app.netlify.com/){target="_blank"}をクリックしてログインしてください。）

**QUICKSTART GUIDE**は**Next**をクリックして読み進めていくか、
もしくは右上の**×**ボタンをクリックして閉じることもできます。

![](img/upload-netlify-007.webp){width=535 height=436 .shadow}

**QUICKSTART GUIDE**が終わると[Netlifyの管理ページ]{target="_blank"}が表示されます。

![](img/upload-netlify-008.webp){width=544 height=560 .shadow}


## 新規サイトを作成する ##

[Netlifyの管理ページ]{target="_blank"}にアクセスできるようになったら、
次はサイトを作成してみます。

管理ページの
「Want to deploy a new site without connectiong Git? Drag and drop your site folder here」
と書かれている部分にフォルダーをドラッグ＆ドロップすると新しいサイトを作成することができます。

ドラッグ＆ドロップするフォルダーは何でも構いません。
空っぽのフォルダーでも大丈夫です。
ここでの目的は新しいサイトを作成してホストアドレス（URL）を割り当てることです。
サイトの中身は後でCatalpaからアップロードします。

![](img/upload-netlify-009.webp){width=480 height=288 .shadow}

Catalpaを展開したフォルダーに<tt>etc\netlify</tt>フォルダーを用意しておきました。
この<tt>netlify</tt>フォルダーをドラッグ＆ドロップしてもらえばシンプルなサイトができます。ご利用ください。

![](img/upload-netlify-010.webp){width=543 height=244 .shadow}

フォルダーをドラッグ＆ドロップすると自動的にサイトが作成され、
ホストアドレス（URL）が割り当てられます。

![](img/upload-netlify-011.webp){width=640 height=416 .shadow}

["Site settings"] → ["Change site name"] からホスト名を変更することができます。
この操作ではドメインが`netlify.com`に固定されており、変更できるのはホスト名部分のみになります。

![](img/upload-netlify-012.webp){width=568 height=320 .shadow}

すでに他のユーザーが取得しているホスト名は使用できません。
（`This site name is already taken`というエラーメッセージが表示されます。）

![](img/upload-netlify-013.webp){width=568 height=320 .shadow}

この方法で、あまり良いホスト名が取得できないようであれば、
カスタムドメインの割り当てを検討してみてください。
Netlifyでは自分の所有しているドメインを使用することもできます。


## Personal access token を作成する ##

CatalpaはNetlify APIに対応しています。

Netlifyで**Personal access token**を作成し、
作成したトークンをCatalpaに登録することでCatalpaからNetlifyへのアクセスが許可されます。

[Netlifyの管理ページ]{target="_blank"}右上のユーザーアイコンをクリックして["User settings"]を選択します。

![](img/upload-netlify-014.webp){width=560 height=240.shadow}

User settingsページが表示されたら左側のメニューから["Applications"]をクリックします。

![](img/upload-netlify-015.webp){width=576 height=432.shadow}

ページの右側に**Personal access tokens**という欄が出てくるので["New access token"]をクリックします。

![](img/upload-netlify-016.webp){width=592 height=216 .shadow}

作成するトークンに名前を付けて["Generate token"]をクリックします。
トークンの名前は自由に決めることができます。Netlify APIを使用する外部ツールの名前にしておくと分かりやすいと思います。

![](img/upload-netlify-017.webp){width=592 height=432 .shadow}

作成したトークンが表示されます。
画面に表示されているトークン文字列をコピーしてテキストファイルに保存してください。
トークン文字列を保存したら["Done"]をクリックします。

![](img/upload-netlify-018.webp){width=592 height=440 .shadow}

**Personal access tokens**の一覧に作成したトークンの名前が表示されていればOKです。
（ここではトークンの名前を「Catalpa」としました。）

![](img/upload-netlify-019.webp){width=592 height=304 .shadow}


## Catalpaにアクセストークンを設定する ##

作成したトークンをCatalpaのサイトプロジェクトに設定します。

ここでは例としてCatalpaに同梱されているサンプル<tt>samples\site1</tt>に設定してみます。

<tt>samples\site1</tt>フォルダーに<tt>config.yml</tt>を作成して内容を以下のようにします。


```yml config.yml {.copy .scroll}
---
upload:
  type: netlify
  siteName: friendly-murdock-2d0bb0
  personalAccessToken: 31f7e68f5d6d1cb7454c4060407828906978c6a5fc561f574fdf5c4e3e576def
---
```

  * `type`に、固定値**netlify**を指定します。

  * `siteName`に、Netlifyで作成したサイト名を指定します。

  * `personalAccessToken`に、Netlifyで作成したトークンを指定します。

これでNetlifyへのアップロード設定は完了です。

## CatalpaからNetlifyへサイトをアップロードする ##

Netlifyアップロード設定を追記した<tt>config.yml</tt>を含む<tt>samples\site1</tt>フォルダーをCatalpaで開きます。

アップロード設定されているフォルダーを開くと右下の["アップロード"]ボタンが押下可能になっています。

![](img/upload-netlify-020.webp){width=430 height=194 .shadow}

["アップロード"]ボタンをクリックするとNetlifyへのサイトアップロードが始まります。

![](img/upload-netlify-021.webp){width=430 height=194 .shadow}

"アップロードが完了しました" というメッセージが表示されれば成功です。

![](img/upload-netlify-022.webp){width=430 height=194 .shadow}

Netlifyの管理ページから**Deploys**を開くと状況を確認できます。
下部の一覧に`Uploaded from Catalpa 0.8`と表示されてますね。

![](img/upload-netlify-023.webp){widtH=640 height=616 .shadow}

Netlifyで割り当てられたURLをブラウザーで開くと
Catalpaでアップロードしたサイトがちゃんと表示されます。

![](img/upload-netlify-024.webp){width=748 height=363 .shadow}

サイトをNetlifyへアップロードする設定の説明は以上です。

{.center .my-3}
[戻る](features.html){.button .round .hover .previous .primary}
