サイドバー付きのレイアウト
==========================

サイドバーやヘッダーなどを配置したレイアウトの作り方を学びましょう。

![](img/tutorial2-001.webp){width=502 height=261 .shadow}

上記のようなレイアウトをCSSフレックスレイアウトで実現する場合、
以下のようなHTMLになります。

```html sample.html {.copy .scroll .line-number}
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY style="margin:0">
		<DIV style="display:flex;height:100vh;">
			<DIV style="flex-grow:1;
				padding: 1em;
				background-color:#FEE">
				ここがサイドバーです。
			</DIV>
			<DIV style="flex-grow:3;
				padding: 1em;
				background:#EFF">
				ここがメイン・コンテンツです。
			</DIV>
		</DIV>
	</BODY>
</HTML>
```

これをMarkdownを差し込めるようにテンプレート化すると以下のようになります。別のMarkdownファイルから差し込みたい部分を`${r"${content}"}`にするのでしたね。

```html defult.ftl {.copy .scroll .line-number}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY style="margin:0">
		<DIV style="display:flex;height:100vh;">
			<DIV style="flex-grow:1;
				padding: 1em;
				background-color:#FEE">
				ここがサイドバーです。
			</DIV>
			<DIV style="flex-grow:3;
				padding: 1em;
				background:#EFF">
				<@markdown>${content}</@markdown>
			</DIV>
		</DIV>
	</BODY>
</HTML>
</#noparse>
```

メイン・コンテンツのほうは`${r"${content}"}`としました。
では、サイドバーのほうはどうしたらよいでしょうか？

サイドバーのほうも任意の名前で変数に置き換えることができます。
今回は`${r"${mysidebar}"}`という名前を使ってみましょう。

```html defult.ftl {.copy .scroll .line-number}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY style="margin:0">
		<DIV style="display:flex;height:100vh;">
			<DIV style="flex-grow:1;
				padding: 1em;
				background-color:#FEE">
				<@markdown>${mysidebar}</@markdown>
			</DIV>
			<DIV style="flex-grow:3;
				padding: 1em;
				background:#EFF">
				<@markdown>${content}</@markdown>
			</DIV>
		</DIV>
	</BODY>
</HTML>
</#noparse>
```

次に、このテンプレートに差し込むMarkdownファイルを用意します。

```markdown index.md {.copy .scroll .line-number}
---
template: default.ftl
---

# ようこそ #

わたしのメイン・コンテンツです。
```

このように記述した内容が`${r"${content}"}`に差し込まれるのでしたよね。
しかし、これでは`${r"${content}"}`が定義されているだけで、`${r"${mysidebar}"}`が定義されていません。

## コンテント・ブロック記述 ##

Catalpaのコンテント・ブロック記述を使うと、
`${r"${mysidebar}"}`を追加定義することができます。

行頭が`#--`で始まり、行末が`--`で終わる行はコンテント・ブロックの開始宣言として認識されます。
`#--mysidebar--`という行を記述すれば、
`mysidebar`という名前のコンテント・ブロックの開始宣言となります。

```markdown index.md {.copy}
---
template: default.ftl
---

# ようこそ #

わたしのメイン・コンテンツです。


<#noparse>#--mysidebar--</#noparse>

ここはわたしのサイドバーです。
```

  - {.tree} <tt>D:\mysite</tt>
      - <tt>templates</tt>
          - <tt>default.ftl</tt>
      - <tt>index.md</tt>

これらのファイルをCatalpaで処理すると結果は以下のようになります。

![](img/tutorial2-002.webp){width=502 height=261 .shadow}


## 既定のコンテント・ブロック ##

さきほどの<tt>index.md</tt>は以下のように`#--content--`を明示的に書くこともできます。

``` index.md
---
template: default.ftl {.copy}
---

<#noparse>#--content--</#noparse>

# ようこそ #

わたしのメイン・コンテンツです。

<#noparse>#--mysidebar--</#noparse>

ここはわたしのサイドバーです。
```

これまでのMarkdown記述では`#--content--`を省略していたのです。
最初のコンテント・ブロックは宣言を省略することができ、
その場合、コンテント・ブロックの名前は自動的に`content`になります。

## config.ymlで宣言することもできます ##

サイドバーなどサイト全体で共通にしたい、
個別のMarkdownファイルに記述したくない、ということもありますよね。

コンテント・ブロックは<tt>config.yml</tt>で宣言することもできます。

`mysidebar`の定義を<tt>config.yml</tt>に書いてみましょう。

```yaml config.yml
#--mysidebar--　
これはサイト全体で共通のサイドバーです。
```

<tt>index.md</tt>からは`mysidebar`の定義を削除します。

```markdown index.md {.copy}
---
template: default.ftl
---

# ようこそ #

わたしのメイン・コンテンツです。
```

  - {.tree} <tt>D:\mysite</tt>
      - <tt>templates</tt>
          - <tt>default.ftl</tt>
      - <tt>index.md</tt>
      - **<tt>config.yml</tt>**

`mysidebar`を宣言した<tt>config.yml</tt>を加えてCatalpaで処理すると結果は以下のようになります。

![](img/tutorial2-003.webp){width=502 height=261 .shadow}

<tt>config.yml</tt>とMarkdownファイルで同じ名前のコンテント・ブロックを宣言した場合は、Markdownファイルの宣言が優先されます。
<tt>content.yml</tt>で共通のサイドバーを定義しておき、
一部のページだけサイドバーを変えたいといったときは、Markdownファイルで宣言を上書きできるわけです。


{.center .my-3}
[もっと詳しく](features.html){.button .round .hover .next .primary}
