[「Markdown早見表」]: markdown.html

簡単なサイトを作ってみる
========================

Catalpaがどのような仕組みで動いているのかを知るために、実際に小さなコード片を書いていきましょう。

## テンプレート処理 ##

はじめに実験的なコードを書くためのフォルダーを用意します。
ここでは<tt>D:\mysite</tt>としました。
そして、<tt>D:\mysite\templates\default.ftl</tt>と<tt>D:\mysite\index.md</tt>の2つのファイルを作成します。
<tt>default.ftl</tt>は<tt>templates</tt>フォルダーの中に置くことに気を付けてください。
Catalpaでは<tt>templates</tt>という名前のフォルダーは特別な意味を持っています。

  - {.tree} <tt>D:\mysite</tt>
      - <tt>templates</tt>
          - <tt>default.ftl</tt>
      - <tt>index.md</tt>

上記のようなフォルダー構造ができたら、
<tt>default.ftl</tt>と<tt>index.md</tt>のファイルの中身を以下の通り入力してください。
推奨文字コードはUTF-8ですが、Catalpaには文字コードの自動認識機能がありますのでShift_JISやEUC-JPでファイルを作成しても構いません。

```html default.ftl {.copy}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY>
		${content}
	</BODY>
</HTML>
</#noparse>
```

次は<tt>index.md</tt>です。
これは、Webページに表示されるコンテンツになるので内容を多少アレンジしても構いません。

```markdown index.md {.copy}
本日は**晴天**なり。
```

所定のフォルダー構造に<tt>default.ftl</tt>と<tt>index.md</tt>を作ったら
Catalpaを起動して<tt>D:\mysite</tt>を開きます。

![](img/tutorial1-001.webp){width=430 height=194 .shadow}

フォルダーを開くと自動的に処理が始まります。
正常に終了したら["ブラウザーで開く"]を押してください。
既定のブラウザーが起動して作成されたWebページが表示されます。

![](img/tutorial1-002.webp){width=430 height=245 .shadow}

このWebページのHTMLは以下のようになっています。

```html index.html
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY>
		本日は**晴天**なり。

	</BODY>
</HTML>
```

<tt>default.ftl</tt>の`${r"${content}"}`部分が<tt>index.md</tt>の中身に置き換わった形ですね。
これがテンプレート処理の結果です。テンプレートを使うことで、
レイアウトやドキュメント構造を担当するHTMLとコンテンツ本文を分離して別々のファイルに記述できるわけです。
Webサイトの各ページ・レイアウトが共通であればテンプレートを使いまわせるので、
HTMLを気にせず、コンテンツ本文（<tt>*.md</tt>）を書くことに専念することができます。

## Markdown処理 ##

さきほどのWebページ表示では「晴天」の前後にアスタリスク（**）が表示されていたことに気付きましたか？
最初の例では<tt>index.md</tt>の内容がそのまま`${r"${content}"}`と置き換わっただけでした。
これでは、テキストをそのまま流し込むことしかできずWebページの表現が乏しくなってしまいます。

そこで登場するのがMarkdown処理です。
<tt>default.ftl</tt>の内容を下記の通りに書き換えてください。
`${r"${content}"}`を`${r"<@markdown>"}`と`${r"</@markdown>"}`で囲みます。
こうすることで、<tt>index.md</tt>の内容がそのまま出力されるのではなく、
Markdown処理を施してから出力されるようになります。

```html default.ftl {.copy}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY>
		<@markdown>${content}</@markdown>
	</BODY>
</HTML>
</#noparse>
```

もう一度、Catalpaで<tt>D:\mysite</tt>を処理してみましょう。
すでに、Catalpaを起動している場合は["更新"]を押すだけです。

![](img/tutorial1-001.webp){width=430 height=194 .shadow}

ブラウザーの表示は以下のようになります。
「晴天」の前後にあったアスタリスク（**）表示が無くなり、代わりに「晴天」の文字が強調されています。

![](img/tutorial1-003.webp){width=430 height=245 .shadow}

出力されたHTMLも確認してみましょう。
<tt>index.md</tt>でアスタリスク（**）で囲んでいた部分が`<strong>`タグとなって「晴天」の文字を強調していることが分かります。

```html index.html
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY>
		<p>本日は<strong>晴天</strong>なり。</p>

	</BODY>
</HTML>
```

Markdown記法で記述された文章をHTMLに変換する、これがMarkdown処理です。
Markdownはプレーン・テキストとしても読みやすく、書きやすい軽量マークアップ言語です。
Markdown記法を使うことでHTMLを直接記述することなく、Webページを作成することができます。

Catalpaで使用できるMarkdown記法は[「Markdown早見表」][]で確認できます。


## YAML front matter ##

Markdownファイル（<tt>.md</tt>）の先頭にはYAML front matterを書くことができます。
YAML front matterはYAML形式で記述可能なデータ・ブロックです。
YAML front matterは、ファイルの先頭行が3つのハイフンで始まり、
3つのハイフンの行で終わります。

<tt>index.md</tt>にYAML front matterを追加してみましょう。

```markdown index.md
---
title: わたしのページ
---

本日は**晴天**なり。
```

先頭の3行がYAML front matterです。
ここでは`title`という名前のデータを定義して、その値を「わたしのページ」としました。
（データの名前は自由に決めることができます。`hoge`でも大丈夫です。）

YAML front matterのデータは
Markdownファイル（<tt>.md</tt>）や、テンプレート・ファイル（<tt>.ftl</tt>）で参照することができます。

<tt>index.md</tt>で`title`データを参照してみましょう。`${r"${title}"}`と記述することで`title`データを参照することができます。


```markdown index.md {.copy}
---
title: わたしのページ
---

本日は**晴天**なり。

このページのタイトルは「${r"${title}"}」です。
```

Catalpaで処理すると結果は以下のようになります。
`${r"${title}"}`の部分が置き換わっていますね。

![](img/tutorial1-004.webp){width=429 height=225 .shadow}

テンプレート・ファイル（<tt>.ftl</tt>）でもデータを参照することができます。
<tt>default.ftl</tt>でも`title`データを参照してみましょう。

```html default.ftl {.copy}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
		<TITLE>${title}</TITLE>
	</HEAD>
	<BODY>
		<@markdown>${content}</@markdown>
	</BODY>
</HTML>
</#noparse>
```

`title`を参照して`<TITLE>`タグが出力されるように4行目を追加してみました。
これを処理するとWebページの表示は以下のようになります。

![](img/tutorial1-005.webp){width=429 height=225 .shadow}

ブラウザーのタブをよく見てみるとタイトルが表示されていることが確認できます。


## <tt>config.yml</tt> ##

すでにYAML front matterにデータを定義できることを学びました。

ところで、タイトルや著者名など同じデータを複数のWebページに出力したいこともありますよね？
そんなとき、それぞれのMarkdownファイル（<tt>.md</tt>）に同じデータを繰り返し定義をしなければならないのは大変です。

Catalpaには、すべてのMarkdownファイル（<tt>.md</tt>）や
テンプレート・ファイル（<tt>.ftl</tt>）から共通で参照できる設定ファイルがあります。
それが<tt>config.yml</tt>です。

<tt>config.yml</tt>はデータ・フォルダーの直下（<tt>D:\mysite</tt>）に配置します。

  - {.tree} <tt>D:\mysite</tt>
      - <tt>templates</tt>
          - <tt>default.ftl</tt>
      - **<tt>config.yml</tt>**
      - <tt>index.md</tt>

```yaml config.yml
---
title: わたしのページ
author: 匿名太郎
---
```

このように、<tt>config.yml</tt>には（YAML front matterと同じように）YAML形式でデータを定義できます。
これで、各Markdownファイル（<tt>.md</tt>）のYAML front matterで`title`を定義しなくても参照できるようになりました。

{.info .deg-3} データ参照の優先順位
:   <tt>config.yml</tt>とMarkdownファイル（<tt>.md</tt>）で同じ名前のデータを定義すると、優先順位に基づくデータ参照ができます。
    たとえば<tt>config.yml</tt>で`title`を定義します。`title`を定義していない<tt>page-A.md</tt>と<tt>page-B.md</tt>は<tt>config.yml</tt>の`title`を参照する、
    <tt>page-C.md</tt>では`tilte`を再定義して<tt>config.yml</tt>の`title`ではなく<tt>page-C.md</tt>で定義した`title`を参照できます。

<tt>config.yml</tt>は、ユーザー定義データを記述するだけでなく、Catalpaの動作制御にも使われます。
このために、`siteurl`や`upload`などCatalpaで予約されているいくつかの名前があります。

## テンプレート・ファイルを指定する ##

ここまでの説明では<tt>default.ftl</tt>という名前のテンプレート・ファイルを使用してきました。
これは、Markdownファイル（<tt>.md</tt>）でテンプレート名を指定しなかった場合に適用される既定のテンプレートです。

<tt>default.ftl</tt>以外のテンプレート・ファイルを用意して、Markdownファイル（<tt>.md</tt>）で任意のテンプレートを指定することもできます。
試しに<tt>sample1.ftl</tt>というテンプレート・ファイルを<tt>templates</tt>フォルダーの下に作成してみましょう。

  - {.tree} <tt>D:\mysite</tt>
      - <tt>templates</tt>
          - <tt>default.ftl</tt>
          - **<tt>sample1.ftl</tt>**
      - <tt>config.yml</tt>
      - <tt>index.md</tt>

中身は以下のようにします。
<tt>default.ftl</tt>とほとんど同じですが、表示したときに区別できるように背景色を薄い青色 `background: lightblue` にしています。

```html sample1.ftl {.copy}
<#noparse>
<!DOCTYPE html>
<HTML>
	<HEAD>
		<META charset="utf-8">
	</HEAD>
	<BODY style="background: lightblue;">
		<@markdown>${content}</@markdown>
	</BODY>
</HTML>
</#noparse>
```

次に<tt>index.md</tt>の修正です。
YAML front matterに`template`という名前のデータを定義して、その値を「sample1」とします。

```markdown index.md {.copy}
---
template: sample1
title: わたしのページ
---

本日は**晴天**なり。

このページのタイトルは「${r"${title}"}」です。
```

これで、このMarkdownファイル（<tt>index.md</tt>）に適用されるテンプレート・ファイルが<tt>sample1.ftl</tt>になります。
Webページを表示してみましょう。

![](img/tutorial1-006.webp){width=430 height=227 .shadow}

背景色が薄い青色になっているので、テンプレート・ファイル<tt>sample1.ftl</tt>が適用されていることが分かります。

{.center .my-3}
[サイドバー付きのレイアウト](tutorial2-sidebar.html){.button .round .hover .next .primary}

