#--sidebar--

  * 日本語組版処理について
      - [基本的な字間](text-layout.html#基本的な字間)
      - [約物が連続する場合の字間](text-layout.html#約物が連続する場合の字間)
      - [行頭の処理](text-layout.html#行頭の処理)
      - [行末の処理](text-layout.html#行末の処理)
      - [文末の区切り約物（疑問符、感嘆符）](text-layout.html#文末の区切り約物（疑問符、感嘆符）)
      - [禁則処理](text-layout.html#禁則処理)
      - [改行文字の除去](text-layout.html#改行文字の除去)
      - [フォントの選び方](text-layout.html#フォントの選び方)



#--content--

[W3C 日本語組版処理の要件（日本語版）]: https://w3c.github.io/jlreq/
[JIS X 4051（日本語文書の組版方法）]: https://kikakurui.com/x4/X4051-2004-02.html
[JIS X 4051]: https://kikakurui.com/x4/X4051-2004-02.html

# 日本語組版処理{.inline-block}について{.inline-block} #

印刷工程で活字を組み合わせて版を作ることを組版《くみはん》といいます。
組版には、印刷物を読みやすく、美しく見せるための字間調整などのルールがあります。
印刷物に限らず、HTMLにおいても適切に文字を組むことで、
より読みやすく、美しいWebページを作ることができます。

Catalpaでは
[W3C 日本語組版処理の要件（日本語版）][]{target="_blank"}
、
[JIS X 4051（日本語文書の組版方法）][]{target="_blank"}
を
参考にして、横組で和文と欧文を混植する際の字間調整をおこなっています。
禁則処理・追い込み・追い出し等はCSS（ブラウザの機能）で指定しています。

## 文章を読みやすく ##

Catalpaの組版処理によってHTMLの表示がどのように変わるのか見てみましょう。

{.left .ml-3}
![](img/layout-sample-01a.webp){width=577 height=26}

{.left .ml-3}
![](img/layout-sample-01b.webp){width=529 height=27}

上の文はフォントをベタ組みした通常のHTML表示、下の文はCatalpaの組版処理によって字間調整されたHTML表示です。
ベタ組みした上の文は文字の間隔が空きすぎていますね。

なぜ、通常のHTML表示では文字の間隔が広くなってしまうのでしょうか？
その理由は、日本語フォントの作りにあります。
本来、句読点や括弧などの約物《やくもの》は全角の半分の幅で組み、
その前後に全角1/2の字間を設けます。これを二分アキといいます。

{.left .ml-3}
![](img/layout-sample-02a.webp){width=12 height=24}&thinsp;
![](img/layout-sample-02b.webp){width=12 height=24}&thinsp;
![](img/layout-sample-02c.webp){width=12 height=24}&thinsp;

これらの半角幅の約物の前後に二分アキを設けて以下のように組みます。

{.left .ml-3}
![](img/layout-sample-03b.webp){width=317 height=54}

ところが、実際の日本語フォントではこれらの約物も全角の幅で作られており、
フォント自体が二分アキに相当する余白を内包してしまっています。

{.left .ml-3}
![](img/layout-sample-02d.webp){width=24 height=24}&thinsp;
![](img/layout-sample-02e.webp){width=24 height=24}&thinsp;
![](img/layout-sample-02f.webp){width=24 height=24}&thinsp; 

このような全角幅で作られた約物でベタ組みすると以下のようになります。

{.left .ml-3}
![](img/layout-sample-03a.webp){width=265 height=26}

あれ？
見た目は同じですね。そうなんです。
約物のフォントは全角幅になっていますが、
始め括弧類は前に余白を含み、終わり括弧類は後に余白を含むように
作られているので、ベタ組みしたときに結果として二分アキ相当になるようになっているのです。

しかし、フォント自体が余白を含むこの方法では約物が連続する場合に不都合が出ます。
日本語組版では、半角約物と二分アキを常に組み合わせるわけではありません。
終わり括弧類に読点が続く場合には二分アキとせずにベタ組みする、といった細かなルールがあるのです。
フォント自体が余白を含んでしまっていると、このような文字種の組み合わせによって字間を変えるルールに対応することができません。

最初の例文をもう一度見てみましょう。今度は赤字で説明を入れました。

{.left .ml-3}
![](img/layout-sample-04a.webp){width=577 height=61}

フォント自体が余白を含んでいることが原因で、文が間延びしてしまっていることが分かります。

{.left .ml-3}
![](img/layout-sample-04b.webp){width=529 height=58}

約物を半角幅として適切に二分アキを入れる（もしくは入れない）ことで、
読みやすい字間になりました。これが日本語組版処理です。


## 基本的な字間 ##

約物のうち、読点類、句点類、始め括弧類、終わり括弧類、中点類の字幅は半角です。
その他の約物（疑問符、ハイフン等）の字幅は全角です。

和字と欧字の字間を四分アキ（全角幅の1/4の字間を空けるもの）とします。
基本的に、アルファベットや数字には半角文字を使うようにしてください。
全角のアルファベットや数字を使った場合は四分アキではなくベタ組みとなります。

{.left .ml-3}
![](img/layout-sample-05a.webp){width=374 height=40}

読点類の後ろを二分アキとします。（約物が連続する場合や行末での例外があります。）

{.left .ml-3}
![](img/layout-sample-05b.webp){width=313 height=41} 

句点類の後ろを二分アキとします。（約物が連続する場合の例外があります。）

{.left .ml-3}
![](img/layout-sample-05c.webp){width=313 height=41}

始め括弧類の前を二分アキ、終わり括弧類の後ろを二分アキとします。（約物が連続する場合や行頭・行末での例外があります。）
丸括弧は全角と半角のどちらにもありますが、基本的に全角文字を使うようにしてください。半角文字の括弧を使った場合は適切なアキが入りません。

{.left .ml-3}
![](img/layout-sample-05d.webp){width=337 height=41}

中点類の前後は四分アキとします。（約物が連続する場合はや行頭・行末での例外があります。）

{.left .ml-3}
![](img/layout-sample-05e.webp){width=313 height=41}


## 約物が連続する場合の字間 ##

読点類・句点類の後ろに、終わり括弧類が続く場合、ベタ組みとします。

{.left .ml-3}
![](img/layout-sample-05f.webp){width=241 height=42}

終わり括弧類の後ろに、読点類・句点類が続く場合、ベタ組みとします。

{.left .ml-3}
![](img/layout-sample-05g.webp){width=217 height=42}

読点類・句点類の後ろに、始め括弧類が続く場合、二分アキとします。

{.left .ml-3}
![](img/layout-sample-05h.webp){width=205 height=41}

終わり括弧類の後ろに、始め括弧類が続く場合、二分アキとします。

{.left .ml-3}
![](img/layout-sample-05i.webp){width=385 height=41}

始め括弧類の後ろに、始め括弧類が続く場合、ベタ組みとします。

{.left .ml-3}
![](img/layout-sample-05j.webp){width=325 height=42}

終わり括弧類の後ろに、終わり括弧類が連続する場合、ベタ組みとします。

{.left .ml-3}
![](img/layout-sample-05k.webp){width=452 height=42}

終わり括弧類の後ろに、中点類が続く場合、四分アキとします。

{.left .ml-3}
![](img/layout-sample-05l.webp){width=181 height=41}

中点類の後ろに、始め括弧類が続く場合、四分アキとします。

{.left .ml-3}
![](img/layout-sample-05m.webp){width=181 height=41}


## 行頭の処理 ##

行頭の始め括弧類や中点類の配置にはいくつかの方法がありますが、
Catalpaではアキ量0で組む天ツキを採用しています。
（[JIS X 4051][]{target="_blank"}と同じです。）

{.left .ml-3}
![](img/layout-sample-06a.webp){width=208 height=89}


## 行末の処理 ##

行末の約物についても配置方法がいくつかあります。
Catalpaでは句点類以外の約物（読点類、終わり括弧類、中点類）はアキ量0で組む地ツキを採用しています。
（[JIS X 4051][]{target="_blank"}と同じです。）

読点類、終わり括弧類、中点類の場合、行末では二分アキを確保しません。

{.left .ml-3}
![](img/layout-sample-06b.webp){width=208 height=91}

句点類は、行末でも後ろに二分アキを確保します。

{.left .ml-3}
![](img/layout-sample-06c.webp){width=208 height=89}


## 文末の区切り約物（疑問符、感嘆符） ##

疑問符、感嘆符のことを区切り約物といいます。
区切り約物が文末にある場合、後ろを全角アキ（全角幅と同じ字間を空けるもの）とします。

「行末」と「文末」の違いに注意してください。
行末とは文字を組んだ結果として決まる物理的な行の終わりです。
文末は文の終わりです。一般的に、文は句点で終わりますが、
句点の代わりに疑問符や感嘆符が使われることもあります。
疑問符・感嘆符を句点の代わりとして文末に置く場合は、
次の文との区切りが分かりやすいように全角アキを入れます。

文末ではなく文中で疑問符や感嘆符が使われることもあります。
文中で疑問符・感嘆符が使われた場合は後ろを全角アキとせずにベタ組みします。

しかし、疑問符・感嘆符が文中に置かれたものか、
文末に置かれたものかをコンピューターが自動的に判断するのは難しいのです。
そこで、文末の疑問符・感嘆符なのか、
文中の疑問符・感嘆符なのかを執筆者が指定できる仕組みを用意しました。

疑問符・感嘆符の直後に改行がない場合、その疑問符・感嘆符は文中と解釈されます。

```markdown 疑問符の直後で改行しなければ文中として解釈される
頭の中が？マークだらけになってしまった。
```

{.left .ml-3}
![](img/layout-sample-07b.webp){width=482 height=40}

疑問符・感嘆符の直後で改行すると、その疑問符・感嘆符は文末と解釈されます。

```markdown 疑問符の直後で改行すると文末として解釈される
組版に興味が出てきましたか？
それは良かった。
```

{.left .ml-3}
![](img/layout-sample-07a.webp){width=554 height=41}

この仕組みで自動的に追加される全角アキは（全角スペースとは異なり）行末では消滅するようになっています。
執筆者が手動で疑問符・感嘆符の後ろに全角スペースを書いてしまうと、
疑問符・感嘆符が行末に来たときに、後ろの全角スペースが次の行の行頭に表示されてしまいますのでご注意ください。


## 禁則処理 ##

以下のCSSプロパティによって禁則処理をおこないます。
これらのCSSプロパティ指定により、
行頭は句読点や終わり括弧類から始まらない、行末は始め括弧類で終わらない等の禁則処理がおこなわれます。
（CSSで実現できるため、Catalpaは禁則処理について特別な処理をしていません。）

  * `overflow-wrap: break-word;`
  * `word-break: break-word;`


## 改行文字の除去 ##

MarkdownやHTMLでは改行文字は半角スペースと同じものとして扱われます。
たとえば、以下のようなMarkdownソースコードを書いてみます。

```markdown input-en.md
Source code is the
ultimate documentation.
```

このMarkdownは以下のHTMLを出力します。
theとultimateの間が空いていますね。

```html output-en.html
<p>Source code is the ultimate documentation.</p>
```

改行文字がスペースとして扱われるという仕組みは英文ではとても便利ですが、
日本語の場合はどうなるでしょうか？

```markdown input-ja.md
ソースコードは究極の
ドキュメントです。
```

これを一般的なMarkdownプロセッサーで処理すると以下のようなHTMLが出力されます。

```html output-ja.html
<p>ソースコードは究極の ドキュメントです。</p>
```

改行文字だったところに余白ができてしまっていますね。
改行文字をスペースとして扱うという仕組みは日本語には向いていないようです。

Catalpaでは和字と和字の間にある改行文字を取り除く処理がおこなわれるため、
不自然な余白が入ることがありません。

```html output-ja.html（Catalpaの出力）
<p>ソースコードは究極のドキュメントです。</p>
```

もちろん、無条件に改行文字を取り除いているわけではなく、
欧字に隣接する改行文字はそのまま残し、
和字と和字の間の改行文字のみを除去しています。
そのため、英文ではMarkdown/HTMLの基本通り、改行文字をスペースとして使用できます。


## フォントの選び方 ##

和文等幅+欧文プロポーショナル構成のフォントがCatalpaの日本語組版処理に適しています。

{.info .deg-1 .block .pr-2} 和文等幅 + 欧文プロポーショナル
: * メイリオ
  * IPAexゴシック
  * IPAex明朝
  * Noto Sans CJK JP、源ノ角ゴシック
  * Noto Serif CJK JP、源ノ明朝
  * 游ゴシック
  * 游明朝
  * UDデジタル教科書体 NP
  * ヒラギノ角ゴ

以下に挙げるフォントは、欧文等幅もしくは和文プロポーショナルであるためCatalpaでの日本語組版には適していません。
ただし、等幅フォントはプロポーショナルな欧文フォントと組み合わせることで適切に組むことができます。
等幅フォントを使用する場合には、`font-family`に欧文フォントも併せて指定することをオススメします。

{.warning .deg-1 .block .pr-2} 等幅のフォント例（単体での使用は適していません）
: * ＭＳ ゴシック
  * ＭＳ 明朝
  * IPAゴシック
  * IPA明朝
  * UDデジタル教科書体 N
  * BIZ UDゴシック
  * BIZ UD明朝

<!---->
{.caution .deg-1 .block .pr-2} プロポーショナルのフォント例（適していません）
: * ＭＳ Ｐゴシック
  * ＭＳ Ｐ明朝
  * MS UI Gothic
  * IPA Pゴシック
  * IPA P明朝
  * Yu Gothic UI
  * UDデジタル教科書体 NK
  * BIZ UDPゴシック
  * BIZ UDP明朝


{.center}
[トップページに戻る](/){.button .round .hover .previous .primary .my-3}

