---
title: Markdown 早見表
description: flexmark / catalpa で使える Markdown 記法をまとめた早見表（チートシート）です。
---

#--css--

#sticky-header {
	position: sticky;
	top: -1px;
	z-index: 1;
	margin-block-start: 0.5em;
	margin-inline-start: calc(0px - var(--content-padding-left) - var(--content-padding-left-adjust));
	margin-inline-end: calc(0px - var(--content-padding-right) - var(--content-padding-right-adjust));
	padding: 1px;
	box-shadow: 0 0.5em 0 var(--main-background-color);
}

#--content--

{.nav #sticky-header}
[見出し](#見出し)
[改行](#改行)
[文字装飾](#文字装飾)
[リスト](#リスト)
[タスク・リスト](#タスク・リスト)
[定義リスト](#定義リスト)
[リンク](#リンク)
[画像](#画像)
[水平線](#水平線)
[テーブル](#テーブル)
[引用](#引用)
[コード・ブロック](#コードブロック)
[付箋](#付箋)
[属性](#属性)
[HTML](#HTML)



[flexmark]: https://github.com/vsch/flexmark-java
[CommonMark Spec 0.28]: https://spec.commonmark.org/0.28/

# Markdown{.inline-block}早見表{.inline-block} #


このページでは、Catalpaで使用できるMarkdown記法を紹介します。
CatalpaはMarkdownプロセッサーとして[flexmark][]{target="_blank"}を採用していますので、
[flexmark][]{target="_blank"}のサポートしているMarkdown記法を使用できます。
[flexmark][]{target="_blank"}は[CommonMark Spec 0.28][]{target="_blank"}に準拠するように設計されています。

## 見出し ##

行頭を`#`で始めると見出しになります。出力されるタグは`#`の数に応じて、`<h1>`～`<h6>`となります。
見出しの外観はCSSによって装飾されます。

<pre><code style="font-family:monospace;color:#a6e22e;"># 見出しレベル 1

## 見出しレベル 2

### 見出しレベル 3

#### 見出しレベル 4

##### 見出しレベル 5

###### 見出しレベル 6
</code></pre>

行末に`#`を追加することもできます。行頭の`#`の数で`<h1>`～`<h6>`が決まるため、行頭と行末の`#`の数は一致していなくても問題ありません。

<pre><code style="font-family:monospace;color:#a6e22e;"># 見出しレベル 1 #

## 見出しレベル 2 ##

### 見出しレベル 3 ###

#### 見出しレベル 4 ####

##### 見出しレベル 5 ######

###### 見出しレベル 6 ######
</code></pre>


見出しレベル 1と見出しレベル 2には、タイトルの下部に`=`または`-`で線を引く記法も使えます。

<pre><code style="font-family:monospace;color:#a6e22e;">見出しレベル 1
==============

見出しレベル 2
--------------
</code></pre>


## 改行 ##

行末に半角スペースを2つ置くと強制改行できます。（下記では半角スペースを水色のアンダースコア&#x2423;で表示しています。）

<pre><code style="font-family:monospace;color:#F2F2F2">1行目の文章<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;</span>
2行目の文章
</code></pre>

ブランク文字（半角スペース・全角スペース・タブ）のみを含む行は垂直スペースになります。
ブランク文字のみを含む行が1つの場合、高さ0の垂直スペースになります。
高さは0ですが、前のマージンと後のマージンの相殺が無効になるため、垂直スペースとして働きます。
ブランク文字はいくつ入力しても同じです。（垂直スペースが増えることはありません。）

<pre><code style="font-family:monospace;color:#F2F2F2">1行目の文章
<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;&#x2423;&#x2423;</span>
2行目の文章
</code></pre>

ブランク文字のみを含む行が連続で2つ以上になると振る舞いが変わります。
最初のブランク行は高さ0で前後のマージン相殺を無効化する効果があります。
2つ目以降のブランク行は、半角スペース 1つあたり 0.25em の高さを持つ余白として働きます。
半角スペース 4つなら 0.25em × 4 = 1em の垂直スペースになります。

<pre><code style="font-family:monospace;color:#F2F2F2">1行目の文章
<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;&#x2423;&#x2423;</span>
<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;&#x2423;&#x2423;</span>
<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;&#x2423;&#x2423;</span>
2行目の文章
</code></pre>




## 文字装飾 ##

文字を1つのアスタリスク`*`（もしくは1つのアンダースコア`_`）で囲むとイタリック表示になります。出力されるタグは`<i>`ではなく、`<em>`です。
また、メイリオなどイタリック書体を持たないフォントでは効果がありません。

<pre><code style="font-family:monospace;color:#66d9ef;">*イタリック*
</code></pre>

文字を2つのアスタリスク`*`（もしくは2つのアンダースコア`_`）で囲むとボールド表示になります。出力されるタグは`<b>`ではなく、`<strong>`です。

<pre><code style="font-family:monospace;color:#66d9ef;">**ボールド**
</code></pre>

文字を3つのアスタリスク`*`（もしくは3つのアンダースコア`_`）で囲むとイタリック・ボールド表示になります。出力されるタグは`<em><strong>`です。

<pre><code style="font-family:monospace;color:#66d9ef;">***イタリック・ボールド***
</code></pre>

文字を2つのチルダ`~`で囲むと打消し線が表示されます。出力されるタグは`<del>`です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">~~打消し線~~
</code></pre>
<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

~~打消し線~~

</div></div>

文字を1つのバッククォート<code>`</code>で囲むとインライン・コードとして表示されます。
出力されるタグは<code>&lt;code&gt;</code>です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#FD971F;">`コード`
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

`コード`

</div></div>

文字を`["`と`"]`で囲むとメニューボタンの外観で表示されます。出力されるタグは`button`クラス属性の付いた`<samp>`です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74">"ファイル"</span>]
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

["ファイル"] → ["開く"] を選択して ["OK"] ボタンを押下します。

</div></div>

文字を`['`と`']`で囲むとキーボタンの外観で表示されます。出力されるタグは`<kbd>`です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74">'Ctrl'</span>]
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

['Ctrl'] + ['V'] を押すとクリップボードの内容がペーストされます。

</div></div>

文字をシングルクォート`'`で囲むと、開始が`&lsquo;`に、終了が`&rsquo;`に変換されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">'シングルクォート'
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

'シングルクォート'

</div></div>

文字をダブルクォート`"`で囲むと、開始が`&ldquo;`に、終了が`&rdquo;`に変換されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">"ダブルクォート"
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

"ダブルクォート"

</div></div>

文字を`<<`と`>>`で囲むと、開始が`&laquo;`に、終了が`&raquo;`に変換されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;"><<アングルクォート>>
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

<<アングルクォート>>

</div></div>

3つのピリオド`...`が`&hellip;`に変換されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">続く...
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

続く...

</div></div>

2つのハイフン`--`が`&ndash;`に変換されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">--
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

--

</div></div>


## リスト ##

行頭にアスタリスク`*`を付けると箇条書きリストになります。`*`の代わりに`+`や`-`を使うこともできます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#e6db74;">* 箇条書きリストアイテム 1
* 箇条書きリストアイテム 2
* 箇条書きリストアイテム 3
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

* 箇条書きリストアイテム 1
* 箇条書きリストアイテム 2
* 箇条書きリストアイテム 3

</div></div>

行頭に数字と`.`を付けると番号付きリストになります。先頭行の番号は指定した数値になります。
2行目以降の番号は指定した数値ではなく自動的に連番となります。（たとえば、先頭行を`4.`とした場合、番号は必ず 4, 5, 6, …と振られていきます。）

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#e6db74;">1. 番号付きリストアイテム 1
2. 番号付きリストアイテム 2
3. 番号付きリストアイテム 3
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

1. 番号付きリストアイテム 1
2. 番号付きリストアイテム 2
3. 番号付きリストアイテム 3

</div></div>

2つ以上の半角スペース（またはタブ）で字下げすることにより、リストを入れ子にすることができます。
入れ子にするリストの行頭の記号を変えても大丈夫です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#e6db74;">* 大分類1
    + 中分類A
        - 小分類w
        - 小分類x
    + 中分類B
        - 小分類y
* 大分類2
    + 中分類C
        - 小分類z
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

* 大分類1
    + 中分類A
        - 小分類w
        - 小分類x
    + 中分類B
        - 小分類y
* 大分類2
    + 中分類C
        - 小分類z

</div></div>


## タスク・リスト ##

リストに`[x]`または`[ ]`を加えるとタスク・リストになります。
`[x]`にはタスクが完了したチェックマークが表示されます。`[ ]`にはタスクが完了していない未完了マークが表示されます。
表示されるマークはCSSでカスタマイズ可能です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#e6db74;">* [x] 完了したタスク1
* [ ] 未完了のタスク
* [x] 完了したタスク2
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

* [x] 完了したタスク1
* [ ] 未完了のタスク
* [x] 完了したタスク2

</div></div>


## 定義リスト ##

2行目の行頭をコロン`:`にして1つ以上の半角スペース（またはタブ）を続けると、定義リストになります。
出力されるタグは`<dl>`、`<dt>`、`<dd>`です。`:`の直前の行が定義語`<dt>`、
`:`以降が定義内容`<dd>`になります。複数の定義を並べる場合は空行を挟みます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">イチゴ
:   バラ科の多年草。食用として供されている部分は花托であり
    果実ではない。イチゴにとっての果実は一見して種子に見える
    一粒一粒であり、正確には痩果という。

ブドウ
:   ブドウ科のつる性落葉低木である。また、その果実のこと。
    葉は両側に切れ込みのある15-20cmほどの大きさで、
    穂状の花をつける。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

イチゴ
:   バラ科の多年草。食用として供されている部分は花托であり
    果実ではない。イチゴにとっての果実は一見して種子に見える
    一粒一粒であり、正確には痩果という。

ブドウ
:   ブドウ科のつる性落葉低木である。また、その果実のこと。
    葉は両側に切れ込みのある15-20cmほどの大きさで、
    穂状の花をつける。

</div></div>


## リンク ##

以下の例のように`[ ]`と`( )`を組み合わせてリンクを作成できます。
`[ ]`にリンク・テキストを、`( )`内にリンクURLを記述します。URLに続けて文字列を指定するとマウスカーソルを合わせたときにホバー表示されます。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74;">Link Text</span>](relative/path/other.html)
[<span style="color:#e6db74;">Click Here</span>](/root/path/other.html)
[<span style="color:#e6db74;">Google</span>](http://www.google.co.jp/)
[<span style="color:#e6db74;">Google</span>](http://www.google.co.jp/ <span style="color:#e6db74;">"Hover Text"</span>)
</code></pre>

`[ ]:`ではじまる行はリンク定義になります。
リンク定義は同じリンクURLを繰り返し使う場合に便利です。
同じファイル内の任意の場所で定義できます。リンク定義自体は表示されません。
`[ ]`の中のテキストがリンクIDになります。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#ae81ff;">YAHOO_LINK_ID</span>]: http://www.yahoo.co.jp/
[<span style="color:#ae81ff;">Amazon</span>]: http://www.amazon.co.jp/ <span style="color:#e6db74;">"hover text"</span>
</code></pre>

[YAHOO_LINK_ID]: http://www.yahoo.co.jp/
[Amazon]: http://www.amazon.co.jp/ "hover text"

リンクが定義されている場合、以下のようにURLの代わりにリンクIDを指定してリンクを作成することができます。
1つめの`[ ]`にリンクテキスト、2つめの`[ ]`に定義したリンクIDを指定します。
リンクIDを省略して`[]`とした場合（または2つめの`[]`を省略した場合）リンクIDとしてリンクテキストが使用されます。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74;">Yahoo</span>][<span style="color:#ae81ff;">YAHOO_LINK_ID</span>]
[<span style="color:#e6db74;">Amazon</span>][]
[<span style="color:#e6db74;">Amazon</span>]
</code></pre>

リンク先を新しいウィンドウまたはタブで開くようにする場合は、`{target="_blank"}`を追加します。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74;">Google</span>](http://www.google.co.jp/){target="_blank"}
[<span style="color:#e6db74;">Google</span>](http://www.google.co.jp/ <span style="color:#e6db74;">"Hover Text"</span>){target="_blank"}
</code></pre>

リンクテキストとしてリンクURLをそのまま使う場合はURLを`<`と`>`で囲みます。
`<`、`>` の代わりに `[`、`]`を使うこともできます。

<pre><code style="font-family:monospace;color:#F2F2F2;">&lt;http://www.example.com/&gt;
[<span style="color:#e6db74;">http://www.example.com/</span>]
</code></pre>

メールアドレスを`<`と`>`で囲むと、メーラーを起動するためのmailtoスキームのリンクになります。
メールアドレスを指定する場合は`[`、`]`を使うことはできません。

<pre><code style="font-family:monospace;color:#F2F2F2;">&lt;nobody@example.com&gt;
</code></pre>


## 画像 ##

リンク書式の先頭に`!`を付けると画像になります。

<pre><code style="font-family:monospace;color:#F2F2F2;">![](relative/path/image.png)
![](/root/path/image.png)
![](http://www.example.com/image.png)
![](http://www.example.com/image.png <span style="color:#e6db74;">"Hover Text"</span>)
![<span style="color:#e6db74;">Alt Text</span>](http://www.example.com/image.png <span style="color:#e6db74;">"hover text"</span>)
</code></pre>

リンクのテキストに画像を指定すると画像リンクになります。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74;">![](img/sample.png)</span>](http://www.example.com/)
</code></pre>

段落に画像のみが含まれている場合、画像は中央寄せで表示されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png)
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png)

</div></div>

同じ段落内の画像は横に並べて表示されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png)
![](img/sample.png)
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png)
![](img/sample.png)

</div></div>

空行を入れて段落を分けると画像は横に並ばなくなります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png)

![](img/sample.png)
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png)

![](img/sample.png)

</div></div>

`{.left}`や`{.right}`を付加することで、画像を左寄せまたは右寄せで表示できます。
間に必ず1つ以上の半角スペースを入れる必要があります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png) {.right}
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png) {.right}

</div></div>

`{.border}`を付加することで、画像にボーダー・ラインを付けることができます。
間に半角スペースを入れずに詰めて記述する必要があります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png){.border}
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png){.border}

</div></div>


`{.shadow}`を付加することで、画像にドロップ・シャドウを付けることができます。
間に半角スペースを入れずに詰めて記述する必要があります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">![](img/sample.png){.shadow}
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

![](img/sample.png){.shadow}

</div></div>



## 水平線 ##

3つ以上の`-`（または`*`）と任意の数の半角スペースで構成される行は水平線になります。出力されるタグは`<hr>`です。

<pre><code style="font-family:monospace;color:#F2F2F2;">---

- - -

-- -- -- -- --

****

** ** **

*************
</code></pre>


## テーブル ##

以下の記述でテーブルを表示することができます。2行目の罫線にコロンを`:`含めることで、左寄せ、右寄せ、中央寄せを制御できます。
左側に`:`を配置すると左寄せ、右側に`:`を配置すると右寄せ、左側と右側の両方に`:`を配置すると中央寄せになります。`:`を省略すると左寄せになります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |

</div></div>

ヘッダー行のないテーブルを作成することもできます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |

</div></div>

<#--
テーブルは既定で中央に表示されますが、`{.left}`または`{.right}`を付加することでテーブルの表示を左または右に寄せることができます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |
{.left}
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1    | Apple         | US          |      $604.30B |
| 2    | Google        | US          |      $518.92B |
| 3    | Microsoft     | US          |      $436.83B |
{.left}

</div></div>
-->

以下のように改行を入れて記述することもできます。セルの中に長い文章を書く時に便利です。
各行は`|`または複数の半角スペースで始まる必要があります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1
| Apple
| US
| $604.30B
|
| 2
| Google
| US
| $518.92B
|
| 3
| Microsoft
| US
| $436.83B
|
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

| 列 1 | 列 2 (左寄せ) | 列 3 (中央) | 列 4 (右寄せ) |
|------|:--------------|:-----------:|--------------:|
| 1
| Apple
| US
| $604.30B
|
| 2
| Google
| US
| $518.92B
|
| 3
| Microsoft
| US
| $436.83B
|

</div></div>


## 引用 ##

行頭を`>`にすると引用になります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#A5A18F;">> 吾輩は猫である。名前はまだ無い。どこで生れたか
> とんと見当がつかぬ。何でも薄暗いじめじめした所で
> ニャーニャー泣いていた事だけは記憶している。
> 吾輩はここで始めて人間というものを見た。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

> 吾輩は猫である。名前はまだ無い。どこで生れたか
> とんと見当がつかぬ。何でも薄暗いじめじめした所で
> ニャーニャー泣いていた事だけは記憶している。
> 吾輩はここで始めて人間というものを見た。

</div></div>


引用は入れ子にすることができます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#A5A18F;">> 『吾輩は猫である』は、夏目漱石の長編小説である。1905年1月、
> 『ホトトギス』に発表され、好評を博したため、翌1906年8月まで
> 継続した。冒頭は次の通り。
> 
> > 吾輩は猫である。名前はまだ無い。どこで生れたか
> > とんと見当がつかぬ。何でも薄暗いじめじめした所で
> > ニャーニャー泣いていた事だけは記憶している。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

> 『吾輩は猫である』は、夏目漱石の長編小説である。1905年1月、
> 『ホトトギス』に発表され、好評を博したため、翌1906年8月まで
> 継続した。冒頭は次の通り。
> 
> > 吾輩は猫である。名前はまだ無い。どこで生れたか
> > とんと見当がつかぬ。何でも薄暗いじめじめした所で
> > ニャーニャー泣いていた事だけは記憶している。

</div></div>


## コード・ブロック ##

行頭に4つのスペースもしくはタブを入れるとコードブロックとして認識されます。

<pre><code style="font-family:monospace;color:#F2F2F2;">    int main(int argc, char* argv[])
    {
        printf("Hello, World!!\n");
        return 0;
    }
</code></pre>

3つのバッククォート<code>```</code>、または、3つのチルダ<code>~~~</code>で囲んだ場合もコードブロックとして認識されます。

<pre><code style="font-family:monospace;color:#F2F2F2;">```
int main(int argc, char* argv[])
{
    printf("Hello, World!!\n");
    return 0;
}
```
</code></pre>


<code>```</code>または<code>~~~</code>を使う形式では言語名を指定することができます。
いくつかの言語では自動的にコード・ハイライトが適用され色が着きます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```

</div></div>

言語名の後に半角スペースを置いてタイトルを指定できます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```

</div></div>


`{.copy}`を付加するとコード・ブロックの内容をクリップボードにコピーするボタンが表示されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java {.copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java {.copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```

</div></div>

`{.line-number}`を付加すると行番号が表示されます。

  * 行番号は必ず1から始まります。  
    開始行番号を指定することはできません。

  * 行番号の最大値は999です。  
    1,000行以上のコードに`{.line-number}`を指定しないでください。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java {.line-number .copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java {.line-number .copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```

</div></div>


`{.light}`を付加するとコードブロックがライトカラーになります。（指定しない場合の既定値はダークカラーです。）

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java {.light .line-number .copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java {.light .line-number .copy}
public class Hello {
    public static void main(String[] args) {
        System.out.println("Hello, Java!!");
        return;
    }
}
```

</div></div>


コード・ブロックは既定で自動的に行を折り返します。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java
public class Hello {
    public static void main(String[] args) {
        System.out.println("コードブロックの折り返しについて。コードブロックの横幅に収まらない長い行は自動的に右端で折り返されます。");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java
public class Hello {
    public static void main(String[] args) {
        System.out.println("コードブロックの折り返しについて。コードブロックの横幅に収まらない長い行は自動的に右端で折り返されます。");
        return;
    }
}
```

</div></div>


`{.scroll}`を付加すると自動折り返しが無効になり、必要に応じて水平スクロールバーが表示されるようになります。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">```java Hello.java {.scroll}
public class Hello {
    public static void main(String[] args) {
        System.out.println("{.scroll}を指定すると折り返しが無効になりコードブロックに水平スクロールバーが表示されるようになります。");
        return;
    }
}
```
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em;">

```java Hello.java {.scroll}
public class Hello {
    public static void main(String[] args) {
        System.out.println("{.scroll}を指定すると折り返しが無効になりコードブロックに水平スクロールバーが表示されるようになります。");
        return;
    }
}
```

</div></div>



コード・ハイライティングに対応している言語名は以下の通りです。

  * apache / apacheconf
  * bash / sh / zsh
  * cpp / c / cc / h / c++ / h++ / hpp
  * cs / csharp
  * css
  * diff / patch
  * groovy
  * http / https
  * ini / toml
  * java / jsp
  * javascript / js / jsx
  * json
  * makefile / mk / mak
  * objectivec / mm / objc / obj-c
  * perl / pl / pm
  * php / php3 / php4 / php5 / php6
  * python / py / gyp
  * ruby / rb / gemspec / podspec / thor / irb
  * scala
  * shell / console
  * xml / html / xhtml / rss / atom / xjb / xsd / xsl / plist
  * yaml / yml


## 付箋 ##

定義リストに`{.note}`、`{.tip}`、`{.info}`、`{.warning}`、`{.caution}`を付加すると、付箋のような外観で表示されます。長い文章は自動的に折り返されます。任意の位置で折り返したい場合は行末に半角スペースを2つ記述します。
（下記では半角スペースを水色のアンダースコア&#x2423;で表示しています。）

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">{.note} メモ
:   Markdownはとても便利です。<span style="letter-spacing:-2px;color:#66d9ef;">&#x2423;&#x2423;</span>
    複数行に分けて書くこともできます。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 0.5em 1em;">

{.note .mr-2} メモ
:   Markdownはとても便利です。  
    複数行に分けて書くこともできます。

<!---->
{.tip .mr-2} ヒント
: `{.tip}`を指定するとこうなります。

<!---->
{.info .mr-2} 情報
: `{.info}`を指定するとこうなります。

<!---->
{.warning .mr-2} 注意
: `{.warning}`を指定するとこうなります。

<!---->
{.caution .mr-2} 警告
: `{.caution}`を指定するとこうなります。

</div></div>


付箋を連続で書くときは、付箋と付箋の間にコメントタグ `<!---->`を配置して区切ります。
タグで区切らないと連結された1つの付箋として表示されてしまいます。
定義リストに続けて、付箋を書くときもコメントタグを配置して区切ってください。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">{.info} 情報1
:   複数の付箋を連続で書くと連結されてしまいます。

<span style="color:#87846f">&lt;!----&gt;</span>
{.info} 情報2
:   連結を防ぐためには付箋と付箋の間にコメントタグを挟みます。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 0.5em 1em;">

{.info} 情報1
:   複数の付箋を連続で書くと連結されてしまいます。

<!---->
{.info} 情報2
:   連結を防ぐためには付箋と付箋の間にコメントタグを挟みます。

</div></div>



付箋のタイトルを省略することもできます。

<pre style="margin-bottom: 0";><code style="font-family:monospace;color:#F2F2F2;">{.info}
:   これはタイトルなしの付箋です。<span style="letter-spacing:1px;color:#66d9ef;">__</span>
    コンパクトになります。
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 0.5em 1em;">

{.info}
:   これはタイトルなしの付箋です。  
    コンパクトになります。

</div></div>

## 属性 ##

`{ }` を使ってHTML要素に任意の属性を付加することができます。

<pre><code style="font-family:monospace;color:#F2F2F2;">[<span style="color:#e6db74;">Google</span>](http://www.google.co.jp/){target="_blank"}
</code></pre>

上記はリンク先を新しいウィンドウで開く例です。
`{target="_blank"}`が付加されていることで、直前のMarkdownを変換した結果のHTML要素に属性が付加されます。

`{target="_blank"}`を指定しなかった場合の出力

<pre><code style="font-family:monospace;color:#F2F2F2;">&lt;<span style="color:#f92672;">a</span> <span style="color:#a6e22e;">href</span>=<span style="color:#e6db74;">http://www.google.co.jp/"</span>&gt;Google&lt;/<span style="color:#f92672;">a</span>&gt;
</code></pre>

`{target="_blank"}`を指定した場合の出力

<pre><code style="font-family:monospace;color:#F2F2F2;">&lt;<span style="color:#f92672;">a</span> <span style="color:#a6e22e;">href</span>=<span style="color:#e6db74;">http://www.google.co.jp/"</span> <span style="color:#a6e22e;">target</span>=<span style="color:#ebdb74;">"_blank"</span>&gt;Google&lt;/<span style="color:#f92672;">a</span>&gt;
</code></pre>

`{attr="value"}`の形式で属性名（attr）と属性値（value）を指定します。

  * `id`属性を指定する場合は、`{id="myname"}`の代わりに`{#myname}`と短縮して書くこともできます。
  * `class`属性を指定する場合は、`{class="foobar"}`の代わりに`{.foobar}`と短縮して書くこともできます。
  * 複数の属性を指定する場合は半角スペースで区切ります。  
    （例）`{attr1="valueA" attr2="valueB" #myname .foobar}`


前述の定義リストを付箋の外観に変える`{.note}`という記述は、
実は定義リストの`<DL>`要素に`class="note"`属性を追加しているのです。
このクラス属性に合わせて外観が変わるようにCSSが定義されていて外観が付箋のように変化します。

これを自分で応用して、HTML要素に任意の属性を追加して、CSSと連動して外観を変えるといったこともできます。


## HTML ##

Markdownの中に直接HTMLを書くこともできます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">&lt;div style="text-align:center"&gt;
  Happy birthday!
&lt;/div&gt;
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 1em 1em;">

<div style="text-align:center">
  Happy birthday!
</div>

</div></div>

ただし、HTMLタグの中でMarkdown記法を使うことはできません。下記の例では、Markdown記法の`**`を使っていますが、ボールド表示にはならず、そのまま`**`が表示されます。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">&lt;div style="text-align:center"&gt;
  **Happy** birthday!
&lt;/div&gt;
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 1em 1em;">

<div style="text-align:center">
  **Happy** birthday!
</div>

</div></div>

空行を入れてHTMLタグとMarkdown記述の段落を分けると、Markdown記法が有効になります。
ただし、`<p>`タグが挿入されることに注意してください。既定で`<p>`タグはブロック要素です。

<pre style="margin-bottom: 0;"><code style="font-family:monospace;color:#F2F2F2;">&lt;div style="text-align:center"&gt;

  **Happy** birthday!

&lt;/div&gt;
</code></pre>

<div style="border: 1px solid #808080; border-top: none;">
<h6 style="margin: 0 0.5em;">表示例</h6><div style="padding: 0 1em 1em 1em;">

<div style="text-align:center">

  **Happy** birthday!
</div>

</div></div>

{.center .my-3}
[トップページに戻る](/){.button .round .hover .previous .primary}

