/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.beans.value.ChangeListener;

@FunctionalInterface
public interface SilentChangeListenerWithoutObservable<T> {
    public void changed(T var1, T var2) throws Exception;

    public static <T> ChangeListener<T> wrap(SilentChangeListenerWithoutObservable<T> listener) {
        return (observable, oldValue, newValue) -> {
            try {
                listener.changed(oldValue, newValue);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                } else {
                    SilentChangeListenerWithoutObservable.rethrow(e);
                }
                return;
            }
        };
    }

    public static void rethrow(Throwable throwable) {
        SilentChangeListenerWithoutObservable.rethrow0(throwable);
    }

    public static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }
}

