/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;

public class TaskListItemBlockPreProcessor
implements BlockPreProcessor {
    public TaskListItemBlockPreProcessor(DataHolder options) {
    }

    public void preProcess(ParserState state, Block block) {
        ListItem listItem;
        BasedSequence markerSuffix;
        if ((block instanceof BulletListItem || block instanceof OrderedListItem) && ((markerSuffix = (listItem = (ListItem)block).getMarkerSuffix()).matches((CharSequence)"[ ]") || markerSuffix.matches((CharSequence)"[x]") || markerSuffix.matches((CharSequence)"[X]"))) {
            TaskListItem taskListItem = new TaskListItem(listItem);
            taskListItem.setTight(listItem.isOwnTight());
            listItem.insertBefore((Node)taskListItem);
            listItem.unlink();
            state.blockAdded((Block)taskListItem);
            state.blockRemoved((Block)listItem);
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(BulletListItem.class);
            set.add(OrderedListItem.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        public BlockPreProcessor apply(ParserState state) {
            return new TaskListItemBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

