/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.definition.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DefinitionNodeFormatter
implements NodeFormatter {
    private final FormatOptions options;
    private final ListOptions listOptions;

    public DefinitionNodeFormatter(DataHolder options) {
        this.options = new FormatOptions(options);
        this.listOptions = ListOptions.getFrom((DataHolder)options);
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(DefinitionList.class, (CustomNodeFormatter)new CustomNodeFormatter<DefinitionList>(){

            public void render(DefinitionList node, NodeFormatterContext context, MarkdownWriter markdown) {
                DefinitionNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(DefinitionTerm.class, (CustomNodeFormatter)new CustomNodeFormatter<DefinitionTerm>(){

            public void render(DefinitionTerm node, NodeFormatterContext context, MarkdownWriter markdown) {
                DefinitionNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(DefinitionItem.class, (CustomNodeFormatter)new CustomNodeFormatter<DefinitionItem>(){

            public void render(DefinitionItem node, NodeFormatterContext context, MarkdownWriter markdown) {
                DefinitionNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(DefinitionList node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
    }

    private void render(DefinitionTerm node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
    }

    private void render(DefinitionItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        Node child;
        BasedSequence openMarkerChars = node.getChars().prefixOf(node.getFirstChild().getChars());
        BasedSequence openMarker = (BasedSequence)openMarkerChars.subSequence(0, 1);
        BasedSequence openMarkerSpaces = (BasedSequence)openMarkerChars.subSequence(1);
        if (this.options.markerSpaces >= 1 && openMarkerSpaces.length() != this.options.markerSpaces) {
            openMarkerSpaces = SubSequence.of((CharSequence)RepeatedCharSequence.of((char)' ', (int)this.options.markerSpaces));
        }
        switch (this.options.markerType) {
            case ANY: {
                break;
            }
            case COLON: {
                openMarker = SubSequence.of((CharSequence)":");
                break;
            }
            case TILDE: {
                openMarker = SubSequence.of((CharSequence)"~");
            }
        }
        ((MarkdownWriter)((MarkdownWriter)markdown.line()).append((CharSequence)openMarker)).append((CharSequence)openMarkerSpaces);
        RepeatedCharSequence prefix = RepeatedCharSequence.of((char)' ', (int)(context.getFormatterOptions().itemContentIndent ? openMarker.length() + openMarkerSpaces.length() : this.listOptions.getItemIndent()));
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)prefix);
        context.renderChildren((Node)node);
        markdown.popPrefix();
        if (!((Boolean)context.getOptions().get(Parser.BLANK_LINES_IN_AST)).booleanValue() && (child = node.getLastChild()) instanceof Paragraph && ((Paragraph)child).isTrailingBlankLine()) {
            markdown.blankLine();
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new DefinitionNodeFormatter(options);
        }
    }
}

