---
title: Javaはオブジェクト指向言語です
date:  2018-12-26
categories: ["カテゴリーB", "カテゴリーC", "プログラミング(programming)"]
---
Javaはクラスベースのオブジェクト指向プログラミング言語です。
オブジェクト指向とは、現実世界をモデル化する手法のひとつであり、
データ（状態）とそれに関連する振る舞い（処理）をまとめてオブジェクト（物体）として扱います。

<!--more-->

Javaのプログラムは複数のクラスから構成されます。オブジェクト指向におけるクラスとは、オブジェクトの設計図にあたるものです。
各クラスから実体化したオブジェクトはインスタンスと呼ばれます。クラスは再利用可能なソフトウェア部品の単位としてよく使われます。
Javaのクラスはカプセル化・継承・ポリモーフィズムをサポートしています。

Javaでは、クラスに定義する状態を「フィールド」（インスタンス変数）と呼び、振る舞いを「メソッド」と呼びます。
それぞれ、C++で「メンバー変数」「メンバー関数」と呼ばれているものに相当します。
なおJavaのオブジェクト指向は、Smalltalkに代表されるようなメッセージパッシングによるオブジェクト指向ではなく、
C++に代表されるようなクラス機構を中心としたオブジェクト指向です。
後者は、限られた計算機資源でもオブジェクト指向を実現できるというメリットがあります。

継承とは、既存のクラスを基にして、そのクラスの機能を引き継いだ新しいクラスを定義できることをいいます。
継承は拡張とも呼ばれ、Javaのクラス構文では継承の際に`extends`キーワードが使われています。
Javaのクラスはすべて、暗黙的に基底クラス`java.lang.Object`から派生します。
また、C++のような実装の多重継承はサポートせず、単一継承のみをサポートしています。
ただし、クラスは複数のインタフェースを実装 (`implements`) することができます。
Javaのインタフェースは、C++では純粋仮想関数のみを持つクラスに相当し、実装を持たない型でした。
ただし、Java 8以降はインタフェースのデフォルトメソッドにより、実装の多重継承も限定的にサポートするようになっています。
